/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.lm.internal.client;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.branch.CDOBranchPointRef;
import org.eclipse.emf.cdo.common.util.ResourceSetConfigurer;
import org.eclipse.emf.cdo.explorer.checkouts.CDOCheckout;
import org.eclipse.emf.cdo.lm.assembly.Assembly;
import org.eclipse.emf.cdo.lm.assembly.AssemblyModule;
import org.eclipse.emf.cdo.lm.client.IAssemblyDescriptor;
import org.eclipse.emf.cdo.lm.client.ISystemDescriptor;
import org.eclipse.emf.cdo.lm.internal.client.AssemblyDescriptor;
import org.eclipse.emf.cdo.lm.internal.client.LMViewProvider;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.cdo.view.CDOViewProviderRegistry;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.net4j.util.lifecycle.IDeactivateable;

public final class LMResourceSetConfiguration
implements IDeactivateable {
    private final Map<String, CDOView> moduleViews = new HashMap<String, CDOView>();
    private final IAssemblyDescriptor assemblyDescriptor;
    private final ResourceSet resourceSet;

    public LMResourceSetConfiguration(IAssemblyDescriptor assemblyDescriptor, ResourceSet resourceSet) {
        this.assemblyDescriptor = assemblyDescriptor;
        this.resourceSet = resourceSet;
        Assembly assembly = assemblyDescriptor.getAssembly();
        assembly.forEachDependency(module -> this.addView((AssemblyModule)module));
        CDOCheckout checkout = this.getCheckout();
        checkout.waitUntilPrefetched();
    }

    public IAssemblyDescriptor getAssemblyDescriptor() {
        return this.assemblyDescriptor;
    }

    public Assembly getAssembly() {
        return this.assemblyDescriptor.getAssembly();
    }

    public CDOCheckout getCheckout() {
        return this.assemblyDescriptor.getCheckout();
    }

    public ResourceSet getResourceSet() {
        return this.resourceSet;
    }

    public CDOView getView(AssemblyModule assemblyModule) {
        return this.getView(assemblyModule.getName());
    }

    public CDOView getView(String moduleName) {
        return this.moduleViews.get(moduleName);
    }

    public Exception deactivate() {
        try {
            for (CDOView view : this.moduleViews.values()) {
                view.close();
            }
            this.moduleViews.clear();
        }
        finally {
            ((AssemblyDescriptor)this.assemblyDescriptor).removeResourceSet(this);
        }
        return null;
    }

    public String toString() {
        return "LMResourceSetConfiguration[" + this.assemblyDescriptor + " --> " + this.resourceSet + "]";
    }

    public void reconfigure(List<BranchPointDelta> deltas) {
        for (BranchPointDelta delta : deltas) {
            AssemblyModule module = delta.getModule();
            if (module.isRoot()) continue;
            switch (delta.getKind()) {
                case ADDITION: {
                    this.addView(module);
                    break;
                }
                case REMOVAL: {
                    this.removeView(module);
                    break;
                }
                case MODIFICATION: {
                    this.modifyView(module, delta.getNewBranchPoint());
                }
            }
        }
        CDOCheckout checkout = this.getCheckout();
        checkout.waitUntilPrefetched();
    }

    private CDOView addView(AssemblyModule module) {
        ISystemDescriptor systemDescriptor = this.assemblyDescriptor.getSystemDescriptor();
        CDOView view = LMResourceSetConfiguration.openView(systemDescriptor, module, this.resourceSet);
        if (view != null) {
            this.moduleViews.put(module.getName(), view);
        }
        return view;
    }

    private CDOView removeView(AssemblyModule module) {
        CDOView view = this.moduleViews.remove(module.getName());
        if (view != null) {
            view.close();
        }
        return view;
    }

    private CDOView modifyView(AssemblyModule module, CDOBranchPointRef branchPointRef) {
        CDOView view = this.moduleViews.get(module.getName());
        if (view != null) {
            CDOBranchPoint branchPoint = branchPointRef.resolve(view.getSession().getBranchManager());
            view.setBranchPoint(branchPoint);
        }
        return view;
    }

    public static LMResourceSetConfiguration of(ResourceSet resourceSet) {
        ResourceSetConfigurer.Registry.ResourceSetConfiguration resourceSetConfiguration = ResourceSetConfigurer.Registry.ResourceSetConfiguration.of((ResourceSet)resourceSet);
        if (resourceSetConfiguration == null) {
            return null;
        }
        Map configurerResults = resourceSetConfiguration.getConfigurerResults();
        return (LMResourceSetConfiguration)configurerResults.get("lm");
    }

    public static CDOView openView(ISystemDescriptor systemDescriptor, AssemblyModule module, ResourceSet resourceSet) {
        URI viewURI = LMViewProvider.createViewURI(module);
        return CDOViewProviderRegistry.INSTANCE.provideView(viewURI, resourceSet);
    }

    public static final class BranchPointDelta {
        private final AssemblyModule module;
        private final CDOBranchPointRef oldBranchPoint;
        private final CDOBranchPointRef newBranchPoint;

        public BranchPointDelta(AssemblyModule module, CDOBranchPointRef oldBranchPoint, CDOBranchPointRef newBranchPoint) {
            this.module = module;
            this.oldBranchPoint = oldBranchPoint;
            this.newBranchPoint = newBranchPoint;
        }

        public AssemblyModule getModule() {
            return this.module;
        }

        public CDOBranchPointRef getOldBranchPoint() {
            return this.oldBranchPoint;
        }

        public CDOBranchPointRef getNewBranchPoint() {
            return this.newBranchPoint;
        }

        public Kind getKind() {
            if (this.oldBranchPoint == null) {
                return Kind.ADDITION;
            }
            if (this.newBranchPoint == null) {
                return Kind.REMOVAL;
            }
            return Kind.MODIFICATION;
        }

        public String toString() {
            return "BranchPointDelta[module=" + this.module + ", oldBranchPoint=" + this.oldBranchPoint + ", newBranchPoint=" + this.newBranchPoint + "]";
        }

        public static enum Kind {
            ADDITION,
            REMOVAL,
            MODIFICATION;

        }
    }
}

