/*
 * Decompiled with CFR 0.152.
 */
package org.gastro.rcp.internal.table;

import com.swtdesigner.ResourceManager;
import com.swtdesigner.SWTResourceManager;
import java.text.NumberFormat;
import java.util.Map;
import org.eclipse.emf.cdo.CDOObject;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.nebula.widgets.pshelf.AbstractRenderer;
import org.eclipse.nebula.widgets.pshelf.PShelf;
import org.eclipse.nebula.widgets.pshelf.PShelfItem;
import org.eclipse.nebula.widgets.pshelf.RedmondShelfRenderer;
import org.eclipse.net4j.util.StringUtil;
import org.eclipse.net4j.util.ref.ReferenceValueMap;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.part.ViewPart;
import org.gastro.business.BusinessDay;
import org.gastro.business.BusinessFactory;
import org.gastro.business.Order;
import org.gastro.business.OrderDetail;
import org.gastro.inventory.MenuCard;
import org.gastro.inventory.Offering;
import org.gastro.inventory.Section;
import org.gastro.rcp.IModel;

public class TableView
extends ViewPart {
    public static final String ID = "org.gastro.rcp.table.view";
    private static final AdapterFactory FACTORY = IModel.INSTANCE.getAdapterFactory();
    private static final Map<String, String> fakeImages = new ReferenceValueMap.Soft();
    private static int fakeImageID;
    private TreeViewer menuViewer;
    private Label menuTitle;
    private Label menuDescription;
    private Label menuImage;
    private Label menuPrice;
    private Label quantity;
    private Button buttonDelete;
    private Button buttonAdd;
    private EObject currentItem;
    private Adapter currentItemAdapter = new AdapterImpl(){

        public void notifyChanged(Notification msg) {
            try {
                TableView.this.menuViewer.getTree().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            TableView.this.showMenuCard();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    };
    private Order order;
    private OrderDetail orderDetail;
    private Adapter businessDayAdapter = new AdapterImpl(){

        public void notifyChanged(Notification msg) {
            try {
                TableView.this.menuViewer.getTree().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            (this).TableView.this.menuViewer.setInput((Object)IModel.INSTANCE.getBusinessDay().getMenuCard());
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    };
    private TableViewer orderViewer;

    public void setFocus() {
    }

    public void dispose() {
        IModel.INSTANCE.getBusinessDay().eAdapters().remove((Object)this.businessDayAdapter);
        if (this.currentItem != null) {
            this.currentItem.eAdapters().remove((Object)this.currentItemAdapter);
        }
        super.dispose();
    }

    public void createPartControl(Composite parent) {
        BusinessDay businessDay = IModel.INSTANCE.getBusinessDay();
        businessDay.eAdapters().add((Object)this.businessDayAdapter);
        parent.setLayout((Layout)new FillLayout(512));
        PShelf shelf = new PShelf(parent, 0);
        shelf.setForeground(SWTResourceManager.getColor(26));
        shelf.setBackground(SWTResourceManager.getColor(35));
        shelf.setFont(SWTResourceManager.getFont("Comic Sans MS", 24, 1));
        shelf.setRenderer((AbstractRenderer)new RedmondShelfRenderer());
        PShelfItem shelfItem = new PShelfItem(shelf, 0);
        GridLayout gridLayout = new GridLayout(3, false);
        gridLayout.horizontalSpacing = 0;
        gridLayout.marginHeight = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.marginWidth = 0;
        shelfItem.getBody().setLayout((Layout)gridLayout);
        this.menuViewer = new TreeViewer(shelfItem.getBody(), 0);
        this.menuViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                EObject item = (EObject)((IStructuredSelection)event.getSelection()).getFirstElement();
                if (item != TableView.this.currentItem) {
                    if (TableView.this.currentItem != null) {
                        TableView.this.currentItem.eAdapters().remove((Object)TableView.this.currentItemAdapter);
                    }
                    if (item != null) {
                        item.eAdapters().add((Object)TableView.this.currentItemAdapter);
                    }
                    TableView.this.currentItem = item;
                    TableView.this.showMenuCard();
                }
            }
        });
        this.menuViewer.setContentProvider((IContentProvider)new AdapterFactoryContentProvider(FACTORY));
        this.menuViewer.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider(FACTORY){

            public Image getImage(Object object) {
                return null;
            }
        });
        this.menuViewer.setInput((Object)businessDay.getMenuCard());
        Tree tree = this.menuViewer.getTree();
        tree.setForeground(SWTResourceManager.getColor(10));
        tree.setFont(SWTResourceManager.getFont("Comic Sans MS", 16, 1));
        GridData gridData = new GridData(16384, 4, false, true, 1, 1);
        gridData.widthHint = 300;
        tree.setLayoutData((Object)gridData);
        Composite composite = new Composite(shelfItem.getBody(), 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        composite.setBackground(SWTResourceManager.getColor(1));
        composite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.menuTitle = new Label(composite, 0);
        this.menuTitle.setForeground(SWTResourceManager.getColor(10));
        this.menuTitle.setFont(SWTResourceManager.getFont("Comic Sans MS", 16, 1));
        this.menuTitle.setBackground(SWTResourceManager.getColor(1));
        this.menuTitle.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        this.menuTitle.setText("Titel");
        Label label = new Label(composite, 2);
        GridData gridData2 = new GridData(4, 0x1000000, true, false, 1, 1);
        gridData2.heightHint = 2;
        label.setLayoutData((Object)gridData2);
        this.menuDescription = new Label(composite, 64);
        this.menuDescription.setForeground(SWTResourceManager.getColor(10));
        this.menuDescription.setFont(SWTResourceManager.getFont("Comic Sans MS", 16, 1));
        this.menuDescription.setText("Beschreibung");
        this.menuDescription.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.menuDescription.setBackground(SWTResourceManager.getColor(1));
        Composite composite_1 = new Composite(composite, 0);
        composite_1.setLayoutData((Object)new GridData(4, 1024, true, false, 1, 1));
        composite_1.setBackground(SWTResourceManager.getColor(1));
        GridLayout gridLayout_1 = new GridLayout(2, false);
        gridLayout_1.marginWidth = 0;
        gridLayout_1.marginHeight = 0;
        composite_1.setLayout((Layout)gridLayout_1);
        this.menuImage = new Label(composite_1, 0);
        this.menuImage.setLayoutData((Object)new GridData(131072, 1024, true, false, 1, 1));
        this.menuImage.setBackground(SWTResourceManager.getColor(1));
        this.menuImage.setText("Bild");
        this.menuImage.setForeground(SWTResourceManager.getColor(10));
        this.menuImage.setFont(SWTResourceManager.getFont("Comic Sans MS", 16, 1));
        this.menuPrice = new Label(composite_1, 0);
        this.menuPrice.setLayoutData((Object)new GridData(16384, 1024, true, false, 1, 1));
        this.menuPrice.setAlignment(131072);
        this.menuPrice.setForeground(SWTResourceManager.getColor(10));
        this.menuPrice.setFont(SWTResourceManager.getFont("Comic Sans MS", 16, 1));
        this.menuPrice.setBackground(SWTResourceManager.getColor(1));
        this.menuPrice.setText("Preis");
        composite = new Composite(shelfItem.getBody(), 0);
        composite.setBackground(SWTResourceManager.getColor(22));
        GridLayout gridLayout_12 = new GridLayout(1, false);
        gridLayout_12.marginHeight = 0;
        gridLayout_12.marginWidth = 0;
        composite.setLayout((Layout)gridLayout_12);
        composite.setLayoutData((Object)new GridData(16384, 4, false, true, 1, 1));
        Button buttonPrev = new Button(composite, 0);
        buttonPrev.setToolTipText("Voriger Eintrag");
        buttonPrev.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableView.this.prevMenu();
            }
        });
        buttonPrev.setImage(ResourceManager.getPluginImage("org.gastro.rcp.table", "icons/up.png"));
        Label label2 = new Label(composite, 0);
        label2.setLayoutData((Object)new GridData(16384, 4, false, true, 1, 1));
        this.quantity = new Label(composite, 0);
        this.quantity.setForeground(SWTResourceManager.getColor(10));
        this.quantity.setBackground(SWTResourceManager.getColor(22));
        this.quantity.setAlignment(0x1000000);
        this.quantity.setFont(SWTResourceManager.getFont("Comic Sans MS", 32, 1));
        this.quantity.setLayoutData((Object)new GridData(4, 1024, true, false, 1, 1));
        this.quantity.setText("0");
        Composite composite_12 = new Composite(composite, 0);
        composite_12.setBackground(SWTResourceManager.getColor(22));
        composite_12.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        FillLayout fillLayout = new FillLayout(256);
        fillLayout.spacing = 5;
        composite_12.setLayout((Layout)fillLayout);
        this.buttonDelete = new Button(composite_12, 0);
        this.buttonDelete.setToolTipText("Weniger bestellen");
        this.buttonDelete.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableView.this.deleteOrder();
            }
        });
        this.buttonDelete.setImage(ResourceManager.getPluginImage("org.gastro.rcp.table", "icons/delete.gif"));
        this.buttonAdd = new Button(composite_12, 0);
        this.buttonAdd.setToolTipText("Mehr bestellen");
        this.buttonAdd.setImage(ResourceManager.getPluginImage("org.gastro.rcp.table", "icons/add.gif"));
        this.buttonAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableView.this.addOrder();
            }
        });
        label2 = new Label(composite, 0);
        label2.setLayoutData((Object)new GridData(16384, 4, false, true, 1, 1));
        Button buttonNext = new Button(composite, 0);
        buttonNext.setToolTipText("N\u00e4chster Eintrag");
        buttonNext.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableView.this.nextMenu();
            }
        });
        buttonNext.setImage(ResourceManager.getPluginImage("org.gastro.rcp.table", "icons/down.png"));
        shelfItem.setImage(ResourceManager.getPluginImage("org.gastro.rcp.table", "icons/menucard.png"));
        shelfItem.setText(" Speisen und Getr\u00e4nke");
        shelfItem = new PShelfItem(shelf, 0);
        gridLayout = new GridLayout(2, false);
        gridLayout.horizontalSpacing = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        shelfItem.getBody().setLayout((Layout)gridLayout);
        this.orderViewer = new TableViewer(shelfItem.getBody(), 32768);
        Table table = this.orderViewer.getTable();
        table.setLinesVisible(true);
        table.setForeground(SWTResourceManager.getColor(10));
        table.setFont(SWTResourceManager.getFont("Comic Sans MS", 16, 1));
        gridData = new GridData(4, 4, true, true, 1, 1);
        gridData.widthHint = 300;
        table.setLayoutData((Object)gridData);
        TableViewerColumn tableViewerColumn = new TableViewerColumn(this.orderViewer, 0);
        TableColumn tblclmnQuantity = tableViewerColumn.getColumn();
        tblclmnQuantity.setResizable(false);
        tblclmnQuantity.setAlignment(131072);
        tblclmnQuantity.setWidth(70);
        tblclmnQuantity.setText("Quantity");
        tableViewerColumn = new TableViewerColumn(this.orderViewer, 0);
        TableColumn tblclmnOffering = tableViewerColumn.getColumn();
        tblclmnOffering.setWidth(410);
        tblclmnOffering.setText("Offering");
        tableViewerColumn = new TableViewerColumn(this.orderViewer, 0);
        TableColumn tblclmnPrice = tableViewerColumn.getColumn();
        tblclmnPrice.setResizable(false);
        tblclmnPrice.setAlignment(131072);
        tblclmnPrice.setWidth(100);
        tblclmnPrice.setText("Price");
        tableViewerColumn = new TableViewerColumn(this.orderViewer, 0);
        TableColumn tblclmnSum = tableViewerColumn.getColumn();
        tblclmnSum.setResizable(false);
        tblclmnSum.setAlignment(131072);
        tblclmnSum.setWidth(117);
        tblclmnSum.setText("Sum");
        this.orderViewer.setContentProvider((IContentProvider)new AdapterFactoryContentProvider(FACTORY));
        this.orderViewer.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider(FACTORY){

            public String getColumnText(Object object, int columnIndex) {
                switch (columnIndex) {
                    case 0: {
                        return ((OrderDetail)object).getQuantity() + "x";
                    }
                    case 1: {
                        return ((OrderDetail)object).getOffering().getName();
                    }
                    case 2: {
                        return TableView.this.formatPrice(((OrderDetail)object).getOffering().getPrice());
                    }
                    case 3: {
                        return TableView.this.formatPrice(((OrderDetail)object).getPrice());
                    }
                }
                return super.getColumnText(object, columnIndex);
            }

            public Image getColumnImage(Object object, int columnIndex) {
                return null;
            }
        });
        composite = new Composite(shelfItem.getBody(), 0);
        composite.setBackground(SWTResourceManager.getColor(22));
        composite.setLayoutData((Object)new GridData(4, 4, false, true, 1, 1));
        gridLayout_12 = new GridLayout(1, false);
        gridLayout_12.marginHeight = 0;
        gridLayout_12.marginWidth = 0;
        composite.setLayout((Layout)gridLayout_12);
        composite.setBounds(0, 0, 64, 64);
        Button buttonCancel = new Button(composite, 0);
        buttonCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableView.this.cancelOrder();
            }
        });
        buttonCancel.setToolTipText("Bestellung abbrechen");
        buttonCancel.setImage(ResourceManager.getPluginImage("org.gastro.rcp.table", "icons/cancel.png"));
        Label labelTotalPrice = new Label(composite, 0);
        labelTotalPrice.setBackground(SWTResourceManager.getColor(22));
        labelTotalPrice.setAlignment(0x1000000);
        labelTotalPrice.setLayoutData((Object)new GridData(4, 1024, true, true, 1, 1));
        Button buttonSend = new Button(composite, 0);
        buttonSend.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableView.this.sendOrder();
            }
        });
        buttonSend.setToolTipText("Bestellung absenden");
        buttonSend.setImage(ResourceManager.getPluginImage("org.gastro.rcp.table", "icons/send.png"));
        shelfItem.setImage(ResourceManager.getPluginImage("org.gastro.rcp.table", "icons/order.png"));
        shelfItem.setText(" Bestellung");
        shelfItem = new PShelfItem(shelf, 0);
        shelfItem.setImage(ResourceManager.getPluginImage("org.gastro.rcp.table", "icons/payment.png"));
        shelfItem.setText(" Bezahlung");
        shelfItem = new PShelfItem(shelf, 0);
        shelfItem.setImage(ResourceManager.getPluginImage("org.gastro.rcp.table", "icons/service.png"));
        shelfItem.setText(" Service");
        shelf.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableView.this.orderViewer.refresh(true);
            }
        });
        this.createNewOrder();
    }

    protected void nextMenu() {
        EList<EObject> menuItems = this.getAllMenuItems();
        int index = menuItems.indexOf((Object)this.currentItem);
        if (index >= 0 && index < menuItems.size() - 1) {
            this.menuViewer.setSelection((ISelection)new StructuredSelection(menuItems.get(index + 1)));
        }
    }

    protected void prevMenu() {
        EList<EObject> menuItems = this.getAllMenuItems();
        int index = menuItems.indexOf((Object)this.currentItem);
        if (index > 0) {
            this.menuViewer.setSelection((ISelection)new StructuredSelection(menuItems.get(index - 1)));
        }
    }

    protected void showMenuCard() {
        OrderDetail oldOrderDetail = this.orderDetail;
        if (this.currentItem instanceof Section) {
            Section section = (Section)this.currentItem;
            this.updateMenuDetail(section.getTitle(), section.getText(), null, false);
            this.orderDetail = null;
        } else if (this.currentItem instanceof Offering) {
            Offering offering = (Offering)this.currentItem;
            this.updateMenuDetail(offering.getName(), offering.getDescription(), this.formatPrice(offering.getPrice()), true);
            this.orderDetail = this.getOrderDetail(offering);
        }
        if (oldOrderDetail != null && oldOrderDetail != this.orderDetail && oldOrderDetail.getQuantity() == 0) {
            this.order.getOrderDetails().remove((Object)oldOrderDetail);
        }
        this.updateOrderDetail();
    }

    protected void addOrder() {
        if (this.orderDetail == null) {
            this.orderDetail = BusinessFactory.eINSTANCE.createOrderDetail();
            this.orderDetail.setOffering((Offering)this.currentItem);
            this.orderDetail.setQuantity(1);
            this.order.getOrderDetails().add((Object)this.orderDetail);
        } else {
            this.orderDetail.setQuantity(this.orderDetail.getQuantity() + 1);
        }
        this.updateOrderDetail();
    }

    protected void deleteOrder() {
        int quantity = this.orderDetail.getQuantity();
        if (quantity == 1) {
            this.order.getOrderDetails().remove((Object)this.orderDetail);
            this.orderDetail = null;
        } else {
            this.orderDetail.setQuantity(quantity - 1);
        }
        this.updateOrderDetail();
    }

    protected void sendOrder() {
        IModel.ITransactionalOperation<BusinessDay> operation = new IModel.ITransactionalOperation<BusinessDay>(){

            public Object execute(BusinessDay businessDay) {
                businessDay.cdoWriteLock().lock();
                EList orders = businessDay.getOrders();
                TableView.this.order.setNumber(TableView.this.getNextOrderNumber((EList<Order>)orders));
                orders.add((Object)TableView.this.order);
                return null;
            }
        };
        IModel.INSTANCE.modify((CDOObject)IModel.INSTANCE.getBusinessDay(), (IModel.ITransactionalOperation)operation);
        this.createNewOrder();
    }

    protected void cancelOrder() {
        this.createNewOrder();
    }

    private EList<EObject> getAllMenuItems() {
        MenuCard menuCard = (MenuCard)this.menuViewer.getInput();
        BasicEList result = new BasicEList();
        TreeIterator it = menuCard.eAllContents();
        while (it.hasNext()) {
            result.add((Object)((EObject)it.next()));
        }
        return result;
    }

    private void createNewOrder() {
        this.order = BusinessFactory.eINSTANCE.createOrder();
        this.order.setTable((org.gastro.inventory.Table)IModel.INSTANCE.getStation());
        this.orderViewer.setInput((Object)this.order);
        this.orderDetail = null;
        this.updateOrderDetail();
    }

    private int getNextOrderNumber(EList<Order> orders) {
        int count = orders.size();
        if (count > 0) {
            return ((Order)orders.get(count - 1)).getNumber() + 1;
        }
        return 1;
    }

    private OrderDetail getOrderDetail(Offering offering) {
        for (OrderDetail orderDetail : this.order.getOrderDetails()) {
            if (orderDetail.getOffering() != offering) continue;
            return orderDetail;
        }
        return null;
    }

    private void updateMenuDetail(String title, String description, String price, boolean withImage) {
        block5: {
            this.menuTitle.setText(StringUtil.safe((String)title));
            this.menuDescription.setText(StringUtil.safe((String)description));
            this.menuPrice.setText(StringUtil.safe((String)price));
            if (title == null || !withImage) {
                this.menuImage.setImage(null);
            } else {
                String name = fakeImages.get(title);
                if (name == null) {
                    while (true) {
                        Image image;
                        if ((image = this.getCachedImage(name = "meal-" + ++fakeImageID)) != null) {
                            fakeImages.put(title, name);
                            this.menuImage.setImage(this.getCachedImage(name));
                            break block5;
                        }
                        fakeImageID = 0;
                    }
                }
                this.menuImage.setImage(this.getCachedImage(name));
            }
        }
        this.menuImage.getParent().getParent().layout(true);
    }

    private void updateOrderDetail() {
        if (this.currentItem instanceof Offering) {
            if (this.orderDetail != null) {
                this.quantity.setText("" + this.orderDetail.getQuantity());
                this.buttonDelete.setEnabled(true);
            } else {
                this.quantity.setText("0");
                this.buttonDelete.setEnabled(false);
            }
            this.quantity.setVisible(true);
            this.buttonAdd.setVisible(true);
            this.buttonDelete.setVisible(true);
        } else {
            this.quantity.setVisible(false);
            this.buttonAdd.setVisible(false);
            this.buttonDelete.setVisible(false);
        }
    }

    private Image getCachedImage(String name) {
        return ResourceManager.getPluginImage("org.gastro.rcp.table", "images/" + name + ".png");
    }

    private String formatPrice(float price) {
        return NumberFormat.getCurrencyInstance().format(price);
    }
}

