/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.security;

import java.nio.ByteBuffer;
import java.util.Arrays;
import org.eclipse.net4j.internal.util.bundle.OM;
import org.eclipse.net4j.util.security.ChallengeResponseNegotiator;
import org.eclipse.net4j.util.security.INegotiationContext;
import org.eclipse.net4j.util.security.IRandomizer;
import org.eclipse.net4j.util.security.IUserManager;
import org.eclipse.net4j.util.security.NegotiationException;

public class ChallengeNegotiator
extends ChallengeResponseNegotiator {
    public static final int DEFAULT_TOKEN_LENGTH = 1024;
    private int tokenLength = 1024;
    private IRandomizer randomizer;
    private IUserManager userManager;

    public ChallengeNegotiator() {
        super(true);
    }

    public int getTokenLength() {
        return this.tokenLength;
    }

    public void setTokenLength(int tokenLength) {
        this.tokenLength = tokenLength;
    }

    public IRandomizer getRandomizer() {
        return this.randomizer;
    }

    public void setRandomizer(IRandomizer randomizer) {
        this.randomizer = randomizer;
    }

    public IUserManager getUserManager() {
        return this.userManager;
    }

    public void setUserManager(IUserManager userManager) {
        this.userManager = userManager;
    }

    @Override
    protected void doBeforeActivate() throws Exception {
        super.doBeforeActivate();
        if (this.tokenLength <= 0) {
            throw new IllegalStateException("tokenLength must be positive");
        }
        if (this.randomizer == null) {
            throw new IllegalStateException("randomizer == null");
        }
        if (this.userManager == null) {
            throw new IllegalStateException("userManager == null");
        }
    }

    protected byte[] createRandomToken() {
        byte[] token = new byte[this.tokenLength];
        this.randomizer.nextBytes(token);
        return token;
    }

    protected byte[] encryptToken(String userID, byte[] token) throws NegotiationException {
        try {
            return this.userManager.encrypt(userID, token, this.getEncryptionAlgorithmName(), this.getEncryptionSaltBytes(), this.getEncryptionIterationCount());
        }
        catch (Exception ex) {
            OM.LOG.error("Token encryption failed", ex);
            return null;
        }
    }

    @Override
    protected void createChallenge(INegotiationContext context, ByteBuffer challenge) {
        byte[] randomToken = this.createRandomToken();
        context.setInfo(randomToken);
        challenge.putInt(randomToken.length);
        challenge.put(randomToken);
    }

    @Override
    protected boolean handleResponse(INegotiationContext context, ByteBuffer response) {
        byte[] randomToken = (byte[])context.getInfo();
        int size = response.getInt();
        byte[] userIDBytes = new byte[size];
        response.get(userIDBytes);
        String userID = new String(userIDBytes);
        size = response.getInt();
        byte[] responseToken = new byte[size];
        response.get(responseToken);
        byte[] cryptedToken = this.encryptToken(userID, randomToken);
        boolean success = Arrays.equals(responseToken, cryptedToken);
        if (success) {
            context.setUserID(userID);
        }
        return success;
    }
}

