/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.explorer.ui.checkouts;

import org.eclipse.emf.cdo.CDOElement;
import org.eclipse.emf.cdo.common.util.CDOCommonUtil;
import org.eclipse.emf.cdo.explorer.checkouts.CDOCheckout;
import org.eclipse.emf.cdo.explorer.ui.BaseLabelDecorator;
import org.eclipse.emf.cdo.explorer.ui.bundle.OM;
import org.eclipse.emf.cdo.ui.CDOLabelDecorator;
import org.eclipse.emf.cdo.ui.shared.SharedIcons;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.net4j.util.AdapterUtil;
import org.eclipse.net4j.util.lifecycle.LifecycleException;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;
import org.eclipse.swt.graphics.Image;

public class CDOCheckoutLabelDecorator
extends BaseLabelDecorator {
    public static final Image ERROR_OVERLAY = SharedIcons.getImage((String)"ovr16/error.gif");

    @Override
    public Image decorateImage(Image image, Object element) {
        block6: {
            try {
                CDOCheckout checkout;
                if (element instanceof CDOCheckout && (checkout = (CDOCheckout)element).getError() != null) {
                    return OM.getOverlayImage(image, ERROR_OVERLAY, 9, 7);
                }
                CDOElement cdoElement = (CDOElement)AdapterUtil.adapt((Object)element, CDOElement.class);
                if (cdoElement != null) {
                    element = cdoElement.getDelegate();
                }
                if (element instanceof EObject) {
                    return CDOLabelDecorator.decorate((Image)image, (Object)element);
                }
            }
            catch (LifecycleException cdoElement) {
            }
            catch (Throwable ex) {
                if (!LifecycleUtil.isActive((Object)element)) break block6;
                OM.LOG.error(ex);
            }
        }
        return image;
    }

    @Override
    public String decorateText(String text, Object element) {
        block16: {
            try {
                CDOElement cdoElement = (CDOElement)AdapterUtil.adapt((Object)element, CDOElement.class);
                if (cdoElement != null) {
                    element = cdoElement.getDelegate();
                }
                if (element instanceof CDOCheckout) {
                    String error;
                    long timeStamp;
                    CDOCheckout checkout = (CDOCheckout)element;
                    String branchPath = checkout.getBranchPath();
                    if (branchPath != null) {
                        if (branchPath.startsWith("MAIN")) {
                            branchPath = branchPath.substring("MAIN".length());
                        }
                        if (branchPath.startsWith("/")) {
                            branchPath = branchPath.substring("/".length());
                        }
                        if (branchPath.length() != 0) {
                            text = checkout.isOffline() ? String.valueOf(text) + "  [offline: " + branchPath + "]" : String.valueOf(text) + "  [" + branchPath + "]";
                        } else if (checkout.isOffline()) {
                            text = String.valueOf(text) + "  [offline]";
                        }
                    }
                    if ((timeStamp = checkout.getTimeStamp()) != 0L) {
                        text = String.valueOf(text) + "  " + CDOCommonUtil.formatTimeStamp((long)timeStamp);
                    } else if (checkout.isReadOnly()) {
                        text = String.valueOf(text) + "  read-only";
                    }
                    if (checkout.isOffline()) {
                        text = checkout.isDirty() ? String.valueOf(text) + "  dirty" : String.valueOf(text) + "  clean";
                    }
                    if ((error = checkout.getError()) != null) {
                        text = String.valueOf(text) + "  " + error;
                    }
                }
            }
            catch (LifecycleException cdoElement) {
            }
            catch (Throwable ex) {
                if (!LifecycleUtil.isActive((Object)element)) break block16;
                OM.LOG.error(ex);
            }
        }
        return text;
    }
}

