/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.tests.lm;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.cdo.lm.Change;
import org.eclipse.emf.cdo.lm.Stream;
import org.eclipse.emf.cdo.lm.System;
import org.eclipse.emf.cdo.lm.client.IAssemblyDescriptor;
import org.eclipse.emf.cdo.lm.client.ISystemDescriptor;
import org.eclipse.emf.cdo.tests.lm.AbstractLMTest;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.common.util.URI;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;

public class LMFlowsTest
extends AbstractLMTest {
    private static final String INITIAL_STREAM = "InitialStream";
    private static final String MODULE_CLIENT = "ModuleClient";
    private static final String MODULE_SUPPLIER = "ModuleSupplier";
    private static final String MODULE_SUPPLIER_A = "ModuleSupplierA";
    private static final String MODULE_SUPPLIER_B = "ModuleSupplierB";
    private static final String CHANGE_1 = "Change1";

    public void testEntireNormalFlow() throws Exception {
        ISystemDescriptor systemDescriptor = LMFlowsTest.createSystemRepository();
        System system = systemDescriptor.getSystem();
        AbstractLMTest.ModuleCreationResult supplierModuleCreationResult = this.createModule(systemDescriptor, system, MODULE_SUPPLIER, INITIAL_STREAM, 0, 1);
        Stream supplierStream = supplierModuleCreationResult.stream;
        IAssemblyDescriptor supplierStreamDescriptor = supplierModuleCreationResult.assemblyDescriptor;
        Change change1 = this.createChange(systemDescriptor, supplierStream, CHANGE_1, "ModuleSupplier - Change1", transaction -> transaction.createResource(MODULE_SUPPLIER_A));
        this.deliverChange(systemDescriptor, supplierStream, change1);
        CDOView view = supplierStreamDescriptor.getCheckout().openView();
        MatcherAssert.assertThat((Object)view.hasResource(MODULE_SUPPLIER_A), (Matcher)CoreMatchers.is((Object)true));
        view.close();
        AbstractLMTest.ModuleCreationResult clientModuleCreationResult = this.createModule(systemDescriptor, system, MODULE_CLIENT, INITIAL_STREAM, 0, 1);
        IAssemblyDescriptor clientStreamDescriptor = clientModuleCreationResult.assemblyDescriptor;
        this.createDependencyAndUpdate(clientStreamDescriptor, MODULE_SUPPLIER);
        this.editStream(supplierStreamDescriptor, transaction -> transaction.createResource(MODULE_SUPPLIER_B));
        URI uri = URI.createURI((String)"cdo://ModuleSupplier/ModuleSupplierB");
        this.publishTagUpdateClientAndCheckUri(systemDescriptor, system, supplierStream, clientStreamDescriptor, uri);
        this.removeDependencies(clientStreamDescriptor);
        this.createDependencyAndUpdate(clientStreamDescriptor, MODULE_SUPPLIER);
        Change change2 = this.createChange(systemDescriptor, supplierStream, "Change2", "ModuleSupplier - Change2", transaction -> transaction.createResource("To Be Deleted"));
        systemDescriptor.deleteChange(change2, (IProgressMonitor)new NullProgressMonitor());
        Change change3 = this.createChange(systemDescriptor, supplierStream, "Change3", "ModuleSupplier - Change3", transaction -> transaction.createResource("Not Deleteable"));
        this.deliverChange(systemDescriptor, supplierStream, change3);
        try {
            systemDescriptor.deleteChange(change3, (IProgressMonitor)new NullProgressMonitor());
            LMFlowsTest.fail((String)"ChangeDeletionException expected");
        }
        catch (ISystemDescriptor.ChangeDeletionException changeDeletionException) {
            // empty catch block
        }
    }
}

