/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.explorer.ui.repositories;

import org.eclipse.emf.cdo.explorer.repositories.CDORepository;
import org.eclipse.emf.cdo.explorer.ui.BaseLabelDecorator;
import org.eclipse.emf.cdo.explorer.ui.bundle.OM;
import org.eclipse.emf.cdo.ui.shared.SharedIcons;
import org.eclipse.swt.graphics.Image;

public class CDORepositoryLabelDecorator
extends BaseLabelDecorator {
    private static final String KEYWORD_SYSTEM = "org.eclipse.emf.cdo.lm.System";
    private static final String KEYWORD_MODULE = "org.eclipse.emf.cdo.lm.Module";
    private final Image systemOverlay = SharedIcons.getImage((String)"ovr16/system.gif");
    private final Image moduleOverlay = SharedIcons.getImage((String)"ovr16/module.gif");
    private final Image securityOverlay = SharedIcons.getImage((String)"ovr16/security.gif");

    @Override
    public String decorateText(String text, Object element) {
        if (element instanceof CDORepository) {
            CDORepository repository = (CDORepository)element;
            text = String.valueOf(text) + "  " + repository.getURI();
        }
        return text;
    }

    @Override
    public Image decorateImage(Image image, Object element) {
        if (element instanceof CDORepository) {
            CDORepository repository = (CDORepository)element;
            if (repository.hasKeyword(KEYWORD_SYSTEM)) {
                image = OM.getOverlayImage(image, this.systemOverlay, 7, 0);
            } else if (repository.hasKeyword(KEYWORD_MODULE)) {
                image = OM.getOverlayImage(image, this.moduleOverlay, 7, 0);
            }
            if (repository.isAuthenticating()) {
                image = OM.getOverlayImage(image, this.securityOverlay, 1, 7);
            }
        }
        return image;
    }
}

