/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.security;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.cdo.common.revision.CDORevisionProvider;
import org.eclipse.emf.cdo.internal.security.ViewCreator;
import org.eclipse.emf.cdo.view.CDOView;

public final class PermissionUtil {
    private static final ThreadLocal<String> USER = new ThreadLocal();
    private static final ThreadLocal<ViewCreator> VIEW_CREATOR = new ThreadLocal();
    private static final ThreadLocal<Map<CDORevisionProvider, CDOView>> VIEWS = new ThreadLocal();

    private PermissionUtil() {
    }

    public static String getUser() {
        return USER.get();
    }

    public static void setUser(String user) {
        if (user == null) {
            USER.remove();
        } else {
            USER.set(user);
        }
    }

    private static Map<CDORevisionProvider, CDOView> getViews() {
        Map<CDORevisionProvider, CDOView> views = VIEWS.get();
        if (views == null) {
            views = new HashMap<CDORevisionProvider, CDOView>();
            VIEWS.set(views);
        }
        return views;
    }

    public static CDOView getView(CDORevisionProvider revisionProvider) {
        Map<CDORevisionProvider, CDOView> views = PermissionUtil.getViews();
        CDOView view = views.get(revisionProvider);
        if (view == null) {
            ViewCreator viewCreator = VIEW_CREATOR.get();
            if (viewCreator == null) {
                throw new IllegalStateException("No view creator available for " + revisionProvider);
            }
            view = viewCreator.createView(revisionProvider);
            views.put(revisionProvider, view);
        }
        return view;
    }

    public static void initViewCreation(ViewCreator viewCreator) {
        VIEW_CREATOR.set(viewCreator);
    }

    public static void doneViewCreation() {
        VIEW_CREATOR.remove();
        VIEWS.remove();
    }
}

