/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.lm.modules.provider;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.cdo.etypes.provider.ModelElementItemProvider;
import org.eclipse.emf.cdo.lm.modules.DependencyDefinition;
import org.eclipse.emf.cdo.lm.modules.ModulesPackage;
import org.eclipse.emf.cdo.lm.modules.provider.ModulesEditPlugin;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ViewerNotification;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.net4j.util.container.IPluginContainer;
import org.eclipse.net4j.util.factory.Factory;
import org.eclipse.net4j.util.factory.ProductCreationException;

public class DependencyDefinitionItemProvider
extends ModelElementItemProvider {
    private static final TargetNameProvider TARGET_NAME_PROVIDER = DependencyDefinitionItemProvider.initTargetNameProvider();

    public DependencyDefinitionItemProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    public List<IItemPropertyDescriptor> getPropertyDescriptors(Object object) {
        if (this.itemPropertyDescriptors == null) {
            super.getPropertyDescriptors(object);
            this.addTargetNamePropertyDescriptor(object);
            this.addVersionRangePropertyDescriptor(object);
        }
        return this.itemPropertyDescriptors;
    }

    protected void addTargetNamePropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(new ItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_DependencyDefinition_targetName_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_DependencyDefinition_targetName_feature", "_UI_DependencyDefinition_type"), (EStructuralFeature)ModulesPackage.Literals.DEPENDENCY_DEFINITION__TARGET_NAME, true, false, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null, null){

            public Collection<?> getChoiceOfValues(Object object) {
                return TARGET_NAME_PROVIDER.getTargetNames((DependencyDefinition)object);
            }
        });
    }

    protected void addVersionRangePropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_DependencyDefinition_versionRange_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_DependencyDefinition_versionRange_feature", "_UI_DependencyDefinition_type"), (EStructuralFeature)ModulesPackage.Literals.DEPENDENCY_DEFINITION__VERSION_RANGE, true, false, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
    }

    public Object getImage(Object object) {
        return this.overlayImage(object, this.getResourceLocator().getImage("full/obj16/DependencyDefinition"));
    }

    protected boolean shouldComposeCreationImage() {
        return true;
    }

    public String getText(Object object) {
        VersionRange versionRange;
        DependencyDefinition dependencyDefinition = (DependencyDefinition)object;
        String label = dependencyDefinition.getTargetName();
        if (label != null && (versionRange = dependencyDefinition.getVersionRange()) != null) {
            label = String.valueOf(label) + " " + versionRange;
        }
        return label == null || label.length() == 0 ? this.getString("_UI_DependencyDefinition_type") : String.valueOf(this.getString("_UI_DependencyDefinition_type")) + " " + label;
    }

    public void notifyChanged(Notification notification) {
        this.updateChildren(notification);
        switch (notification.getFeatureID(DependencyDefinition.class)) {
            case 2: 
            case 3: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), false, true));
                return;
            }
        }
        super.notifyChanged(notification);
    }

    protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
        super.collectNewChildDescriptors(newChildDescriptors, object);
    }

    public ResourceLocator getResourceLocator() {
        return ModulesEditPlugin.INSTANCE;
    }

    private static TargetNameProvider initTargetNameProvider() {
        final ArrayList providers = new ArrayList();
        IPluginContainer.INSTANCE.forEachElement("org.eclipse.emf.cdo.lm.modules.targetNameProviders", TargetNameProvider.class, provider -> {
            if (provider != null) {
                providers.add(provider);
            }
        });
        return new TargetNameProvider(){

            @Override
            public Collection<String> getTargetNames(DependencyDefinition dependency) {
                for (TargetNameProvider provider : providers) {
                    try {
                        Collection<String> targetNames = provider.getTargetNames(dependency);
                        if (targetNames == null) continue;
                        return targetNames;
                    }
                    catch (Exception ex) {
                        ModulesEditPlugin.INSTANCE.log(ex);
                    }
                }
                return null;
            }
        };
    }

    public static interface TargetNameProvider {
        public Collection<String> getTargetNames(DependencyDefinition var1);

        public static abstract class Factory
        extends org.eclipse.net4j.util.factory.Factory {
            public static final String PRODUCT_GROUP = "org.eclipse.emf.cdo.lm.modules.targetNameProviders";

            public Factory(String type) {
                super(PRODUCT_GROUP, type);
            }

            public abstract TargetNameProvider create(String var1) throws ProductCreationException;
        }
    }
}

