/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.concurrent;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.eclipse.net4j.util.concurrent.ICorrelator;
import org.eclipse.net4j.util.concurrent.ISynchronizer;
import org.eclipse.net4j.util.concurrent.ResultSynchronizer;

public class SynchronizingCorrelator<CORRELATION, RESULT>
implements ICorrelator<CORRELATION, ISynchronizer<RESULT>> {
    private final ConcurrentMap<CORRELATION, ISynchronizer<RESULT>> map = new ConcurrentHashMap<CORRELATION, ISynchronizer<RESULT>>(0);

    public ISynchronizer<RESULT> getSynchronizer(CORRELATION correlation) {
        return (ISynchronizer)this.map.get(correlation);
    }

    @Override
    public boolean isCorrelated(CORRELATION correlation) {
        return this.map.containsKey(correlation);
    }

    @Override
    public ISynchronizer<RESULT> correlate(CORRELATION correlation) {
        ISynchronizer<RESULT> synchronizer = (ISynchronizer<RESULT>)this.map.get(correlation);
        if (synchronizer == null) {
            synchronizer = this.createSynchronizer(correlation);
            this.map.put(correlation, synchronizer);
        }
        return synchronizer;
    }

    @Override
    public ISynchronizer<RESULT> correlateUnique(CORRELATION correlation) {
        ISynchronizer<RESULT> synchronizer = this.createSynchronizer(correlation);
        if (this.map.putIfAbsent(correlation, synchronizer) != null) {
            throw new IllegalStateException("Already correlated: " + correlation);
        }
        return synchronizer;
    }

    @Override
    public ISynchronizer<RESULT> uncorrelate(CORRELATION correlation) {
        return (ISynchronizer)this.map.remove(correlation);
    }

    public RESULT get(CORRELATION correlation, long timeout) {
        return this.correlate((Object)correlation).get(timeout);
    }

    public void put(CORRELATION correlation, RESULT result) {
        this.correlate((Object)correlation).put(result);
    }

    public boolean putIfCorrelated(CORRELATION correlation, RESULT result) {
        ISynchronizer<RESULT> synchronizer = this.getSynchronizer(correlation);
        if (synchronizer != null) {
            synchronizer.put(result);
            return true;
        }
        return false;
    }

    public boolean put(CORRELATION correlation, RESULT result, long timeout) {
        return this.correlate((Object)correlation).put(result, timeout);
    }

    protected ISynchronizer<RESULT> createSynchronizer(final CORRELATION correlation) {
        return new ISynchronizer<RESULT>(){
            private ISynchronizer<RESULT> delegate = new ResultSynchronizer();

            @Override
            public RESULT get(long timeout) {
                Object result = this.delegate.get(timeout);
                SynchronizingCorrelator.this.uncorrelate(correlation);
                return result;
            }

            @Override
            public void put(RESULT result) {
                this.delegate.put(result);
            }

            @Override
            public boolean put(RESULT result, long timeout) {
                return this.delegate.put(result, timeout);
            }
        };
    }

    public String toString() {
        return "SynchronizingCorrelator" + this.map;
    }
}

