/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.spi.server;

import java.util.function.Consumer;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.lock.IDurableLockingManager;
import org.eclipse.emf.cdo.server.IView;
import org.eclipse.emf.cdo.spi.server.InternalLockManager;
import org.eclipse.emf.cdo.spi.server.InternalSession;
import org.eclipse.emf.cdo.spi.server.InternalView;
import org.eclipse.net4j.util.CheckUtil;
import org.eclipse.net4j.util.concurrent.Holder;

public final class SyncingUtil {
    private SyncingUtil() {
    }

    public static InternalView openViewWithLockArea(InternalSession session, InternalLockManager lockManager, CDOBranch viewedBranch, String lockAreaID) {
        IDurableLockingManager.LockArea lockArea;
        Holder viewHolder = new Holder();
        try {
            lockArea = lockManager.getLockArea(lockAreaID);
            lockManager.openView(session, 0, true, lockAreaID, (Consumer<IView>)viewHolder, null);
        }
        catch (IDurableLockingManager.LockAreaNotFoundException e) {
            InternalView view = session.openView(0, viewedBranch.getHead());
            lockArea = lockManager.createLockArea(view, lockAreaID);
            view.setDurableLockingID(lockAreaID);
            viewHolder.set((Object)view);
        }
        CheckUtil.checkNull((Object)lockAreaID, (String)"lockAreaID");
        CheckUtil.checkNull((Object)lockArea, (String)"lockArea");
        CheckUtil.checkState((boolean)lockAreaID.equals(lockArea.getDurableLockingID()), (String)"lockAreaID has incorrect value");
        return (InternalView)viewHolder.get();
    }
}

