/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.common.revision;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.branch.CDOBranchManager;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.branch.CDOBranchPointRange;
import org.eclipse.emf.cdo.common.branch.CDOBranchVersion;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.revision.CDORevisionCache;
import org.eclipse.emf.cdo.common.revision.CDORevisionFactory;
import org.eclipse.emf.cdo.common.revision.CDORevisionHandler;
import org.eclipse.emf.cdo.common.revision.CDORevisionManager;
import org.eclipse.emf.cdo.common.revision.CDORevisionUtil;
import org.eclipse.emf.cdo.common.revision.CDORevisionsLoadedEvent;
import org.eclipse.emf.cdo.internal.common.bundle.OM;
import org.eclipse.emf.cdo.internal.common.revision.AbstractCDORevisionCache;
import org.eclipse.emf.cdo.spi.common.revision.DetachedCDORevision;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevisionCache;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevisionManager;
import org.eclipse.emf.cdo.spi.common.revision.PointerCDORevision;
import org.eclipse.emf.cdo.spi.common.revision.RevisionInfo;
import org.eclipse.emf.cdo.spi.common.revision.SyntheticCDORevision;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.net4j.util.ObjectUtil;
import org.eclipse.net4j.util.ReflectUtil;
import org.eclipse.net4j.util.event.Event;
import org.eclipse.net4j.util.event.INotifier;
import org.eclipse.net4j.util.lifecycle.Lifecycle;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;
import org.eclipse.net4j.util.om.trace.ContextTracer;

public class CDORevisionManagerImpl
extends Lifecycle
implements InternalCDORevisionManager {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG_REVISION, CDORevisionManagerImpl.class);
    private boolean supportingAudits;
    private boolean supportingBranches;
    private InternalCDORevisionManager.RevisionLoader revisionLoader;
    private InternalCDORevisionManager.RevisionLocker revisionLocker;
    private CDORevisionFactory factory;
    private InternalCDORevisionCache cache;
    @ReflectUtil.ExcludeFromDump
    private transient Object loadAndAddLock = new Object(){

        public String toString() {
            return "LoadAndAddLock";
        }
    };
    @ReflectUtil.ExcludeFromDump
    private transient Object reviseLock = new Object(){

        public String toString() {
            return "ReviseLock";
        }
    };

    @Override
    public boolean isSupportingAudits() {
        return this.supportingAudits;
    }

    @Override
    public void setSupportingAudits(boolean on) {
        this.checkInactive();
        this.supportingAudits = on;
    }

    @Override
    public boolean isSupportingBranches() {
        return this.supportingBranches;
    }

    @Override
    public void setSupportingBranches(boolean on) {
        this.checkInactive();
        this.supportingBranches = on;
    }

    @Override
    public InternalCDORevisionManager.RevisionLoader getRevisionLoader() {
        return this.revisionLoader;
    }

    @Override
    public void setRevisionLoader(InternalCDORevisionManager.RevisionLoader revisionLoader) {
        this.checkInactive();
        this.revisionLoader = revisionLoader;
    }

    @Override
    public InternalCDORevisionManager.RevisionLocker getRevisionLocker() {
        return this.revisionLocker;
    }

    @Override
    public void setRevisionLocker(InternalCDORevisionManager.RevisionLocker revisionLocker) {
        this.checkInactive();
        this.revisionLocker = revisionLocker;
    }

    @Override
    public CDORevisionFactory getFactory() {
        return this.factory;
    }

    @Override
    public void setFactory(CDORevisionFactory factory) {
        this.checkInactive();
        this.factory = factory;
    }

    @Override
    public InternalCDORevisionCache getCache() {
        return this.cache;
    }

    @Override
    public void setCache(CDORevisionCache cache) {
        this.checkInactive();
        this.cache = (InternalCDORevisionCache)cache;
    }

    @Override
    public EClass getObjectType(CDOID id, CDOBranchManager branchManagerForLoadOnDemand) {
        CDOBranch mainBranch;
        InternalCDORevision revision;
        EClass type = this.cache.getObjectType(id);
        if (type == null && branchManagerForLoadOnDemand != null && (revision = this.getRevisionByVersion(id, (mainBranch = branchManagerForLoadOnDemand.getMainBranch()).getVersion(1), 0, true)) != null) {
            type = revision.getEClass();
        }
        return type;
    }

    @Override
    public EClass getObjectType(CDOID id) {
        return this.getObjectType(id, null);
    }

    @Override
    public boolean containsRevision(CDOID id, CDOBranchPoint branchPoint) {
        if (this.supportingBranches) {
            return this.getRevision(id, branchPoint, -1, 0, false, null) != null;
        }
        return this.getCachedRevision(id, branchPoint) != null;
    }

    @Override
    public boolean containsRevisionByVersion(CDOID id, CDOBranchVersion branchVersion) {
        return this.cache.getRevisionByVersion(id, branchVersion) != null;
    }

    @Override
    public void reviseLatest(CDOID id, CDOBranch branch) {
        this.acquireAtomicRequestLock(this.reviseLock);
        try {
            InternalCDORevision revision = (InternalCDORevision)this.cache.getRevision(id, branch.getHead());
            if (revision != null) {
                CDOBranchVersion version = branch.getVersion(revision.getVersion());
                this.cache.removeRevision(id, version);
            }
        }
        finally {
            this.releaseAtomicRequestLock(this.reviseLock);
        }
    }

    @Override
    public void reviseVersion(CDOID id, CDOBranchVersion branchVersion, long timeStamp) {
        this.acquireAtomicRequestLock(this.reviseLock);
        try {
            InternalCDORevision revision = this.getCachedRevisionByVersion(id, branchVersion);
            if (revision != null) {
                if (timeStamp == 0L || !this.supportingAudits) {
                    this.cache.removeRevision(id, branchVersion);
                }
                revision.setRevised(timeStamp - 1L);
            }
        }
        finally {
            this.releaseAtomicRequestLock(this.reviseLock);
        }
    }

    @Override
    public InternalCDORevision getRevisionByVersion(CDOID id, CDOBranchVersion branchVersion, int referenceChunk, boolean loadOnDemand) {
        this.checkArg(branchVersion.getVersion() >= 1, "Invalid version: " + branchVersion.getVersion());
        this.acquireAtomicRequestLock(this.loadAndAddLock);
        try {
            InternalCDORevision revision = this.getCachedRevisionByVersion(id, branchVersion);
            if (revision == null && loadOnDemand) {
                if (TRACER.isEnabled()) {
                    TRACER.format("Loading revision {0} from {1}", new Object[]{id, branchVersion});
                }
                revision = this.revisionLoader.loadRevisionByVersion(id, branchVersion, referenceChunk);
                revision = (InternalCDORevision)this.internRevision(revision);
            }
            InternalCDORevision internalCDORevision = revision;
            return internalCDORevision;
        }
        finally {
            this.releaseAtomicRequestLock(this.loadAndAddLock);
        }
    }

    @Override
    public InternalCDORevision getBaseRevision(CDORevision revision, int referenceChunk, boolean loadOnDemand) {
        CDOID id = revision.getID();
        CDOBranch branch = revision.getBranch();
        int version = revision.getVersion();
        if (version == 1) {
            if (branch.isMainBranch()) {
                return null;
            }
            CDOBranchPoint basePoint = branch.getBase();
            return this.getRevision(id, basePoint, referenceChunk, 0, loadOnDemand);
        }
        CDOBranchVersion baseVersion = branch.getVersion(version - 1);
        return this.getRevisionByVersion(id, baseVersion, referenceChunk, loadOnDemand);
    }

    @Override
    public CDOBranchPointRange getObjectLifetime(CDOID id, CDOBranchPoint branchPoint) {
        if (this.revisionLoader instanceof InternalCDORevisionManager.RevisionLoader2) {
            InternalCDORevisionManager.RevisionLoader2 revisionLoader2 = (InternalCDORevisionManager.RevisionLoader2)this.revisionLoader;
            return revisionLoader2.loadObjectLifetime(id, branchPoint);
        }
        return null;
    }

    @Override
    public InternalCDORevision getRevision(CDOID id, CDOBranchPoint branchPoint, int referenceChunk, int prefetchDepth, boolean loadOnDemand) {
        return this.getRevision(id, branchPoint, referenceChunk, prefetchDepth, loadOnDemand, null);
    }

    @Override
    public InternalCDORevision getRevision(CDOID id, CDOBranchPoint branchPoint, int referenceChunk, int prefetchDepth, boolean loadOnDemand, SyntheticCDORevision[] synthetics) {
        List<CDOID> ids = Collections.singletonList(id);
        List<CDORevision> results = this.getRevisions(ids, branchPoint, referenceChunk, prefetchDepth, loadOnDemand, synthetics);
        return (InternalCDORevision)results.get(0);
    }

    @Override
    public List<CDORevision> getRevisions(List<CDOID> ids, CDOBranchPoint branchPoint, int referenceChunk, int prefetchDepth, boolean loadOnDemand) {
        return this.getRevisions(ids, branchPoint, referenceChunk, prefetchDepth, loadOnDemand, (SyntheticCDORevision[])null);
    }

    @Override
    public List<CDORevision> getRevisions(List<CDOID> ids, CDOBranchPoint branchPoint, int referenceChunk, int prefetchDepth, boolean loadOnDemand, SyntheticCDORevision[] synthetics) {
        return this.getRevisions(ids, branchPoint, referenceChunk, prefetchDepth, false, loadOnDemand, synthetics, null, null);
    }

    @Override
    public List<CDORevision> getRevisions(List<CDOID> ids, CDOBranchPoint branchPoint, int referenceChunk, int prefetchDepth, boolean prefetchLockStates, boolean loadOnDemand, SyntheticCDORevision[] synthetics) {
        return this.getRevisions(ids, branchPoint, referenceChunk, prefetchDepth, prefetchLockStates, loadOnDemand, synthetics, null, null);
    }

    @Override
    public List<CDORevision> getRevisions(List<CDOID> ids, CDOBranchPoint branchPoint, int referenceChunk, int prefetchDepth, boolean loadOnDemand, List<CDORevision> additionalRevisions) {
        return this.getRevisions(ids, branchPoint, referenceChunk, prefetchDepth, false, loadOnDemand, null, additionalRevisions, null);
    }

    private List<CDORevision> getRevisions(List<CDOID> ids, CDOBranchPoint branchPoint, int referenceChunk, int prefetchDepth, boolean prefetchLockStates, boolean loadOnDemand, SyntheticCDORevision[] synthetics, List<CDORevision> additionalRevisions, Consumer<CDORevision> consumer) {
        List<RevisionInfo> infosToLoad;
        RevisionInfo[] allInfos = new RevisionInfo[ids.size()];
        if (additionalRevisions == null) {
            additionalRevisions = new ArrayList<CDORevision>();
        }
        if ((infosToLoad = this.createRevisionInfos(ids, branchPoint, prefetchDepth, loadOnDemand, allInfos)) != null) {
            this.loadRevisions(infosToLoad, branchPoint, referenceChunk, prefetchDepth, prefetchLockStates, additionalRevisions, consumer);
        }
        List<CDORevision> primaryRevisions = this.processResults(allInfos, synthetics, consumer);
        if (!(infosToLoad == null || ObjectUtil.isEmpty(primaryRevisions) && ObjectUtil.isEmpty(additionalRevisions))) {
            if (primaryRevisions == null) {
                primaryRevisions = Collections.emptyList();
            }
            additionalRevisions = Collections.unmodifiableList(additionalRevisions);
            this.fireEvent(new RevisionsLoadedEvent(this, primaryRevisions, additionalRevisions, prefetchDepth));
        }
        return primaryRevisions;
    }

    @Override
    public void prefetchRevisions(CDOID id, CDOBranchPoint branchPoint, int prefetchDepth, boolean prefetchLockStates, Consumer<CDORevision> consumer) {
        List<CDOID> ids = Collections.singletonList(id);
        this.getRevisions(ids, branchPoint, -1, prefetchDepth, prefetchLockStates, true, null, null, consumer);
    }

    @Override
    public void handleRevisions(EClass eClass, CDOBranch branch, boolean exactBranch, long timeStamp, boolean exactTime, CDORevisionHandler handler) {
        this.revisionLoader.handleRevisions(eClass, branch, exactBranch, timeStamp, exactTime, handler);
    }

    public String toString() {
        return "RevisionManager";
    }

    private List<RevisionInfo> createRevisionInfos(List<CDOID> ids, CDOBranchPoint branchPoint, int prefetchDepth, boolean loadOnDemand, RevisionInfo[] allInfos) {
        ArrayList<RevisionInfo> infosToLoad = null;
        boolean prefetching = prefetchDepth != 0;
        Iterator<CDOID> idIterator = ids.iterator();
        int i = 0;
        while (i < allInfos.length) {
            RevisionInfo info;
            CDOID id = idIterator.next();
            allInfos[i] = info = this.createRevisionInfo(id, branchPoint);
            if (loadOnDemand && (prefetching || info.isLoadNeeded())) {
                if (infosToLoad == null) {
                    infosToLoad = new ArrayList<RevisionInfo>(1);
                }
                infosToLoad.add(info);
            }
            ++i;
        }
        return infosToLoad;
    }

    private RevisionInfo createRevisionInfo(CDOID id, CDOBranchPoint branchPoint) {
        InternalCDORevision revision = this.getCachedRevision(id, branchPoint);
        if (revision != null) {
            return this.createRevisionInfoAvailable(revision, branchPoint);
        }
        if (this.supportingBranches && (revision = this.getCachedRevisionRecursively(id, branchPoint)) != null) {
            return this.createRevisionInfoAvailable(revision, branchPoint);
        }
        return this.createRevisionInfoMissing(id, branchPoint);
    }

    private RevisionInfo.Available createRevisionInfoAvailable(InternalCDORevision revision, CDOBranchPoint requestedBranchPoint) {
        CDOID id = revision.getID();
        if (revision instanceof PointerCDORevision) {
            InternalCDORevision targetRevision;
            CDOBranchVersion target = ((PointerCDORevision)revision).getTarget();
            InternalCDORevision internalCDORevision = targetRevision = target == null ? null : this.getCachedRevisionByVersion(id, target);
            if (targetRevision != null) {
                target = targetRevision;
            }
            return new RevisionInfo.Available.Pointer(id, requestedBranchPoint, revision, target);
        }
        if (revision instanceof DetachedCDORevision) {
            return new RevisionInfo.Available.Detached(id, requestedBranchPoint, revision);
        }
        return new RevisionInfo.Available.Normal(id, requestedBranchPoint, revision);
    }

    private RevisionInfo.Missing createRevisionInfoMissing(CDOID id, CDOBranchPoint requestedBranchPoint) {
        return new RevisionInfo.Missing(id, requestedBranchPoint);
    }

    protected void loadRevisions(List<RevisionInfo> infosToLoad, CDOBranchPoint branchPoint, int referenceChunk, int prefetchDepth, boolean prefetchLockStates, List<CDORevision> additionalRevisions, Consumer<CDORevision> consumer) {
        this.acquireAtomicRequestLock(this.loadAndAddLock);
        try {
            List<RevisionInfo> additionalRevisionInfos = ((InternalCDORevisionManager.RevisionLoader3)this.revisionLoader).loadRevisions(infosToLoad, branchPoint, referenceChunk, prefetchDepth, prefetchLockStates);
            if (additionalRevisionInfos != null) {
                for (RevisionInfo info : additionalRevisionInfos) {
                    this.processResult(info, additionalRevisions, null, 0, consumer);
                }
            }
        }
        finally {
            this.releaseAtomicRequestLock(this.loadAndAddLock);
        }
    }

    private List<CDORevision> processResults(RevisionInfo[] infos, SyntheticCDORevision[] synthetics, Consumer<CDORevision> consumer) {
        ArrayList<CDORevision> results = new ArrayList<CDORevision>(infos.length);
        int i = 0;
        while (i < infos.length) {
            this.processResult(infos[i], results, synthetics, i, consumer);
            ++i;
        }
        return results;
    }

    private void processResult(RevisionInfo info, List<CDORevision> results, SyntheticCDORevision[] synthetics, int i, Consumer<CDORevision> consumer) {
        info.processResult(this, results, synthetics, i);
        if (consumer != null) {
            InternalCDORevision revision = info.getSynthetic();
            if (revision == null) {
                revision = info.getResult();
            }
            if (revision != null) {
                consumer.accept(revision);
            }
        }
    }

    @Override
    public CDORevision internRevision(CDORevision revision) {
        if (revision != null) {
            this.acquireAtomicRequestLock(this.loadAndAddLock);
            try {
                int oldVersion = revision.getVersion() - 1;
                if (oldVersion >= 0) {
                    CDOID id = revision.getID();
                    CDOBranchVersion old = revision.getBranch().getVersion(oldVersion);
                    InternalCDORevision oldRevision = this.getCachedRevisionByVersion(id, old);
                    if (!revision.isHistorical()) {
                        if (oldRevision != null) {
                            oldRevision.setRevised(revision.getTimeStamp() - 1L);
                        } else {
                            InternalCDORevision cachedLatestRevision = this.getCachedRevision(id, revision);
                            if (cachedLatestRevision != null && !cachedLatestRevision.isHistorical()) {
                                this.cache.removeRevision(id, cachedLatestRevision);
                            }
                        }
                    }
                }
                revision = this.cache.internRevision(revision);
            }
            finally {
                this.releaseAtomicRequestLock(this.loadAndAddLock);
            }
        }
        return revision;
    }

    @Override
    @Deprecated
    public void addRevision(CDORevision revision) {
        AbstractCDORevisionCache.addRevision(revision, this);
    }

    protected void doBeforeActivate() throws Exception {
        super.doBeforeActivate();
        if (this.factory == null) {
            this.factory = CDORevisionFactory.DEFAULT;
        }
        if (this.cache == null) {
            this.cache = (InternalCDORevisionCache)CDORevisionUtil.createRevisionCache(this.supportingAudits, this.supportingBranches);
        }
        if (this.cache instanceof AbstractCDORevisionCache) {
            String name = this.revisionLoader.toString();
            ((AbstractCDORevisionCache)this.cache).setName(name);
        }
    }

    protected void doActivate() throws Exception {
        super.doActivate();
        LifecycleUtil.activate((Object)this.cache);
    }

    protected void doDeactivate() throws Exception {
        LifecycleUtil.deactivate((Object)this.cache);
        super.doDeactivate();
    }

    private void acquireAtomicRequestLock(Object key) {
        if (this.revisionLocker != null) {
            this.revisionLocker.acquireAtomicRequestLock(key);
        }
    }

    private void releaseAtomicRequestLock(Object key) {
        if (this.revisionLocker != null) {
            this.revisionLocker.releaseAtomicRequestLock(key);
        }
    }

    private InternalCDORevision getCachedRevisionByVersion(CDOID id, CDOBranchVersion branchVersion) {
        return (InternalCDORevision)this.cache.getRevisionByVersion(id, branchVersion);
    }

    private InternalCDORevision getCachedRevision(CDOID id, CDOBranchPoint branchPoint) {
        return (InternalCDORevision)this.cache.getRevision(id, branchPoint);
    }

    private InternalCDORevision getCachedRevisionRecursively(CDOID id, CDOBranchPoint branchPoint) {
        CDOBranch branch = branchPoint.getBranch();
        if (!branch.isMainBranch()) {
            CDOBranchPoint base = branch.getBase();
            InternalCDORevision revision = this.getCachedRevision(id, base);
            if (revision != null) {
                return revision;
            }
            return this.getCachedRevisionRecursively(id, base);
        }
        return null;
    }

    private static class RevisionsLoadedEvent
    extends Event
    implements CDORevisionsLoadedEvent {
        private static final long serialVersionUID = 1L;
        private List<? extends CDORevision> primaryLoadedRevisions;
        private List<? extends CDORevision> additionalLoadedRevisions;
        private int prefetchDepth;

        public RevisionsLoadedEvent(CDORevisionManager revisionManager, List<? extends CDORevision> primaryLoadedRevisions, List<? extends CDORevision> additionalLoadedRevisions, int prefetchDepth) {
            super((INotifier)revisionManager);
            this.primaryLoadedRevisions = primaryLoadedRevisions;
            this.additionalLoadedRevisions = additionalLoadedRevisions;
            this.prefetchDepth = prefetchDepth;
        }

        @Override
        public CDORevisionManager getSource() {
            return (CDORevisionManager)super.getSource();
        }

        @Override
        public List<? extends CDORevision> getPrimaryLoadedRevisions() {
            return this.primaryLoadedRevisions;
        }

        @Override
        public List<? extends CDORevision> getAdditionalLoadedRevisions() {
            return this.additionalLoadedRevisions;
        }

        @Override
        public int getPrefetchDepth() {
            return this.prefetchDepth;
        }

        protected String formatAdditionalParameters() {
            return "prefetchDepth=" + this.prefetchDepth + ", primaryLoadedRevisions=" + this.primaryLoadedRevisions + ", additionalLoadedRevisions=" + this.additionalLoadedRevisions;
        }
    }
}

