/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.conn;

import java.util.ArrayList;
import java.util.TimerTask;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.context.ContextImpl;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.services.timer.TimerFactory;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.ParameterValueSet;
import org.apache.derby.iapi.sql.ResultSet;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.conn.SQLSessionContext;
import org.apache.derby.iapi.sql.conn.StatementContext;
import org.apache.derby.iapi.sql.depend.Dependency;
import org.apache.derby.iapi.sql.execute.NoPutResultSet;

final class GenericStatementContext
extends ContextImpl
implements StatementContext {
    private boolean setSavePoint;
    private String internalSavePointName;
    private ResultSet topResultSet;
    private ArrayList<Dependency> dependencies;
    private NoPutResultSet[] subqueryTrackingArray;
    private NoPutResultSet[] materializedSubqueries;
    private final LanguageConnectionContext lcc;
    private boolean inUse = true;
    private volatile boolean cancellationFlag = false;
    private CancelQueryTask cancelTask = null;
    private boolean parentInTrigger;
    private boolean isForReadOnly = false;
    private boolean isAtomic;
    private boolean isSystemCode;
    private boolean rollbackParentContext;
    private boolean statementWasInvalidated;
    private String stmtText;
    private ParameterValueSet pvs;
    private short sqlAllowed = (short)-1;
    private Activation activation;
    private SQLSessionContext sqlSessionContext;

    GenericStatementContext(LanguageConnectionContext languageConnectionContext) {
        super(languageConnectionContext.getContextManager(), "StatementContext");
        this.lcc = languageConnectionContext;
        this.internalSavePointName = languageConnectionContext.getUniqueSavepointName();
    }

    private static TimerFactory getTimerFactory() {
        return Monitor.getMonitor().getTimerFactory();
    }

    @Override
    public void setInUse(boolean bl, boolean bl2, boolean bl3, String string, ParameterValueSet parameterValueSet, long l) {
        this.inUse = true;
        this.parentInTrigger = bl;
        this.isForReadOnly = bl3;
        this.isAtomic = bl2;
        this.stmtText = string;
        this.pvs = parameterValueSet;
        this.rollbackParentContext = false;
        if (l > 0L) {
            this.cancelTask = new CancelQueryTask(this);
            GenericStatementContext.getTimerFactory().schedule(this.cancelTask, l);
        }
    }

    @Override
    public void clearInUse() {
        this.stuffTopResultSet(null, null);
        this.inUse = false;
        this.parentInTrigger = false;
        this.isAtomic = false;
        this.isForReadOnly = false;
        this.stmtText = null;
        this.sqlAllowed = (short)-1;
        this.isSystemCode = false;
        this.rollbackParentContext = false;
        this.statementWasInvalidated = false;
        if (this.cancelTask != null) {
            this.cancelTask.forgetContext();
            this.cancelTask = null;
        }
        this.cancellationFlag = false;
        this.activation = null;
        this.sqlSessionContext = null;
    }

    @Override
    public void setSavePoint() throws StandardException {
        this.pleaseBeOnStack();
        this.lcc.getTransactionExecute().setSavePoint(this.internalSavePointName, null);
        this.setSavePoint = true;
    }

    @Override
    public void resetSavePoint() throws StandardException {
        if (this.inUse && this.setSavePoint) {
            this.lcc.getTransactionExecute().setSavePoint(this.internalSavePointName, null);
        }
    }

    @Override
    public void clearSavePoint() throws StandardException {
        this.pleaseBeOnStack();
        this.lcc.getTransactionExecute().releaseSavePoint(this.internalSavePointName, null);
        this.setSavePoint = false;
    }

    @Override
    public void setTopResultSet(ResultSet resultSet, NoPutResultSet[] noPutResultSetArray) throws StandardException {
        this.pleaseBeOnStack();
        if (this.materializedSubqueries != null) {
            if (noPutResultSetArray != null) {
                for (int i = 0; i < noPutResultSetArray.length; ++i) {
                    if (this.materializedSubqueries[i] == null) continue;
                    noPutResultSetArray[i] = this.materializedSubqueries[i];
                }
            } else {
                noPutResultSetArray = this.materializedSubqueries;
            }
            this.materializedSubqueries = null;
        }
        this.stuffTopResultSet(resultSet, noPutResultSetArray);
    }

    private void stuffTopResultSet(ResultSet resultSet, NoPutResultSet[] noPutResultSetArray) {
        this.topResultSet = resultSet;
        this.subqueryTrackingArray = noPutResultSetArray;
        this.dependencies = null;
    }

    @Override
    public void setSubqueryResultSet(int n, NoPutResultSet noPutResultSet, int n2) throws StandardException {
        this.pleaseBeOnStack();
        if (this.subqueryTrackingArray == null) {
            if (this.topResultSet == null) {
                this.subqueryTrackingArray = new NoPutResultSet[n2];
                this.materializedSubqueries = new NoPutResultSet[n2];
            } else {
                this.subqueryTrackingArray = this.topResultSet.getSubqueryTrackingArray(n2);
            }
        }
        this.subqueryTrackingArray[n] = noPutResultSet;
        if (this.materializedSubqueries != null) {
            this.materializedSubqueries[n] = noPutResultSet;
        }
    }

    @Override
    public NoPutResultSet[] getSubqueryTrackingArray() throws StandardException {
        this.pleaseBeOnStack();
        return this.subqueryTrackingArray;
    }

    @Override
    public void addDependency(Dependency dependency) throws StandardException {
        this.pleaseBeOnStack();
        if (this.dependencies == null) {
            this.dependencies = new ArrayList();
        }
        this.dependencies.add(dependency);
    }

    @Override
    public boolean inTrigger() {
        return this.parentInTrigger;
    }

    @Override
    public void cleanupOnError(Throwable throwable) throws StandardException {
        Object object;
        int n = 40000;
        if (throwable instanceof StandardException) {
            object = (StandardException)throwable;
            n = ((StandardException)object).getSeverity();
            if ("XCL32.S".equals(((StandardException)object).getMessageId())) {
                this.statementWasInvalidated = true;
            }
        }
        if (!this.inUse) {
            return;
        }
        if (this.topResultSet != null) {
            this.topResultSet.cleanUp();
        }
        if (this.subqueryTrackingArray != null) {
            for (int i = 0; i < this.subqueryTrackingArray.length; ++i) {
                if (this.subqueryTrackingArray[i] == null) continue;
                this.subqueryTrackingArray[i].cleanUp();
            }
        }
        if (this.dependencies != null) {
            object = this.lcc.getDataDictionary().getDependencyManager();
            for (Dependency dependency : this.dependencies) {
                object.clearInMemoryDependency(dependency);
            }
            this.dependencies = null;
        }
        if (n <= 20000 && this.setSavePoint) {
            this.lcc.internalRollbackToSavepoint(this.internalSavePointName, false, null);
            this.clearSavePoint();
        }
        if (n >= 30000) {
            this.setSavePoint = false;
        }
        this.lcc.popStatementContext(this, throwable);
    }

    @Override
    public boolean isLastHandler(int n) {
        return this.inUse && !this.rollbackParentContext && n == 20000;
    }

    @Override
    public boolean onStack() {
        return this.inUse;
    }

    @Override
    public boolean isAtomic() {
        return this.isAtomic;
    }

    @Override
    public String getStatementText() {
        return this.stmtText;
    }

    private void pleaseBeOnStack() throws StandardException {
        if (!this.inUse) {
            throw StandardException.newException("40XC0", new Object[0]);
        }
    }

    @Override
    public boolean inUse() {
        return this.inUse;
    }

    @Override
    public boolean isForReadOnly() {
        return this.isForReadOnly;
    }

    @Override
    public boolean isCancelled() {
        return this.cancellationFlag;
    }

    @Override
    public void cancel() {
        this.cancellationFlag = true;
    }

    @Override
    public void setSQLAllowed(short s, boolean bl) {
        if (bl || s > this.sqlAllowed) {
            this.sqlAllowed = s;
        }
    }

    @Override
    public short getSQLAllowed() {
        if (!this.inUse) {
            return 3;
        }
        return this.sqlAllowed;
    }

    @Override
    public void setParentRollback() {
        this.rollbackParentContext = true;
    }

    @Override
    public void setSystemCode() {
        this.isSystemCode = true;
    }

    @Override
    public boolean getSystemCode() {
        return this.isSystemCode;
    }

    @Override
    public StringBuffer appendErrorInfo() {
        StringBuffer stringBuffer = ((ContextImpl)((Object)this.lcc)).appendErrorInfo();
        if (stringBuffer != null) {
            stringBuffer.append("Failed Statement is: ");
            stringBuffer.append(this.getStatementText());
            if (this.pvs != null && this.pvs.getParameterCount() > 0) {
                String string = " with " + this.pvs.getParameterCount() + " parameters " + this.pvs.toString();
                stringBuffer.append(string);
            }
        }
        return stringBuffer;
    }

    @Override
    public void setActivation(Activation activation) {
        this.activation = activation;
    }

    @Override
    public Activation getActivation() {
        return this.activation;
    }

    @Override
    public SQLSessionContext getSQLSessionContext() {
        return this.sqlSessionContext;
    }

    @Override
    public void setSQLSessionContext(SQLSessionContext sQLSessionContext) {
        this.sqlSessionContext = sQLSessionContext;
    }

    @Override
    public boolean getStatementWasInvalidated() {
        return this.statementWasInvalidated;
    }

    private static class CancelQueryTask
    extends TimerTask {
        private StatementContext statementContext;

        public CancelQueryTask(StatementContext statementContext) {
            this.statementContext = statementContext;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            CancelQueryTask cancelQueryTask = this;
            synchronized (cancelQueryTask) {
                if (this.statementContext != null) {
                    this.statementContext.cancel();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void forgetContext() {
            CancelQueryTask cancelQueryTask = this;
            synchronized (cancelQueryTask) {
                this.statementContext = null;
            }
            GenericStatementContext.getTimerFactory().cancel(this);
        }
    }
}

