/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.ui.widgets;

import java.lang.reflect.Method;
import org.eclipse.net4j.util.ReflectUtil;
import org.eclipse.net4j.util.StringUtil;
import org.eclipse.net4j.util.collection.IHistory;
import org.eclipse.net4j.util.collection.IHistoryChangeEvent;
import org.eclipse.net4j.util.collection.IHistoryElement;
import org.eclipse.net4j.util.event.IEvent;
import org.eclipse.net4j.util.event.IListener;
import org.eclipse.net4j.util.internal.ui.bundle.OM;
import org.eclipse.net4j.util.ui.UIUtil;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class HistoryText {
    private IHistory<String> history;
    private CCombo combo;
    private Method droppedMethod;
    private IListener historyListener = new IListener(){

        public void notifyEvent(IEvent event) {
            if (event instanceof IHistoryChangeEvent) {
                HistoryText.this.historyChanged();
            }
        }
    };

    public HistoryText(Composite parent, int style, IHistory<String> history) {
        this.history = history;
        history.addListener(this.historyListener);
        this.combo = new CCombo(parent, style);
        this.combo.setLayoutData((Object)UIUtil.createGridData());
        this.combo.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                HistoryText.this.history.removeListener(HistoryText.this.historyListener);
            }
        });
        try {
            this.droppedMethod = this.combo.getClass().getDeclaredMethod("isDropped", ReflectUtil.NO_PARAMETERS);
            this.droppedMethod.setAccessible(true);
        }
        catch (Exception ex) {
            OM.LOG.error((Throwable)ex);
        }
        this.historyChanged();
    }

    public IHistory<String> getHistory() {
        return this.history;
    }

    public CCombo getCombo() {
        return this.combo;
    }

    public void append(String string) {
        this.combo.setText(String.valueOf(this.combo.getText()) + string);
    }

    public int getCharCount() {
        return this.combo.getText().length();
    }

    public int getLineCount() {
        return StringUtil.occurrences((String)this.combo.getText(), (String)this.getLineDelimiter()) + 1;
    }

    public String getLineDelimiter() {
        return Text.DELIMITER;
    }

    public int getLineHeight() {
        return this.combo.getTextHeight();
    }

    public String getText(boolean addHistory) {
        String text = this.combo.getText();
        if (addHistory) {
            this.history.add((Object)text);
        }
        return text;
    }

    public String getText() {
        return this.getText(false);
    }

    public void setText(String string) {
        this.combo.setText(string);
    }

    public boolean setFocus() {
        return this.combo.setFocus();
    }

    public boolean isDropped() {
        if (this.droppedMethod != null) {
            try {
                return (Boolean)this.droppedMethod.invoke((Object)this.combo, ReflectUtil.NO_ARGUMENTS);
            }
            catch (Exception ex) {
                OM.LOG.error((Throwable)ex);
            }
        }
        return false;
    }

    protected void historyChanged() {
        if (this.combo.isDisposed()) {
            return;
        }
        this.combo.removeAll();
        for (IHistoryElement element : this.history) {
            this.combo.add((String)element.getData());
        }
        String mostRecent = (String)this.history.getMostRecent();
        if (mostRecent != null) {
            this.setText(mostRecent);
        }
    }

    public void addListener(int evenType, Listener listener) {
        this.combo.addListener(evenType, listener);
    }

    public void removeListener(int evenType, Listener listener) {
        this.combo.removeListener(evenType, listener);
    }
}

