/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.tests;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.net4j.util.ReflectUtil;
import org.eclipse.net4j.util.StringUtil;
import org.eclipse.net4j.util.WrappedException;
import org.eclipse.net4j.util.event.IEvent;
import org.eclipse.net4j.util.event.IListener;
import org.junit.Assert;

public class TestListener2
implements IListener {
    public static final int NO_TIME_STAMP = 0;
    private static final Set<Class<? extends IEvent>> NO_EVENT_CLASSES = Collections.emptySet();
    private static final long DEFAULT_TIMEOUT = 3000L;
    private final Collection<Class<? extends IEvent>> eventClasses;
    private final Map<IEvent, Long> events = new LinkedHashMap<IEvent, Long>();
    private String name;
    private long timeout;
    private boolean dumpEvents;
    private boolean dumpThreads;

    public TestListener2(Collection<Class<? extends IEvent>> eventClasses) {
        this.eventClasses = eventClasses != null ? eventClasses : NO_EVENT_CLASSES;
        this.timeout = 3000L;
    }

    @SafeVarargs
    public TestListener2(Class<? extends IEvent> ... eventClasses) {
        this(Arrays.asList(eventClasses));
    }

    public String getName() {
        return this.name;
    }

    public TestListener2 setName(String name) {
        this.name = name;
        return this;
    }

    public boolean isApplicable(IEvent event) {
        if (this.eventClasses.isEmpty()) {
            return true;
        }
        Class<?> theClass = event.getClass();
        for (Class<? extends IEvent> eventClass : this.eventClasses) {
            if (!eventClass.isAssignableFrom(theClass)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyEvent(IEvent event) {
        if (this.isApplicable(event)) {
            long timeStamp = System.currentTimeMillis();
            if (timeStamp == 0L) {
                throw new IllegalStateException("Regular time stamp is equal to NO_TIME_STAMP");
            }
            StringBuilder builder = new StringBuilder();
            if (this.dumpEvents) {
                builder.append(event);
            }
            if (this.dumpThreads) {
                StringUtil.appendSeparator((StringBuilder)builder, (String)"\n  ");
                builder.append(ReflectUtil.dumpThread());
            }
            if (builder.length() != 0) {
                System.out.println(builder);
            }
            TestListener2 testListener2 = this;
            synchronized (testListener2) {
                this.events.put(event, timeStamp);
                this.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<IEvent> getEvents() {
        TestListener2 testListener2 = this;
        synchronized (testListener2) {
            return new ArrayList<IEvent>(this.events.keySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <E extends IEvent> List<E> getEvents(Class<E> eventClass) {
        ArrayList<IEvent> result = new ArrayList<IEvent>();
        TestListener2 testListener2 = this;
        synchronized (testListener2) {
            for (IEvent event : this.events.keySet()) {
                if (!eventClass.isInstance(event)) continue;
                IEvent e = event;
                result.add(e);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getTimeStamp(IEvent event) {
        Long timeStamp;
        TestListener2 testListener2 = this;
        synchronized (testListener2) {
            timeStamp = this.events.get(event);
        }
        if (timeStamp == null) {
            return 0L;
        }
        return timeStamp;
    }

    public TestListener2 setTimeout(long timeout) {
        this.timeout = timeout;
        return this;
    }

    public boolean isDumpEvents() {
        return this.dumpEvents;
    }

    public boolean isDumpThreads() {
        return this.dumpThreads;
    }

    public TestListener2 dump(boolean dumpEvents, boolean dumpThreads) {
        this.dumpEvents = dumpEvents;
        this.dumpThreads = dumpThreads;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized IEvent[] waitFor(int n, long timeout) {
        long t = 0L;
        TestListener2 testListener2 = this;
        synchronized (testListener2) {
            while (this.events.size() < n) {
                if (timeout <= 0L) {
                    Assert.fail((String)("Waiting for " + n + " event" + (n == 1 ? "" : "s") + ", but received only " + this.events.size() + " event" + (this.events.size() == 1 ? "" : "s")));
                }
                try {
                    t = System.currentTimeMillis();
                    this.wait(timeout);
                }
                catch (InterruptedException ex) {
                    throw WrappedException.wrap((Exception)ex);
                }
                timeout -= System.currentTimeMillis() - t;
            }
            return this.events.keySet().toArray(new IEvent[this.events.size()]);
        }
    }

    public IEvent[] waitFor(int i) {
        return this.waitFor(i, this.timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearEvents() {
        TestListener2 testListener2 = this;
        synchronized (testListener2) {
            this.events.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String formatEvents(String prefix, String suffix) {
        StringBuilder builder = new StringBuilder();
        TestListener2 testListener2 = this;
        synchronized (testListener2) {
            for (Map.Entry<IEvent, Long> entry : this.events.entrySet()) {
                builder.append(String.valueOf(prefix) + entry.getValue() + ": " + entry.getKey() + suffix);
            }
        }
        return builder.toString();
    }

    public void dump(PrintStream out) {
        out.println(this);
        out.print(this.formatEvents("  ", "\n"));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(TestListener2.class.getSimpleName());
        builder.append('[');
        if (this.name != null) {
            builder.append("name=\"");
            builder.append(this.name);
            builder.append('\"');
        }
        if (!this.eventClasses.isEmpty()) {
            if (this.name != null) {
                builder.append(", ");
            }
            builder.append("eventClasses=[");
            boolean first = true;
            for (Class<? extends IEvent> eventClass : this.eventClasses) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append(eventClass.getSimpleName());
            }
            builder.append(']');
        }
        builder.append(']');
        return builder.toString();
    }

    public static <E extends IEvent> int countEvents(IEvent[] events, Class<E> eventClass) {
        int count = 0;
        int i = 0;
        while (i < events.length) {
            IEvent event = events[i];
            if (eventClass.isInstance(event)) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    public static <E extends IEvent> List<E> filterEvents(IEvent[] events, Class<E> eventClass) {
        ArrayList<IEvent> result = new ArrayList<IEvent>();
        int i = 0;
        while (i < events.length) {
            IEvent event = events[i];
            if (eventClass.isInstance(event)) {
                IEvent e = event;
                result.add(e);
            }
            ++i;
        }
        return result;
    }
}

