/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.server;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.cdo.internal.server.Topic;
import org.eclipse.emf.cdo.server.ITopic;
import org.eclipse.emf.cdo.spi.server.InternalSession;
import org.eclipse.emf.cdo.spi.server.InternalSessionManager;
import org.eclipse.emf.cdo.spi.server.InternalTopic;
import org.eclipse.emf.cdo.spi.server.InternalTopicManager;
import org.eclipse.net4j.util.container.Container;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;

public class TopicManager
extends Container<ITopic>
implements InternalTopicManager {
    private final InternalSessionManager sessionManager;
    private final Map<String, InternalTopic> topics = new HashMap<String, InternalTopic>();

    public TopicManager(InternalSessionManager sessionManager) {
        this.sessionManager = sessionManager;
    }

    @Override
    public InternalSessionManager getSessionManager() {
        return this.sessionManager;
    }

    @Override
    public InternalTopic getTopic(String id) {
        return this.getTopic(id, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InternalTopic getTopic(String id, boolean createOnDemand) {
        InternalTopic topic;
        boolean added = false;
        Map<String, InternalTopic> map = this.topics;
        synchronized (map) {
            topic = this.topics.get(id);
            if (topic == null && createOnDemand) {
                topic = new Topic(this, id);
                LifecycleUtil.activate((Object)topic);
                this.topics.put(id, topic);
                added = true;
            }
        }
        if (added) {
            this.fireElementAddedEvent(topic);
        }
        return topic;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InternalTopic[] getTopics() {
        Map<String, InternalTopic> map = this.topics;
        synchronized (map) {
            return this.topics.values().toArray(new InternalTopic[this.topics.size()]);
        }
    }

    public InternalTopic[] getElements() {
        return this.getTopics();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        Map<String, InternalTopic> map = this.topics;
        synchronized (map) {
            return this.topics.isEmpty();
        }
    }

    @Override
    public InternalSession[] addSubscription(String id, InternalSession session) {
        InternalTopic topic = this.getTopic(id, true);
        InternalSession[] result = topic.addSession(session);
        this.sessionManager.sendRemoteSessionNotification(session, null, topic, (byte)3);
        return result;
    }

    @Override
    public void removeSubscription(String id, InternalSession session) {
        InternalTopic topic = this.getTopic(id, false);
        if (topic != null && topic.removeSession(session)) {
            this.sessionManager.sendRemoteSessionNotification(session, null, topic, (byte)4);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeTopic(InternalTopic topic) {
        InternalTopic removedTopic;
        String id = topic.getID();
        Map<String, InternalTopic> map = this.topics;
        synchronized (map) {
            removedTopic = this.topics.remove(id);
            if (removedTopic != null && removedTopic != topic) {
                this.topics.put(id, topic);
                removedTopic = null;
            }
        }
        if (removedTopic != null) {
            LifecycleUtil.deactivate((Object)removedTopic);
            this.fireElementRemovedEvent(removedTopic);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<InternalTopic> sessionClosed(InternalSession session) {
        ArrayList<InternalTopic> affectedTopics = new ArrayList<InternalTopic>();
        Map<String, InternalTopic> map = this.topics;
        synchronized (map) {
            for (InternalTopic topic : this.topics.values()) {
                if (!topic.removeSession(session)) continue;
                affectedTopics.add(topic);
            }
        }
        return affectedTopics;
    }
}

