/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.db;

import java.util.List;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.server.IStoreAccessor;
import org.eclipse.emf.cdo.server.IStoreChunkReader;
import org.eclipse.emf.cdo.server.db.IDBStoreChunkReader;
import org.eclipse.emf.cdo.server.db.mapping.IClassMapping;
import org.eclipse.emf.cdo.server.db.mapping.IListMapping;
import org.eclipse.emf.cdo.server.db.mapping.IListMapping2;
import org.eclipse.emf.cdo.server.db.mapping.IMappingStrategy;
import org.eclipse.emf.cdo.server.internal.db.DBStoreAccessor;
import org.eclipse.emf.cdo.server.internal.db.mapping.horizontal.IMappingConstants;
import org.eclipse.emf.cdo.spi.server.StoreChunkReader;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.net4j.util.StringUtil;

public class DBStoreChunkReader
extends StoreChunkReader
implements IDBStoreChunkReader,
IMappingConstants {
    private IListMapping referenceMapping;
    private StringBuilder builder = new StringBuilder();

    public DBStoreChunkReader(DBStoreAccessor accessor, CDORevision revision, EStructuralFeature feature) {
        super((IStoreAccessor)accessor, revision, feature);
        IMappingStrategy mappingStrategy = accessor.getStore().getMappingStrategy();
        IClassMapping mapping = mappingStrategy.getClassMapping(revision.getEClass());
        this.referenceMapping = mapping.getListMapping(feature);
    }

    @Override
    public DBStoreAccessor getAccessor() {
        return (DBStoreAccessor)super.getAccessor();
    }

    public void addSimpleChunk(int index) {
        super.addSimpleChunk(index);
        this.prepareAddition();
        if (this.referenceMapping instanceof IListMapping2) {
            ((IListMapping2)this.referenceMapping).addSimpleChunkWhere(this.getAccessor(), this.getRevision().getID(), this.builder, index);
        } else {
            this.builder.append("CDO_IDX");
            this.builder.append('=');
            this.builder.append(index);
        }
    }

    public void addRangedChunk(int fromIndex, int toIndex) {
        super.addRangedChunk(fromIndex, toIndex);
        this.prepareAddition();
        if (this.referenceMapping instanceof IListMapping2) {
            ((IListMapping2)this.referenceMapping).addRangedChunkWhere(this.getAccessor(), this.getRevision().getID(), this.builder, fromIndex, toIndex);
        } else {
            this.builder.append("CDO_IDX");
            this.builder.append(" BETWEEN ");
            this.builder.append(fromIndex);
            this.builder.append(" AND ");
            this.builder.append(toIndex - 1);
        }
    }

    public List<IStoreChunkReader.Chunk> executeRead() {
        List chunks = this.getChunks();
        if (chunks.size() > 1) {
            this.builder.insert(0, '(');
            this.builder.append(')');
        }
        this.referenceMapping.readChunks(this, chunks, this.builder.toString());
        return chunks;
    }

    private void prepareAddition() {
        StringUtil.appendSeparator((StringBuilder)this.builder, (String)" OR ");
    }
}

