/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.internal.net4j.bundle.OM;
import org.eclipse.net4j.acceptor.IAcceptor;
import org.eclipse.net4j.channel.IChannelMultiplexer;
import org.eclipse.net4j.connector.IServerConnector;
import org.eclipse.net4j.signal.SignalProtocol;
import org.eclipse.net4j.signal.wrapping.StreamWrapperInjector;
import org.eclipse.net4j.util.container.FactoryNotFoundException;
import org.eclipse.net4j.util.container.IElementProcessor;
import org.eclipse.net4j.util.container.IManagedContainer;
import org.eclipse.net4j.util.container.IManagedContainerProvider;
import org.eclipse.net4j.util.factory.Factory;
import org.eclipse.net4j.util.factory.ProductCreationException;
import org.eclipse.net4j.util.io.IStreamWrapper;
import org.eclipse.net4j.util.om.trace.ContextTracer;
import org.eclipse.net4j.util.security.INegotiator;
import org.eclipse.spi.net4j.Acceptor;
import org.eclipse.spi.net4j.InternalChannelMultiplexer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class TransportConfigurator
implements IManagedContainerProvider {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG, TransportConfigurator.class);
    private IManagedContainer container;

    public TransportConfigurator(IManagedContainer container) {
        this.container = container;
    }

    public IManagedContainer getContainer() {
        return this.container;
    }

    public IAcceptor[] configure(File configFile) throws ParserConfigurationException, SAXException, IOException, CoreException {
        if (TRACER.isEnabled()) {
            TRACER.trace("Configuring Net4j server from " + configFile.getAbsolutePath());
        }
        ArrayList<IAcceptor> acceptors = new ArrayList<IAcceptor>();
        Document document = this.getDocument(configFile);
        NodeList acceptorConfigs = document.getElementsByTagName("acceptor");
        int i = 0;
        while (i < acceptorConfigs.getLength()) {
            Element acceptorConfig = (Element)acceptorConfigs.item(i);
            IAcceptor acceptor = this.configureAcceptor(acceptorConfig);
            acceptors.add(acceptor);
            ++i;
        }
        NodeList streamWrapperConfigs = document.getElementsByTagName("streamWrapper");
        int i2 = 0;
        while (i2 < streamWrapperConfigs.getLength()) {
            Element streamWrapperConfig = (Element)streamWrapperConfigs.item(i2);
            if (TransportConfigurator.getLevel(streamWrapperConfig) == 2) {
                this.configureStreamWrapper(streamWrapperConfig, null);
            }
            ++i2;
        }
        return acceptors.toArray(new IAcceptor[acceptors.size()]);
    }

    protected IAcceptor configureAcceptor(Element acceptorConfig) {
        String description;
        String type;
        block7: {
            type = acceptorConfig.getAttribute("type");
            description = acceptorConfig.getAttribute("description");
            if (description == null || description.isEmpty()) {
                try {
                    AcceptorDescriptionParser parser = (AcceptorDescriptionParser)this.container.getElement("org.eclipse.net4j.acceptorDescriptionParsers", type, null, true);
                    description = parser.getAcceptorDescription(acceptorConfig);
                }
                catch (FactoryNotFoundException | ProductCreationException ex) {
                    if (!TRACER.isEnabled()) break block7;
                    TRACER.trace(ex);
                }
            }
        }
        Acceptor acceptor = (Acceptor)this.container.getElement("org.eclipse.net4j.acceptors", type, description, false);
        NodeList negotiatorConfigs = acceptorConfig.getElementsByTagName("negotiator");
        if (negotiatorConfigs.getLength() > 1) {
            throw new IllegalStateException("A maximum of one negotiator can be configured for acceptor " + acceptor);
        }
        if (negotiatorConfigs.getLength() == 1) {
            Element negotiatorConfig = (Element)negotiatorConfigs.item(0);
            INegotiator negotiator = this.configureNegotiator(negotiatorConfig);
            acceptor.getConfig().setNegotiator(negotiator);
        }
        NodeList streamWrapperConfigs = acceptorConfig.getElementsByTagName("streamWrapper");
        int i = 0;
        while (i < streamWrapperConfigs.getLength()) {
            Element streamWrapperConfig = (Element)streamWrapperConfigs.item(i);
            if (TransportConfigurator.getLevel(streamWrapperConfig) == 3) {
                this.configureStreamWrapper(streamWrapperConfig, acceptor);
            }
            ++i;
        }
        OM.LOG.info("Net4j acceptor starting: " + type + "://" + description);
        acceptor.activate();
        return acceptor;
    }

    protected INegotiator configureNegotiator(Element negotiatorConfig) {
        String type = negotiatorConfig.getAttribute("type");
        String description = negotiatorConfig.getAttribute("description");
        return (INegotiator)this.container.getElement("org.eclipse.net4j.Negotiators", type, description);
    }

    protected void configureStreamWrapper(Element streamWrapperConfig, Acceptor acceptor) {
        String type = streamWrapperConfig.getAttribute("type");
        String description = streamWrapperConfig.getAttribute("description");
        String protocolName = streamWrapperConfig.getAttribute("protocol");
        IStreamWrapper streamWrapper = (IStreamWrapper)this.container.getElement("org.eclipse.net4j.streamWrappers", type, description);
        if (streamWrapper != null) {
            AcceptorStreamWrapperInjector injector = new AcceptorStreamWrapperInjector(protocolName, acceptor, streamWrapper);
            this.container.addPostProcessor((IElementProcessor)injector);
        }
    }

    protected Document getDocument(File configFile) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        return builder.parse(configFile);
    }

    protected Element getStoreConfig(Element repositoryConfig) {
        NodeList storeConfigs = repositoryConfig.getElementsByTagName("store");
        if (storeConfigs.getLength() != 1) {
            String repositoryName = repositoryConfig.getAttribute("name");
            throw new IllegalStateException("Exactly one store must be configured for repository " + repositoryName);
        }
        return (Element)storeConfigs.item(0);
    }

    public static Map<String, String> getProperties(Element element, int levels) {
        HashMap<String, String> properties = new HashMap<String, String>();
        TransportConfigurator.collectProperties(element, "", properties, levels);
        return properties;
    }

    private static void collectProperties(Element element, String prefix, Map<String, String> properties, int levels) {
        if ("property".equals(element.getNodeName())) {
            String name = element.getAttribute("name");
            String value = element.getAttribute("value");
            properties.put(String.valueOf(prefix) + name, value);
            prefix = String.valueOf(prefix) + name + ".";
        }
        if (levels > 0) {
            NodeList childNodes = element.getChildNodes();
            int i = 0;
            while (i < childNodes.getLength()) {
                Node childNode = childNodes.item(i);
                if (childNode instanceof Element) {
                    TransportConfigurator.collectProperties((Element)childNode, prefix, properties, levels - 1);
                }
                ++i;
            }
        }
    }

    private static int getLevel(Node node) {
        Node parentNode = node.getParentNode();
        return parentNode != null ? TransportConfigurator.getLevel(parentNode) + 1 : 0;
    }

    public static interface AcceptorDescriptionParser {
        public String getAcceptorDescription(Element var1);

        public static abstract class Factory
        extends org.eclipse.net4j.util.factory.Factory {
            public static final String PRODUCT_GROUP = "org.eclipse.net4j.acceptorDescriptionParsers";

            public Factory(String type) {
                super(PRODUCT_GROUP, type);
            }

            public abstract AcceptorDescriptionParser create(String var1) throws ProductCreationException;
        }
    }

    private static final class AcceptorStreamWrapperInjector
    extends StreamWrapperInjector {
        private final IAcceptor acceptor;

        public AcceptorStreamWrapperInjector(String protocolID, IAcceptor acceptor, IStreamWrapper streamWrapper) {
            super(protocolID, streamWrapper);
            this.acceptor = acceptor;
        }

        @Override
        protected boolean shouldInject(IManagedContainer container, String productGroup, String factoryType, String description, SignalProtocol<?> signalProtocol) {
            if (super.shouldInject(container, productGroup, factoryType, description, signalProtocol)) {
                IServerConnector serverConnector;
                if (this.acceptor == null) {
                    return true;
                }
                IChannelMultiplexer multiplexer = InternalChannelMultiplexer.CONTEXT_MULTIPLEXER.get();
                if (multiplexer instanceof IServerConnector && (serverConnector = (IServerConnector)multiplexer).getAcceptor() == this.acceptor) {
                    return true;
                }
            }
            return false;
        }
    }
}

