/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.security;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.commit.CDOCommitInfo;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.model.CDOModelUtil;
import org.eclipse.emf.cdo.common.model.CDOPackageUnit;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.revision.CDORevisionManager;
import org.eclipse.emf.cdo.common.revision.CDORevisionProvider;
import org.eclipse.emf.cdo.common.revision.CDORevisionUtil;
import org.eclipse.emf.cdo.common.revision.delta.CDORevisionDelta;
import org.eclipse.emf.cdo.common.security.CDOPermission;
import org.eclipse.emf.cdo.eresource.CDOResource;
import org.eclipse.emf.cdo.eresource.EresourcePackage;
import org.eclipse.emf.cdo.internal.security.PermissionUtil;
import org.eclipse.emf.cdo.internal.security.ViewCreator;
import org.eclipse.emf.cdo.net4j.CDONet4jSession;
import org.eclipse.emf.cdo.net4j.CDONet4jSessionConfiguration;
import org.eclipse.emf.cdo.net4j.CDONet4jUtil;
import org.eclipse.emf.cdo.security.Access;
import org.eclipse.emf.cdo.security.Directory;
import org.eclipse.emf.cdo.security.Group;
import org.eclipse.emf.cdo.security.PatternStyle;
import org.eclipse.emf.cdo.security.Permission;
import org.eclipse.emf.cdo.security.PermissionFilter;
import org.eclipse.emf.cdo.security.Realm;
import org.eclipse.emf.cdo.security.Role;
import org.eclipse.emf.cdo.security.SecurityFactory;
import org.eclipse.emf.cdo.security.SecurityPackage;
import org.eclipse.emf.cdo.security.User;
import org.eclipse.emf.cdo.security.UserPassword;
import org.eclipse.emf.cdo.security.impl.PermissionImpl;
import org.eclipse.emf.cdo.server.CDOServerUtil;
import org.eclipse.emf.cdo.server.IPermissionManager;
import org.eclipse.emf.cdo.server.IRepository;
import org.eclipse.emf.cdo.server.ISession;
import org.eclipse.emf.cdo.server.IStoreAccessor;
import org.eclipse.emf.cdo.server.ITransaction;
import org.eclipse.emf.cdo.server.StoreThreadLocal;
import org.eclipse.emf.cdo.server.internal.security.bundle.OM;
import org.eclipse.emf.cdo.server.security.ISecurityManager;
import org.eclipse.emf.cdo.server.spi.security.InternalSecurityManager;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageRegistry;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageUnit;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevisionDelta;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevisionManager;
import org.eclipse.emf.cdo.spi.common.revision.ManagedRevisionProvider;
import org.eclipse.emf.cdo.spi.server.InternalCommitContext;
import org.eclipse.emf.cdo.spi.server.InternalRepository;
import org.eclipse.emf.cdo.spi.server.InternalSessionManager;
import org.eclipse.emf.cdo.spi.server.ObjectWriteAccessHandler;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.cdo.view.CDOViewInvalidationEvent;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EValidator;
import org.eclipse.emf.spi.cdo.InternalCDOSessionInvalidationEvent;
import org.eclipse.net4j.Net4jUtil;
import org.eclipse.net4j.acceptor.IAcceptor;
import org.eclipse.net4j.connector.IConnector;
import org.eclipse.net4j.util.ArrayUtil;
import org.eclipse.net4j.util.RunnableWithException;
import org.eclipse.net4j.util.StringUtil;
import org.eclipse.net4j.util.WrappedException;
import org.eclipse.net4j.util.collection.HashBag;
import org.eclipse.net4j.util.concurrent.TimeoutRuntimeException;
import org.eclipse.net4j.util.container.ContainerEventAdapter;
import org.eclipse.net4j.util.container.IContainer;
import org.eclipse.net4j.util.container.IManagedContainer;
import org.eclipse.net4j.util.event.IEvent;
import org.eclipse.net4j.util.event.IListener;
import org.eclipse.net4j.util.lifecycle.ILifecycle;
import org.eclipse.net4j.util.lifecycle.Lifecycle;
import org.eclipse.net4j.util.lifecycle.LifecycleEventAdapter;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;
import org.eclipse.net4j.util.om.OMPlatform;
import org.eclipse.net4j.util.om.monitor.Monitor;
import org.eclipse.net4j.util.om.monitor.OMMonitor;
import org.eclipse.net4j.util.security.IAuthenticator;
import org.eclipse.net4j.util.security.IAuthenticator2;
import org.eclipse.net4j.util.security.IPasswordCredentials;
import org.eclipse.net4j.util.security.SecurityUtil;

public class SecurityManager
extends Lifecycle
implements InternalSecurityManager {
    private static final Map<IRepository, InternalSecurityManager> SECURITY_MANAGERS = Collections.synchronizedMap(new HashMap());
    private static final boolean DISABLE_DETACH_CHECKS = OMPlatform.INSTANCE.isProperty("org.eclipse.emf.cdo.server.security.DISABLE_DETACH_CHECKS");
    private static final boolean ALLOW_EMPTY_PASSWORDS = OMPlatform.INSTANCE.isProperty("org.eclipse.emf.cdo.server.security.ALLOW_EMPTY_PASSWORDS");
    private static final Consumer<String> EMPTY_PASSWORD_PREVENTER = pw -> {
        if (StringUtil.isEmpty((String)pw)) {
            throw new SecurityException("Password is empty");
        }
    };
    private static final SecurityFactory SF = SecurityFactory.eINSTANCE;
    private final IListener repositoryListener = new LifecycleEventAdapter(){

        protected void onActivated(ILifecycle lifecycle) {
            SecurityManager.this.init();
        }

        protected void onDeactivated(ILifecycle lifecycle) {
            SecurityManager.this.unregister(SecurityManager.this.repository);
            SecurityManager.this.deactivate();
        }
    };
    private final IListener sessionManagerListener = new ContainerEventAdapter<ISession>(){

        protected void onAdded(IContainer<ISession> container, ISession session) {
            SecurityManager.this.sessionAdded(session);
        }

        protected void onRemoved(IContainer<ISession> container, ISession session) {
            SecurityManager.this.sessionRemoved(session);
        }
    };
    private final IListener realmInvalidationListener = new IListener(){
        private boolean clearUserInfos;

        public void notifyEvent(IEvent event) {
            if (event instanceof InternalCDOSessionInvalidationEvent) {
                InternalCDOSessionInvalidationEvent e = (InternalCDOSessionInvalidationEvent)event;
                if (e.getSecurityImpact() == 2) {
                    this.clearUserInfos = true;
                }
            } else if (event instanceof CDOViewInvalidationEvent && this.clearUserInfos) {
                SecurityManager.this.clearUserInfos(true);
                this.clearUserInfos = false;
            }
        }
    };
    private final IAuthenticator authenticator = new Authenticator();
    private final IPermissionManager permissionManager = new PermissionManager();
    private final IRepository.WriteAccessHandler writeAccessHandler = new WriteAccessHandler();
    private final String realmPath;
    private final IManagedContainer container;
    private final ConcurrentMap<InternalRepository, SecondaryRepository> secondaryRepositories = new ConcurrentHashMap<InternalRepository, SecondaryRepository>();
    private final ConcurrentMap<String, UserInfo> userInfos = new ConcurrentHashMap<String, UserInfo>();
    private final HashBag<PermissionImpl> permissionBag = new HashBag();
    private final Object commitHandlerLock = new Object();
    private InternalSecurityManager.CommitHandler[] commitHandlers = new InternalSecurityManager.CommitHandler[0];
    private InternalSecurityManager.CommitHandler2[] commitHandlers2 = new InternalSecurityManager.CommitHandler2[0];
    private PermissionImpl[] permissionArray = new PermissionImpl[0];
    private Consumer<String> passwordValidator = ALLOW_EMPTY_PASSWORDS ? null : EMPTY_PASSWORD_PREVENTER;
    private InternalRepository repository;
    private IAcceptor acceptor;
    private IConnector connector;
    private CDONet4jSession realmSession;
    private CDOView realmView;
    private Realm realm;
    private CDOID realmID;
    private volatile Long lastRealmModification;
    private Object lastRealmModificationLock = new Object();

    public SecurityManager(String realmPath, IManagedContainer container) {
        this.realmPath = realmPath;
        this.container = container;
    }

    public final IManagedContainer getContainer() {
        return this.container;
    }

    @Override
    public final String getRealmPath() {
        return this.realmPath;
    }

    public final InternalRepository getRepository() {
        return this.repository;
    }

    @Override
    public void setRepository(InternalRepository repository) {
        this.repository = repository;
        if (this.isActive()) {
            this.init();
        }
    }

    @Override
    public InternalRepository[] getSecondaryRepositories() {
        return this.secondaryRepositories.keySet().toArray(new InternalRepository[0]);
    }

    @Override
    public void addSecondaryRepository(InternalRepository repository) {
        this.secondaryRepositories.computeIfAbsent(repository, k -> new SecondaryRepository((InternalRepository)k));
    }

    @Override
    public void removeSecondaryRepository(InternalRepository repository) {
        SecondaryRepository secondaryRepository = (SecondaryRepository)((Object)this.secondaryRepositories.remove(repository));
        if (secondaryRepository != null) {
            secondaryRepository.dispose();
        }
    }

    public Consumer<String> getPasswordValidator() {
        return this.passwordValidator;
    }

    public void setPasswordValidator(Consumer<String> passwordValidator) {
        this.checkInactive();
        this.passwordValidator = passwordValidator;
    }

    @Override
    public Realm getRealm() {
        return this.realm;
    }

    public Role getRole(String id) {
        Role item = this.realm.getRole(id);
        if (item == null) {
            throw new SecurityException("Role " + id + " not found");
        }
        return item;
    }

    public Group getGroup(String id) {
        Group item = this.realm.getGroup(id);
        if (item == null) {
            throw new SecurityException("Group " + id + " not found");
        }
        return item;
    }

    public User getUser(String id) {
        User item = this.realm.getUser(id);
        if (item == null) {
            throw new SecurityException("User " + id + " not found");
        }
        return item;
    }

    public Role addRole(String id) {
        Role[] result = new Role[1];
        this.modify(realm -> {
            Role role = realm.addRole(id);
        });
        return result[0];
    }

    public Group addGroup(String id) {
        Group[] result = new Group[1];
        this.modify(realm -> {
            Group group = realm.addGroup(id);
        });
        return result[0];
    }

    public User addUser(String id) {
        User[] result = new User[1];
        this.modify(realm -> {
            User user = realm.addUser(id);
        });
        return result[0];
    }

    public User addUser(String id, String password) {
        User[] result = new User[1];
        this.modify(realm -> {
            userArray[0] = realm.addUser(id);
            if (!StringUtil.isEmpty((String)password)) {
                UserPassword userPassword = SF.createUserPassword();
                userPassword.setEncrypted(new String(password));
                result[0].setPassword(userPassword);
            }
        });
        return result[0];
    }

    public User addUser(IPasswordCredentials credentials) {
        return this.addUser(credentials.getUserID(), SecurityUtil.toString((char[])credentials.getPassword()));
    }

    public User setPassword(String id, String password) {
        if (this.passwordValidator != null) {
            this.passwordValidator.accept(password);
        }
        User[] result = new User[1];
        this.modify(realm -> {
            User user = realm.setPassword(id, password);
        });
        return result[0];
    }

    public Role removeRole(String id) {
        Role[] result = new Role[1];
        this.modify(realm -> {
            Role role = realm.removeRole(id);
        });
        return result[0];
    }

    public Group removeGroup(String id) {
        Group[] result = new Group[1];
        this.modify(realm -> {
            Group group = realm.removeGroup(id);
        });
        return result[0];
    }

    public User removeUser(String id) {
        User[] result = new User[1];
        this.modify(realm -> {
            User user = realm.removeUser(id);
        });
        return result[0];
    }

    @Override
    public void read(ISecurityManager.RealmOperation operation) {
        this.checkReady();
        operation.execute(this.realm);
    }

    @Override
    public void modify(ISecurityManager.RealmOperation operation) {
        this.modify(operation, false);
    }

    @Override
    public void modify(ISecurityManager.RealmOperation operation, boolean waitUntilReadable) {
        this.modifyWithInfo(operation, waitUntilReadable);
    }

    @Override
    public CDOCommitInfo modifyWithInfo(ISecurityManager.RealmOperation operation, boolean waitUntilReadable) {
        this.checkReady();
        try (CDOTransaction transaction = this.realmSession.openTransaction();){
            Realm transactionRealm = (Realm)transaction.getObject((EObject)this.realm);
            operation.execute(transactionRealm);
            CDOCommitInfo info = transaction.commit();
            if (waitUntilReadable && !this.realmView.waitForUpdate(info.getTimeStamp(), 10000L)) {
                throw new TimeoutRuntimeException();
            }
            CDOCommitInfo cDOCommitInfo = info;
            return cDOCommitInfo;
        }
    }

    @Override
    public InternalSecurityManager.CommitHandler[] getCommitHandlers() {
        return this.commitHandlers;
    }

    @Override
    public InternalSecurityManager.CommitHandler2[] getCommitHandlers2() {
        return this.commitHandlers2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addCommitHandler(InternalSecurityManager.CommitHandler handler) {
        this.checkInactive();
        Object object = this.commitHandlerLock;
        synchronized (object) {
            this.commitHandlers = (InternalSecurityManager.CommitHandler[])ArrayUtil.add((Object[])this.commitHandlers, (Object)handler);
            if (handler instanceof InternalSecurityManager.CommitHandler2) {
                this.commitHandlers2 = (InternalSecurityManager.CommitHandler2[])ArrayUtil.add((Object[])this.commitHandlers2, (Object)((InternalSecurityManager.CommitHandler2)handler));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeCommitHandler(InternalSecurityManager.CommitHandler handler) {
        this.checkInactive();
        Object object = this.commitHandlerLock;
        synchronized (object) {
            this.commitHandlers = (InternalSecurityManager.CommitHandler[])ArrayUtil.remove((Object[])this.commitHandlers, (Object)handler);
            if (handler instanceof InternalSecurityManager.CommitHandler2) {
                this.commitHandlers2 = (InternalSecurityManager.CommitHandler2[])ArrayUtil.remove((Object[])this.commitHandlers2, (Object)((InternalSecurityManager.CommitHandler2)handler));
            }
        }
    }

    protected void initCommitHandlers(boolean firstTime) {
        InternalSecurityManager.CommitHandler[] handlers = this.getCommitHandlers();
        int i = 0;
        while (i < handlers.length) {
            InternalSecurityManager.CommitHandler handler = handlers[i];
            try {
                handler.init(this, firstTime);
                OM.LOG.info("Security realm handled by " + handler);
            }
            catch (Exception ex) {
                OM.LOG.error((Throwable)ex);
            }
            ++i;
        }
    }

    protected void handleCommit(IStoreAccessor.CommitContext commitContext, User user) {
        InternalSecurityManager.CommitHandler[] handlers = this.getCommitHandlers();
        int i = 0;
        while (i < handlers.length) {
            InternalSecurityManager.CommitHandler handler = handlers[i];
            try {
                handler.handleCommit(this, commitContext, user);
            }
            catch (Exception ex) {
                OM.LOG.error((Throwable)ex);
            }
            ++i;
        }
    }

    protected void handleCommitted(IStoreAccessor.CommitContext commitContext) {
        InternalSecurityManager.CommitHandler2[] handlers = this.getCommitHandlers2();
        int i = 0;
        while (i < handlers.length) {
            InternalSecurityManager.CommitHandler2 handler = handlers[i];
            try {
                handler.handleCommitted(this, commitContext);
            }
            catch (Exception ex) {
                OM.LOG.error((Throwable)ex);
            }
            ++i;
        }
    }

    protected void checkReady() {
        if (this.realm == null || this.realmSession == null) {
            this.checkActive();
        }
    }

    protected void init() {
        CDOResource resource;
        boolean firstTime;
        if (this.realm != null) {
            return;
        }
        if (this.repository == null) {
            return;
        }
        this.repository.addListener(this.repositoryListener);
        if (!LifecycleUtil.isActive((Object)this.repository)) {
            return;
        }
        String repositoryName = this.repository.getName();
        String acceptorName = String.valueOf(repositoryName) + "_security";
        this.acceptor = Net4jUtil.getAcceptor((IManagedContainer)this.container, (String)"jvm", (String)acceptorName);
        this.connector = Net4jUtil.getConnector((IManagedContainer)this.container, (String)"jvm", (String)acceptorName);
        CDONet4jSessionConfiguration config = CDONet4jUtil.createNet4jSessionConfiguration();
        config.setConnector(this.connector);
        config.setRepositoryName(repositoryName);
        config.setUserID("CDO_SYSTEM");
        this.realmSession = config.openNet4jSession();
        this.realmSession.options().setGeneratedPackageEmulationEnabled(true);
        this.realmSession.addListener(this.realmInvalidationListener);
        CDOTransaction initialTransaction = this.realmSession.openTransaction();
        boolean bl = firstTime = !initialTransaction.hasResource(this.realmPath);
        if (firstTime) {
            this.realm = this.createRealm();
            resource = initialTransaction.createResource(this.realmPath);
            resource.getContents().add((Object)this.realm);
            OM.LOG.info("Security realm created in " + this.realmPath);
        } else {
            resource = initialTransaction.getResource(this.realmPath);
            this.realm = (Realm)resource.getContents().get(0);
            OM.LOG.info("Security realm loaded from " + this.realmPath);
        }
        try {
            try {
                initialTransaction.commit();
            }
            catch (Exception ex) {
                throw WrappedException.wrap((Exception)ex);
            }
        }
        finally {
            initialTransaction.close();
        }
        this.realmView = this.realmSession.openView();
        this.realmView.addListener(this.realmInvalidationListener);
        this.realm = (Realm)this.realmView.getObject((EObject)this.realm);
        this.realmID = this.realm.cdoID();
        InternalSessionManager sessionManager = this.repository.getSessionManager();
        sessionManager.setAuthenticator(this.authenticator);
        sessionManager.setPermissionManager(this.permissionManager);
        sessionManager.addListener(this.sessionManagerListener);
        this.repository.addHandler((IRepository.Handler)this.writeAccessHandler);
        this.register(this.repository);
        this.initCommitHandlers(firstTime);
    }

    protected Realm createRealm() {
        Realm realm = SF.createRealm("Security Realm");
        realm.setDefaultRoleDirectory(this.addDirectory(realm, "Roles"));
        realm.setDefaultGroupDirectory(this.addDirectory(realm, "Groups"));
        realm.setDefaultUserDirectory(this.addDirectory(realm, "Users"));
        Role allReaderRole = realm.addRole("All Objects Reader");
        allReaderRole.getPermissions().add((Object)SF.createFilterPermission(Access.READ, new PermissionFilter[]{SF.createResourceFilter(".*", PatternStyle.REGEX)}));
        Role allWriterRole = realm.addRole("All Objects Writer");
        allWriterRole.getPermissions().add((Object)SF.createFilterPermission(Access.WRITE, new PermissionFilter[]{SF.createResourceFilter(".*", PatternStyle.REGEX)}));
        Role normalReaderRole = realm.addRole("Normal Objects Reader");
        normalReaderRole.getPermissions().add((Object)SF.createFilterPermission(Access.READ, new PermissionFilter[]{SF.createNotFilter((PermissionFilter)SF.createResourceFilter(this.realmPath, PatternStyle.EXACT, false))}));
        Role normalWriterRole = realm.addRole("Normal Objects Writer");
        normalWriterRole.getPermissions().add((Object)SF.createFilterPermission(Access.WRITE, new PermissionFilter[]{SF.createNotFilter((PermissionFilter)SF.createResourceFilter(this.realmPath, PatternStyle.EXACT, false))}));
        Role treeReaderRole = realm.addRole("Resource Tree Reader");
        treeReaderRole.getPermissions().add((Object)SF.createFilterPermission(Access.READ, new PermissionFilter[]{SF.createPackageFilter((EPackage)EresourcePackage.eINSTANCE)}));
        Role treeWriterRole = realm.addRole("Resource Tree Writer");
        treeWriterRole.getPermissions().add((Object)SF.createFilterPermission(Access.WRITE, new PermissionFilter[]{SF.createPackageFilter((EPackage)EresourcePackage.eINSTANCE)}));
        Role adminRole = realm.addRole("Administration");
        adminRole.getPermissions().add((Object)SF.createFilterPermission(Access.WRITE, new PermissionFilter[]{SF.createResourceFilter(this.realmPath, PatternStyle.EXACT, false)}));
        adminRole.getPermissions().add((Object)SF.createFilterPermission(Access.READ, new PermissionFilter[]{SF.createResourceFilter(this.realmPath, PatternStyle.EXACT, true)}));
        Group adminsGroup = realm.addGroup("Administrators");
        adminsGroup.getRoles().add((Object)adminRole);
        realm.addGroup("Users");
        User adminUser = realm.addUser("Administrator", "0000");
        adminUser.getGroups().add((Object)adminsGroup);
        return realm;
    }

    protected Directory addDirectory(Realm realm, String name) {
        Directory directory = SF.createDirectory(name);
        realm.getItems().add((Object)directory);
        return directory;
    }

    protected CDOPermission convertPermission(Access access) {
        if (access != null) {
            switch (access) {
                case READ: {
                    return CDOPermission.READ;
                }
                case WRITE: {
                    return CDOPermission.WRITE;
                }
            }
        }
        return CDOPermission.NONE;
    }

    protected CDOPermission authorize(CDORevision revision, CDORevisionProvider revisionProvider, CDOBranchPoint securityContext, ISession session, Access defaultAccess, Permission[] permissions) {
        boolean setUser;
        this.waitForRealmUpdate(securityContext);
        boolean bl = setUser = defaultAccess == null;
        if (setUser) {
            UserInfo userInfo = this.getUserInfo(session);
            User user = userInfo.getUser();
            defaultAccess = user.getDefaultAccess();
            permissions = userInfo.getPermissions();
            PermissionUtil.setUser((String)user.getId());
        }
        try {
            CDOPermission result = this.convertPermission(defaultAccess);
            if (result == CDOPermission.WRITE) {
                CDOPermission cDOPermission = result;
                return cDOPermission;
            }
            int i = 0;
            while (i < permissions.length) {
                Permission permission = permissions[i];
                CDOPermission p = this.convertPermission(permission.getAccess());
                if (p.ordinal() > result.ordinal() && permission.isApplicable(revision, revisionProvider, securityContext) && (result = p) == CDOPermission.WRITE) {
                    CDOPermission cDOPermission = result;
                    return cDOPermission;
                }
                ++i;
            }
            CDOPermission cDOPermission = result;
            return cDOPermission;
        }
        finally {
            if (setUser) {
                PermissionUtil.setUser(null);
            }
        }
    }

    protected void authorizeCommit(final IStoreAccessor.CommitContext commitContext, UserInfo userInfo) {
        PermissionUtil.setUser((String)userInfo.getUserId());
        PermissionUtil.initViewCreation(xxx -> CDOServerUtil.openView((IStoreAccessor.CommitContext)commitContext));
        try {
            PermissionImpl[] assignedPermissions;
            CDOID[] detachedObjects;
            CDOBranchPoint securityContext = commitContext.getBranchPoint();
            ITransaction transaction = commitContext.getTransaction();
            ISession session = transaction.getSession();
            Access userDefaultAccess = userInfo.getDefaultAccess();
            Permission[] userPermissions = userInfo.getPermissions();
            if (!DISABLE_DETACH_CHECKS && (detachedObjects = commitContext.getDetachedObjects()) != null && detachedObjects.length != 0) {
                int i = 0;
                while (i < detachedObjects.length) {
                    CDOID id = detachedObjects[i];
                    CDORevision revision = transaction.getRevision(id);
                    CDOPermission permission = this.authorize(revision, (CDORevisionProvider)transaction, securityContext, session, userDefaultAccess, userPermissions);
                    if (permission != CDOPermission.WRITE) {
                        throw new SecurityException("User " + commitContext.getUserID() + " is not allowed to detach " + revision);
                    }
                    ++i;
                }
            }
            final InternalCDORevision[] revisions = commitContext.getDirtyObjects();
            final InternalCDORevisionDelta[] revisionDeltas = commitContext.getDirtyObjectDeltas();
            int securityImpact = 0;
            int i = 0;
            while (i < revisions.length) {
                InternalCDORevisionDelta revisionDelta;
                InternalCDORevision revision = revisions[i];
                CDOPermission permission = this.authorize((CDORevision)revision, (CDORevisionProvider)commitContext, securityContext, session, userDefaultAccess, userPermissions);
                if (permission != CDOPermission.WRITE) {
                    throw new SecurityException("User " + commitContext.getUserID() + " is not allowed to write to " + revision);
                }
                if (securityImpact != 2 && CDORevisionUtil.isContained((CDOID)(revisionDelta = revisionDeltas[i]).getID(), (CDOID)this.realmID, (CDORevisionProvider)transaction)) {
                    securityImpact = 2;
                }
                ++i;
            }
            HashSet<PermissionImpl> impactedRules = null;
            if (securityImpact != 2 && (assignedPermissions = this.permissionArray).length != 0) {
                PermissionImpl.CommitImpactContext commitImpactContext = new PermissionImpl.CommitImpactContext(){

                    public CDORevision[] getNewObjects() {
                        return commitContext.getNewObjects();
                    }

                    public CDORevision[] getDirtyObjects() {
                        return revisions;
                    }

                    public CDORevisionDelta[] getDirtyObjectDeltas() {
                        return revisionDeltas;
                    }

                    public CDOID[] getDetachedObjects() {
                        return commitContext.getDetachedObjects();
                    }
                };
                int i2 = 0;
                while (i2 < assignedPermissions.length) {
                    PermissionImpl permission = assignedPermissions[i2];
                    if (permission.isImpacted(commitImpactContext)) {
                        if (impactedRules == null) {
                            impactedRules = new HashSet<PermissionImpl>();
                        }
                        impactedRules.add(permission);
                    }
                    ++i2;
                }
                if (impactedRules != null) {
                    securityImpact = 1;
                }
            }
            ((InternalCommitContext)commitContext).setSecurityImpact((byte)securityImpact, impactedRules);
        }
        finally {
            PermissionUtil.setUser(null);
            PermissionUtil.doneViewCreation();
        }
    }

    protected void sessionAdded(ISession session) {
        String userID = session.getUserID();
        if (userID != null) {
            UserInfo result = this.userInfos.computeIfAbsent(userID, k -> {
                User user = this.getUser((String)k);
                UserInfo userInfo = new UserInfo(user);
                this.updatePermissions(userInfo, true);
                return userInfo;
            });
            result.addSessionRef();
        }
    }

    protected void sessionRemoved(ISession session) {
        String userID = session.getUserID();
        if (userID != null) {
            this.userInfos.computeIfPresent(userID, (k, v) -> {
                if (v.removeSessionRef()) {
                    return null;
                }
                return v;
            });
        }
    }

    protected UserInfo getUserInfo(ISession session) {
        String userID = session.getUserID();
        UserInfo userInfo = (UserInfo)this.userInfos.get(userID);
        if (userInfo == null) {
            throw new IllegalStateException("No user info for " + userID);
        }
        return userInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clearUserInfos(boolean rebuild) {
        HashBag<PermissionImpl> hashBag = this.permissionBag;
        synchronized (hashBag) {
            this.permissionBag.clear();
            this.permissionArray = null;
            if (rebuild) {
                for (UserInfo userInfo : this.userInfos.values()) {
                    userInfo.rebuildPermissions();
                    this.updatePermissions(userInfo, false);
                }
                this.updatePermissions(null, true);
            } else {
                this.userInfos.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updatePermissions(UserInfo userInfo, boolean updateArray) {
        Permission[] permissions = userInfo == null ? null : userInfo.getPermissions();
        HashBag<PermissionImpl> hashBag = this.permissionBag;
        synchronized (hashBag) {
            if (permissions != null) {
                int i = 0;
                while (i < permissions.length) {
                    Permission permission = permissions[i];
                    this.permissionBag.add((Object)((PermissionImpl)permission));
                    ++i;
                }
            }
            if (updateArray) {
                this.permissionArray = (PermissionImpl[])this.permissionBag.toArray((Object[])new PermissionImpl[this.permissionBag.size()]);
            }
        }
    }

    protected final boolean isAdministrator(User user) {
        Realm realm = this.getRealm();
        if (realm != null) {
            CDORevision revision = realm.cdoRevision();
            CDOView revisionProvider = realm.cdoView();
            CDOView securityContext = realm.cdoView();
            for (Permission permission : user.getAllPermissions()) {
                if (permission.getAccess() != Access.WRITE || !permission.isApplicable(revision, (CDORevisionProvider)revisionProvider, (CDOBranchPoint)securityContext)) continue;
                return true;
            }
        }
        return false;
    }

    protected void doActivate() throws Exception {
        super.doActivate();
        this.init();
    }

    protected void doDeactivate() throws Exception {
        this.clearUserInfos(false);
        this.realm = null;
        this.realmID = null;
        this.realmSession.close();
        this.realmSession = null;
        this.realmView = null;
        this.connector.close();
        this.connector = null;
        this.acceptor.close();
        this.acceptor = null;
        super.doDeactivate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rememberRealmCommit(CDOBranchPoint commitBranchPoint) {
        Object object = this.lastRealmModificationLock;
        synchronized (object) {
            this.lastRealmModification = commitBranchPoint.getTimeStamp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForRealmUpdate(CDOBranchPoint securityContext) {
        if (this.lastRealmModification != null) {
            long contextTime;
            long updateTime;
            Object object = this.lastRealmModificationLock;
            synchronized (object) {
                if (this.lastRealmModification != null) {
                    updateTime = this.lastRealmModification;
                    this.lastRealmModification = null;
                } else {
                    updateTime = 0L;
                }
            }
            if (!(updateTime == 0L || (contextTime = securityContext.getTimeStamp()) != 0L && contextTime >= updateTime || this.realmView.waitForUpdate(updateTime, 10000L))) {
                throw new TimeoutRuntimeException();
            }
        }
    }

    private void register(InternalRepository repository) {
        if (SECURITY_MANAGERS.putIfAbsent((IRepository)repository, this) != null) {
            throw new IllegalStateException("A security manager is already associated with repository " + repository);
        }
    }

    private void unregister(InternalRepository repository) {
        SECURITY_MANAGERS.remove(repository);
    }

    public static InternalSecurityManager get(IRepository repository) {
        return SECURITY_MANAGERS.get(repository);
    }

    private final class Authenticator
    implements IAuthenticator2 {
        public void authenticate(String userID, char[] password) throws SecurityException {
            User user = SecurityManager.this.getUser(userID);
            if (!user.isLocked()) {
                String encrypted;
                UserPassword userPassword = user.getPassword();
                String string = encrypted = userPassword == null ? null : userPassword.getEncrypted();
                if (Arrays.equals(password, SecurityUtil.toCharArray((String)encrypted))) {
                    return;
                }
            }
            throw new SecurityException("Access denied");
        }

        public void updatePassword(String userID, char[] oldPassword, char[] newPassword) {
            this.authenticate(userID, oldPassword);
            SecurityManager.this.setPassword(userID, SecurityUtil.toString((char[])newPassword));
        }

        public void resetPassword(String adminID, char[] adminPassword, String userID, char[] newPassword) {
            this.authenticate(adminID, adminPassword);
            User admin = SecurityManager.this.getUser(adminID);
            if (!SecurityManager.this.isAdministrator(admin)) {
                throw new SecurityException("Password reset requires administrator privilege");
            }
            SecurityManager.this.setPassword(userID, SecurityUtil.toString((char[])newPassword));
        }

        public boolean isAdministrator(String userID) {
            Realm realm = SecurityManager.this.getRealm();
            if (realm != null) {
                User user = realm.getUser(userID);
                return user != null && SecurityManager.this.isAdministrator(user);
            }
            return false;
        }
    }

    private final class PermissionManager
    implements IPermissionManager {
        @Deprecated
        public CDOPermission getPermission(CDORevision revision, CDOBranchPoint securityContext, String userID) {
            throw new UnsupportedOperationException();
        }

        public CDOPermission getPermission(CDORevision revision, final CDOBranchPoint securityContext, final ISession session) {
            String userID = session.getUserID();
            if ("CDO_SYSTEM".equals(userID)) {
                return CDOPermission.WRITE;
            }
            if (revision.getEClass() == SecurityPackage.Literals.USER_PASSWORD) {
                return CDOPermission.NONE;
            }
            InternalCDORevisionManager revisionManager = SecurityManager.this.repository.getRevisionManager();
            ManagedRevisionProvider revisionProvider = new ManagedRevisionProvider((CDORevisionManager)revisionManager, securityContext);
            PermissionUtil.initViewCreation((ViewCreator)new ViewCreator(){

                public CDOView createView(CDORevisionProvider revisionProvider) {
                    CDOView view = CDOServerUtil.openView((ISession)session, (CDOBranchPoint)securityContext, (CDORevisionProvider)revisionProvider);
                    view.getSession().options().setGeneratedPackageEmulationEnabled(true);
                    return view;
                }
            });
            try {
                CDOPermission permission;
                CDOPermission cDOPermission = permission = SecurityManager.this.authorize(revision, (CDORevisionProvider)revisionProvider, securityContext, session, null, null);
                return cDOPermission;
            }
            finally {
                PermissionUtil.doneViewCreation();
            }
        }

        public boolean hasAnyRule(ISession session, Set<? extends Object> rules) {
            String userID = session.getUserID();
            if ("CDO_SYSTEM".equals(userID)) {
                return false;
            }
            UserInfo userInfo = SecurityManager.this.getUserInfo(session);
            Permission[] userPermissions = userInfo.getPermissions();
            int i = 0;
            while (i < userPermissions.length) {
                Permission userPermission = userPermissions[i];
                if (rules.contains(userPermission)) {
                    return true;
                }
                ++i;
            }
            return false;
        }
    }

    private final class RealmValidationHandler
    extends ObjectWriteAccessHandler {
        private final EValidator realmValidator = EValidator.Registry.INSTANCE.getEValidator((EPackage)SecurityPackage.eINSTANCE);

        protected void handleTransactionBeforeCommitting(OMMonitor monitor) throws RuntimeException {
            EObject object;
            BasicDiagnostic diagnostic = new BasicDiagnostic();
            Map<Object, Object> context = this.createValidationContext();
            boolean realmChecked = false;
            EObject[] eObjectArray = this.getDirtyObjects();
            int n = eObjectArray.length;
            int n2 = 0;
            while (n2 < n) {
                object = eObjectArray[n2];
                if (object.eClass().getEPackage() == SecurityPackage.eINSTANCE) {
                    this.validate(object, (DiagnosticChain)diagnostic, context);
                    realmChecked |= object instanceof Realm;
                }
                ++n2;
            }
            eObjectArray = this.getNewObjects();
            n = eObjectArray.length;
            n2 = 0;
            while (n2 < n) {
                object = eObjectArray[n2];
                if (object.eClass().getEPackage() == SecurityPackage.eINSTANCE) {
                    this.validate(object, (DiagnosticChain)diagnostic, context);
                }
                ++n2;
            }
            if (!realmChecked) {
                this.validate((EObject)this.getView().getObject(SecurityManager.this.realmID), (DiagnosticChain)diagnostic, context);
            }
        }

        protected Map<Object, Object> createValidationContext() {
            HashMap<Object, Object> result = new HashMap<Object, Object>();
            IStoreAccessor.CommitContext commitContext = this.getCommitContext();
            result.put(CDORevisionProvider.class, commitContext);
            result.put(CDOBranchPoint.class, commitContext.getBranchPoint());
            return result;
        }

        protected void validate(EObject object, DiagnosticChain diagnostics, Map<Object, Object> context) {
            this.realmValidator.validate(object, diagnostics, context);
            Diagnostic error = this.getError(diagnostics);
            if (error != null) {
                throw new IRepository.WriteAccessHandler.TransactionValidationException("Security realm integrity violation: " + error.getMessage());
            }
        }

        protected Diagnostic getError(DiagnosticChain diagnostics) {
            Diagnostic diagnostic = (Diagnostic)diagnostics;
            if (diagnostic.getSeverity() >= 4) {
                for (Diagnostic child : diagnostic.getChildren()) {
                    if (child.getSeverity() < 4) continue;
                    return child;
                }
            }
            return null;
        }
    }

    private final class SecondaryRepository
    extends LifecycleEventAdapter
    implements IRepository.WriteAccessHandler {
        private final InternalRepository delegate;

        public SecondaryRepository(InternalRepository delegate) {
            this.delegate = delegate;
            InternalSessionManager sessionManager = delegate.getSessionManager();
            sessionManager.setAuthenticator(SecurityManager.this.authenticator);
            sessionManager.setPermissionManager(SecurityManager.this.permissionManager);
            sessionManager.addListener(SecurityManager.this.sessionManagerListener);
            delegate.addListener((IListener)this);
            delegate.addHandler((IRepository.Handler)this);
            SecurityManager.this.register(delegate);
        }

        public void handleTransactionBeforeCommitting(ITransaction transaction, IStoreAccessor.CommitContext commitContext, OMMonitor monitor) throws RuntimeException {
            this.handleNewPackageUnits(commitContext);
            UserInfo userInfo = SecurityManager.this.getUserInfo(transaction.getSession());
            SecurityManager.this.authorizeCommit(commitContext, userInfo);
        }

        public void handleTransactionAfterCommitted(ITransaction transaction, IStoreAccessor.CommitContext commitContext, OMMonitor monitor) {
        }

        public void dispose() {
            SecurityManager.this.unregister(this.delegate);
        }

        protected void onDeactivated(ILifecycle lifecycle) {
            SecurityManager.this.removeSecondaryRepository(this.delegate);
        }

        private void handleNewPackageUnits(IStoreAccessor.CommitContext commitContext) {
            InternalCDOPackageUnit[] newPackageUnits = commitContext.getNewPackageUnits();
            if (newPackageUnits != null && newPackageUnits.length != 0) {
                InternalCDOPackageRegistry realmPackageRegistry = SecurityManager.this.getRepository().getPackageRegistry();
                ArrayList<InternalCDOPackageUnit> unknownPackageUnits = new ArrayList<InternalCDOPackageUnit>();
                InternalCDOPackageUnit[] internalCDOPackageUnitArray = newPackageUnits;
                int n = newPackageUnits.length;
                int n2 = 0;
                while (n2 < n) {
                    InternalCDOPackageUnit packageUnit = internalCDOPackageUnitArray[n2];
                    String nsURI = packageUnit.getID();
                    if (!realmPackageRegistry.containsKey((Object)nsURI)) {
                        unknownPackageUnits.add((InternalCDOPackageUnit)CDOModelUtil.copyPackageUnit((CDOPackageUnit)packageUnit));
                    }
                    ++n2;
                }
                if (!unknownPackageUnits.isEmpty()) {
                    InternalCDOPackageUnit[] unitArray = unknownPackageUnits.toArray(new InternalCDOPackageUnit[unknownPackageUnits.size()]);
                    try {
                        RunnableWithException.forkAndWait(() -> {
                            InternalCDOPackageRegistry internalCDOPackageRegistry2 = realmPackageRegistry;
                            synchronized (internalCDOPackageRegistry2) {
                                realmPackageRegistry.putPackageUnits(unitArray, CDOPackageUnit.State.LOADED);
                            }
                            this.commitRealmPackageUnits(unitArray);
                        });
                    }
                    catch (Exception ex) {
                        throw WrappedException.wrap((Exception)ex);
                    }
                }
            }
        }

        private void commitRealmPackageUnits(InternalCDOPackageUnit[] packageUnits) {
            IStoreAccessor writer = SecurityManager.this.getRepository().getStore().getWriter(null);
            StoreThreadLocal.setAccessor((IStoreAccessor)writer);
            try {
                writer.writePackageUnits(packageUnits, (OMMonitor)new Monitor());
                writer.commit((OMMonitor)new Monitor());
            }
            finally {
                StoreThreadLocal.release();
            }
        }
    }

    private static final class UserInfo
    extends AtomicInteger {
        private static final long serialVersionUID = 1L;
        private final User user;
        private Permission[] permissions;

        public UserInfo(User user) {
            this.user = user;
            this.rebuildPermissions();
        }

        public User getUser() {
            return this.user;
        }

        public String getUserId() {
            return this.user.getId();
        }

        public Access getDefaultAccess() {
            return this.user.getDefaultAccess();
        }

        public Permission[] getPermissions() {
            return this.permissions;
        }

        public void rebuildPermissions() {
            EList allPermissions = this.user.getAllPermissions();
            this.permissions = (Permission[])allPermissions.toArray((Object[])new Permission[allPermissions.size()]);
        }

        public synchronized void addSessionRef() {
            this.incrementAndGet();
        }

        public synchronized boolean removeSessionRef() {
            return this.decrementAndGet() == 0;
        }

        @Override
        public String toString() {
            return "UserInfo[user=" + this.getUserId() + ", refs=" + super.toString() + "]";
        }
    }

    private final class WriteAccessHandler
    implements IRepository.WriteAccessHandler {
        private final IRepository.WriteAccessHandler realmValidationHandler;

        public WriteAccessHandler() {
            this.realmValidationHandler = new RealmValidationHandler();
        }

        public void handleTransactionBeforeCommitting(ITransaction transaction, IStoreAccessor.CommitContext commitContext, OMMonitor monitor) throws RuntimeException {
            if (transaction.getSessionID() == SecurityManager.this.realmSession.getSessionID()) {
                SecurityManager.this.handleCommit(commitContext, null);
                ((InternalCommitContext)commitContext).setSecurityImpact((byte)2, null);
                return;
            }
            UserInfo userInfo = SecurityManager.this.getUserInfo(transaction.getSession());
            SecurityManager.this.handleCommit(commitContext, userInfo.getUser());
            SecurityManager.this.authorizeCommit(commitContext, userInfo);
            if (commitContext.getSecurityImpact() == 2) {
                this.realmValidationHandler.handleTransactionBeforeCommitting(transaction, commitContext, monitor);
            }
        }

        public void handleTransactionAfterCommitted(ITransaction transaction, IStoreAccessor.CommitContext commitContext, OMMonitor monitor) {
            if (commitContext.getSecurityImpact() == 2) {
                CDOBranchPoint commitBranchPoint = commitContext.getBranchPoint();
                SecurityManager.this.rememberRealmCommit(commitBranchPoint);
            }
            SecurityManager.this.handleCommitted(commitContext);
        }
    }
}

