/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.explorer.ui.checkouts.wizards;

import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.cdo.eresource.CDOResourceNode;
import org.eclipse.emf.cdo.explorer.checkouts.CDOCheckout;
import org.eclipse.emf.cdo.explorer.ui.bundle.OM;
import org.eclipse.emf.cdo.explorer.ui.checkouts.CDOCheckoutContentProvider;
import org.eclipse.emf.cdo.explorer.ui.checkouts.wizards.CheckoutNodeWizardPage;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.net4j.util.StringUtil;
import org.eclipse.net4j.util.ui.UIUtil;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class LinkedResourceWizardPage
extends CheckoutNodeWizardPage {
    private static final String CONTAINER_MESSAGE = "Select the workspace container of the new link";
    private static final String NAME_MESSAGE = "Enter the name of the new link";
    private static final IWorkspaceRoot ROOT = ResourcesPlugin.getWorkspace().getRoot();
    private TreeViewer workspaceViewer;
    private IContainer targetContainer;
    private Text nameText;
    private String name;

    public LinkedResourceWizardPage(IStructuredSelection selection) {
        super("LinkPage", "Linked Resource", selection);
        this.targetContainer = LinkedResourceWizardPage.getContainer(selection);
    }

    public final IContainer getTargetContainer() {
        return this.targetContainer;
    }

    public final String getName() {
        return this.name;
    }

    @Override
    protected void doCreateControl(Composite parent) {
        this.setImageDescriptor(OM.getImageDescriptor("icons/wiz/new_link.gif"));
        this.setMessage("Enter the name of the " + this.title.toLowerCase() + ".");
        super.doCreateControl(parent);
        Label workspaceLabel = new Label(parent, 0);
        workspaceLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
        workspaceLabel.setText("Select the workspace container of the new link:");
        this.workspaceViewer = new TreeViewer(parent, 2048);
        this.workspaceViewer.getTree().setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        this.workspaceViewer.setContentProvider((IContentProvider)new ContainerContentProvider());
        this.workspaceViewer.setLabelProvider((IBaseLabelProvider)WorkbenchLabelProvider.getDecoratingWorkbenchLabelProvider());
        this.workspaceViewer.setComparator(new ViewerComparator());
        this.workspaceViewer.setUseHashlookup(true);
        this.workspaceViewer.addSelectionChangedListener(event -> this.containerSelectionChanged(LinkedResourceWizardPage.getContainer(event.getStructuredSelection())));
        this.workspaceViewer.addDoubleClickListener(event -> {
            Object item = this.workspaceViewer.getStructuredSelection().getFirstElement();
            if (item != null) {
                if (this.workspaceViewer.getExpandedState(item)) {
                    this.workspaceViewer.collapseToLevel(item, 1);
                } else {
                    this.workspaceViewer.expandToLevel(item, 1);
                }
            }
        });
        this.workspaceViewer.setInput((Object)ROOT);
        this.workspaceViewer.expandToLevel(1);
        if (this.targetContainer != null) {
            UIUtil.asyncExec((Display)parent.getDisplay(), () -> this.workspaceViewer.setSelection((ISelection)new StructuredSelection((Object)this.targetContainer), true));
        }
        Label nameLabel = new Label(parent, 0);
        nameLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
        nameLabel.setText("Enter the name of the new link:");
        this.nameText = new Text(parent, 2048);
        this.nameText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.nameText.addModifyListener(e -> {
            this.name = this.nameText.getText();
            this.validate();
        });
    }

    @Override
    protected void nodeSelectionChanged(Object oldNode, Object newNode) {
        this.updateName();
    }

    private void containerSelectionChanged(IContainer container) {
        this.targetContainer = container;
        this.validate();
    }

    private void updateName() {
        String newName = null;
        Object node = this.getNode();
        if (node != null) {
            newName = node instanceof CDOCheckout ? ((CDOCheckout)node).getLabel() : ((CDOResourceNode)node).getName();
        }
        this.nameText.setText(StringUtil.safe(newName));
    }

    @Override
    protected String getNodeMessage() {
        return "Select the node to be linked into the workspace";
    }

    @Override
    protected TreeViewer createNodeViewer(Composite container) {
        return CDOCheckoutContentProvider.createTreeViewer(container, child -> true);
    }

    @Override
    protected void deferredInit() {
        super.deferredInit();
        this.updateName();
    }

    @Override
    protected void doValidate() throws Exception {
        super.doValidate();
        if (this.targetContainer == null) {
            throw new Exception("Select the workspace container of the new link.");
        }
        if (this.name.length() == 0) {
            throw new Exception("Enter a name for the new link.");
        }
        IResource existingResource = this.targetContainer.findMember(this.name);
        if (existingResource != null && existingResource.exists()) {
            throw new Exception("Name is not unique within the selected workspace container.");
        }
    }

    private static IContainer getContainer(IStructuredSelection selection) {
        Object element = selection.getFirstElement();
        if (element instanceof IContainer) {
            return (IContainer)element;
        }
        return null;
    }

    private static final class ContainerContentProvider
    implements ITreeContentProvider {
        public void dispose() {
        }

        public Object[] getChildren(Object element) {
            IContainer container;
            if (element instanceof IContainer && this.isValid((IResource)(container = (IContainer)element))) {
                try {
                    ArrayList<IResource> children = new ArrayList<IResource>();
                    IResource[] iResourceArray = container.members();
                    int n = iResourceArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IResource member = iResourceArray[n2];
                        if (member.getType() != 1 && this.isValid(member)) {
                            children.add(member);
                        }
                        ++n2;
                    }
                    return children.toArray();
                }
                catch (CoreException coreException) {
                    // empty catch block
                }
            }
            return new Object[0];
        }

        public Object[] getElements(Object element) {
            return this.getChildren(element);
        }

        public Object getParent(Object element) {
            if (element instanceof IProject) {
                return ROOT;
            }
            if (element instanceof IResource) {
                return ((IResource)element).getParent();
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            return this.getChildren(element).length > 0;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        private boolean isValid(IResource resource) {
            return resource.isAccessible() && !resource.isLinked() && !resource.isVirtual();
        }
    }
}

