/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.dawn.gmf.util;

import java.util.Collection;
import java.util.List;
import org.eclipse.emf.cdo.CDOObject;
import org.eclipse.emf.cdo.dawn.internal.util.bundle.OM;
import org.eclipse.emf.cdo.util.CDOUtil;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.ECrossReferenceAdapter;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ConnectionEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.CanonicalEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.parts.DiagramDocumentEditor;
import org.eclipse.gmf.runtime.diagram.ui.services.editpart.EditPartService;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.net4j.util.om.trace.ContextTracer;
import org.eclipse.ui.PlatformUI;

public class DawnDiagramUpdater {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG, DawnDiagramUpdater.class);

    public static void refresh(final IGraphicalEditPart editPart) {
        TransactionalEditingDomain editingDomain = editPart.getEditingDomain();
        editingDomain.getCommandStack().execute((Command)new RecordingCommand(editingDomain){

            public void doExecute() {
                editPart.refresh();
                if (editPart instanceof ConnectionEditPart) {
                    DawnDiagramUpdater.refresh((IGraphicalEditPart)((ConnectionEditPart)editPart).getTarget());
                    DawnDiagramUpdater.refresh((IGraphicalEditPart)((ConnectionEditPart)editPart).getSource());
                }
            }
        });
    }

    public static void refreshEditPart(EditPart editPart) {
        DawnDiagramUpdater.refeshEditpartInternal(editPart);
    }

    public static void refreshEditPart(final EditPart editPart, DiagramDocumentEditor editor) {
        try {
            editor.getEditingDomain().runExclusive(new Runnable(){

                @Override
                public void run() {
                    DawnDiagramUpdater.refreshEditPart(editPart);
                }
            });
        }
        catch (InterruptedException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static void refreshEditCurrentSelected(TransactionalEditingDomain editingDomain) {
        editingDomain.getCommandStack().execute((Command)new RecordingCommand(editingDomain){

            protected void doExecute() {
                ISelection selection = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService().getSelection();
                if (selection instanceof IStructuredSelection) {
                    IStructuredSelection structuredSelection = (IStructuredSelection)selection;
                    if (structuredSelection.size() != 1) {
                        return;
                    }
                    if (structuredSelection.getFirstElement() instanceof EditPart && ((EditPart)structuredSelection.getFirstElement()).getModel() instanceof View) {
                        EObject modelElement = ((View)((EditPart)structuredSelection.getFirstElement()).getModel()).getElement();
                        List editPolicies = CanonicalEditPolicy.getRegisteredEditPolicies((EObject)modelElement);
                        for (CanonicalEditPolicy nextEditPolicy : editPolicies) {
                            nextEditPolicy.refresh();
                        }
                    }
                }
            }
        });
    }

    private static void refeshEditpartInternal(EditPart editPart) {
        if (editPart != null) {
            try {
                if (DawnDiagramUpdater.hasValidModel(editPart)) {
                    editPart.refresh();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (editPart instanceof DiagramEditPart) {
                for (Object connectionEditPart : ((DiagramEditPart)editPart).getConnections()) {
                    if (!(connectionEditPart instanceof EditPart) || ((Edge)((EditPart)connectionEditPart).getModel()).getBendpoints() == null) continue;
                    DawnDiagramUpdater.refeshEditpartInternal((EditPart)connectionEditPart);
                }
            }
            for (Object childEditPart : editPart.getChildren()) {
                if (!(childEditPart instanceof EditPart)) continue;
                DawnDiagramUpdater.refeshEditpartInternal((EditPart)childEditPart);
            }
        }
    }

    private static boolean hasValidModel(EditPart editPart) {
        CDOObject cdoObject;
        Object model = editPart.getModel();
        return !(model instanceof EObject) || !(cdoObject = CDOUtil.getCDOObject((EObject)((EObject)model), (boolean)false)).cdoInvalid();
    }

    public static View findViewByContainer(EObject element) {
        if (element instanceof View) {
            return (View)element;
        }
        if (element.eContainer() == null) {
            return null;
        }
        if (element.eContainer() instanceof View) {
            return (View)element.eContainer();
        }
        return DawnDiagramUpdater.findViewByContainer(element.eContainer());
    }

    public static View findViewForModel(EObject object, DiagramDocumentEditor editor) {
        if (object == null) {
            return null;
        }
        for (EObject e : editor.getDiagram().eContents()) {
            if (!(e instanceof View)) continue;
            View view = (View)e;
            if (object.equals(view.getElement()) && TRACER.isEnabled()) {
                TRACER.format("FOUND View: {0} for view obj: {1} ", new Object[]{e, object});
            }
            return (View)e;
        }
        return null;
    }

    public static View getViewFromObject(EObject element, DiagramDocumentEditor editor) {
        View view;
        if (element instanceof Diagram) {
            View view2 = ViewUtil.getViewContainer((EObject)element);
            return view2;
        }
        if (element instanceof View) {
            view = (View)element;
        } else {
            view = DawnDiagramUpdater.findViewByContainer(element);
            if (view == null) {
                view = DawnDiagramUpdater.findViewForModel(element, editor);
            }
        }
        return view;
    }

    public static EditPart createOrFindEditPartIfViewExists(View view, DiagramDocumentEditor editor) {
        EditPart editPart = DawnDiagramUpdater.findEditPart(view, (EditPart)editor.getDiagramEditPart());
        if (view != null && editPart == null) {
            if (TRACER.isEnabled()) {
                TRACER.format("EditPart does not exist for view  {0} ", new Object[]{view});
            }
            editPart = EditPartService.getInstance().createGraphicEditPart(view);
            DawnDiagramUpdater.setParentEditPart(editor, view, editPart);
        }
        if (TRACER.isEnabled()) {
            TRACER.format("Found EditPart:  {0} ", new Object[]{editPart});
        }
        return editPart;
    }

    public static void setParentEditPart(DiagramDocumentEditor editor, View view, EditPart editPart) {
        View viewParent = (View)view.eContainer();
        EditPart parentEditPart = DawnDiagramUpdater.findEditPart(viewParent, editor);
        if (parentEditPart == null) {
            parentEditPart = editor.getDiagramEditPart();
        }
        editPart.setParent(parentEditPart);
    }

    public static EditPart findEditPart(View view, DiagramDocumentEditor dawnDiagramEditor) {
        EditPart ep;
        DiagramEditPart diagramEditPart = dawnDiagramEditor.getDiagramEditPart();
        for (Object e : diagramEditPart.getChildren()) {
            ep = (EditPart)e;
            if (!ep.getModel().equals(view)) continue;
            return ep;
        }
        for (Object e : diagramEditPart.getConnections()) {
            ep = (EditPart)e;
            if (!ep.getModel().equals(view)) continue;
            return ep;
        }
        return null;
    }

    public static EditPart findEditPart(View view, EditPart editPart) {
        EditPart ret;
        EditPart child;
        if (editPart.getModel().equals(view)) {
            return editPart;
        }
        for (Object o : editPart.getChildren()) {
            child = (EditPart)o;
            ret = DawnDiagramUpdater.findEditPart(view, child);
            if (ret == null) continue;
            return ret;
        }
        if (editPart instanceof DiagramEditPart) {
            for (Object o : ((DiagramEditPart)editPart).getConnections()) {
                child = (EditPart)o;
                ret = DawnDiagramUpdater.findEditPart(view, child);
                if (ret == null) continue;
                return ret;
            }
        }
        return null;
    }

    public static EditPart findEditPart(View view, EditPartViewer viewer) {
        return (EditPart)viewer.getEditPartRegistry().get(view);
    }

    public static void initializeElement(Diagram diagram) {
        for (Object obj : diagram.getEdges()) {
            Edge edge = (Edge)obj;
            if (edge.isSetElement()) continue;
            boolean eDeliver = edge.eDeliver();
            edge.eSetDeliver(false);
            edge.setElement(null);
            edge.eSetDeliver(eDeliver);
        }
    }

    public static View findViewFromCrossReferences(EObject element) {
        ECrossReferenceAdapter crossreferenceAdapter = ECrossReferenceAdapter.getCrossReferenceAdapter((Notifier)element);
        if (crossreferenceAdapter != null) {
            Collection iinverseReferences = crossreferenceAdapter.getNonNavigableInverseReferences(element);
            for (EStructuralFeature.Setting f : iinverseReferences) {
                if (f.getEStructuralFeature() != NotationPackage.Literals.VIEW__ELEMENT) continue;
                return (View)f.getEObject();
            }
        }
        return null;
    }

    public static View findView(EObject element) {
        View view = DawnDiagramUpdater.findViewByContainer(element);
        if (view == null) {
            view = DawnDiagramUpdater.findViewFromCrossReferences(element);
        }
        return view;
    }
}

