/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.explorer;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.eclipse.emf.cdo.common.commit.CDOCommitInfo;
import org.eclipse.emf.cdo.common.lob.CDOBlob;
import org.eclipse.emf.cdo.common.lob.CDOClob;
import org.eclipse.emf.cdo.common.lob.CDOLobStore;
import org.eclipse.emf.cdo.common.util.CDOException;
import org.eclipse.emf.cdo.common.util.CDOResourceNodeNotFoundException;
import org.eclipse.emf.cdo.eresource.CDOBinaryResource;
import org.eclipse.emf.cdo.eresource.CDOResourceNode;
import org.eclipse.emf.cdo.eresource.CDOTextResource;
import org.eclipse.emf.cdo.explorer.CDOExplorerUtil;
import org.eclipse.emf.cdo.explorer.checkouts.CDOCheckout;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.impl.URIHandlerImpl;
import org.eclipse.emf.internal.cdo.view.CDOURIHandler;
import org.eclipse.net4j.util.collection.Closeable;
import org.eclipse.net4j.util.io.IOUtil;
import org.eclipse.net4j.util.io.ReaderInputStream;

public abstract class CDOExplorerURIHandler<NODE extends CDOResourceNode>
extends URIHandlerImpl {
    public static final CDOExplorerURIHandler<CDOTextResource> TEXT = new TextURIHandler();
    public static final CDOExplorerURIHandler<CDOBinaryResource> BINARY = new BinaryURIRHandler();
    private final String scheme;

    protected CDOExplorerURIHandler(String schemeType) {
        this.scheme = "cdo.checkout." + schemeType;
    }

    public final String getScheme() {
        return this.scheme;
    }

    public boolean canHandle(URI uri) {
        return this.scheme.equals(uri.scheme());
    }

    public boolean exists(URI uri, Map<?, ?> options) {
        CDOView view = this.getView(uri);
        Object node = null;
        try {
            node = this.getNode(view, uri.path());
        }
        catch (CDOResourceNodeNotFoundException cDOResourceNodeNotFoundException) {
            // empty catch block
        }
        return node != null;
    }

    public Map<String, ?> getAttributes(URI uri, Map<?, ?> options) {
        CDOView view = this.getView(uri);
        Map attributes = CDOURIHandler.getAttributes((CDOView)view, (String)uri.path(), options);
        attributes.remove("readOnly");
        return attributes;
    }

    public InputStream createInputStream(URI uri, Map<?, ?> options) throws IOException {
        CDOView view = this.getView(uri);
        NODE node = this.getNode(view, uri.path());
        return this.createInputStream(node);
    }

    public OutputStream createOutputStream(final URI uri, Map<?, ?> options) throws IOException {
        return new ByteArrayOutputStream(){

            @Override
            public void close() throws IOException {
                super.close();
                byte[] bytes = this.toByteArray();
                CDOCheckout checkout = CDOExplorerURIHandler.this.getCheckout(uri);
                CDOLobStore lobStore = checkout.getView().getSession().options().getLobCache();
                CDOExplorerURIHandler.this.modify(checkout, uri.path(), true, node -> CDOExplorerURIHandler.this.setContents(node, bytes, lobStore));
            }
        };
    }

    public void delete(URI uri, Map<?, ?> options) throws IOException {
        CDOCheckout checkout = this.getCheckout(uri);
        this.modify(checkout, uri.path(), false, node -> node.delete(options));
    }

    protected abstract NODE getNode(CDOView var1, String var2) throws CDOResourceNodeNotFoundException;

    protected abstract NODE getOrCreateNode(CDOTransaction var1, String var2);

    protected abstract InputStream createInputStream(NODE var1) throws IOException;

    protected abstract void setContents(NODE var1, byte[] var2, CDOLobStore var3) throws IOException;

    private CDOCheckout getCheckout(URI uri) {
        String id = uri.authority();
        CDOCheckout checkout = CDOExplorerUtil.getCheckout(id);
        if (checkout == null) {
            throw new CDOException("No checkout exists for " + uri);
        }
        if (!checkout.isOpen()) {
            throw new CDOException("Checkout '" + checkout.getLabel() + "' is not open");
        }
        return checkout;
    }

    private CDOView getView(URI uri) {
        CDOCheckout checkout = this.getCheckout(uri);
        return checkout.getView();
    }

    private void modify(CDOCheckout checkout, String path, boolean createOnDemand, ResourceNodeModifier<NODE> modifier) throws IOException {
        CDOTransaction transaction = null;
        try {
            try {
                transaction = checkout.openTransaction();
                NODE node = createOnDemand ? this.getOrCreateNode(transaction, path) : this.getNode((CDOView)transaction, path);
                modifier.modify(node);
                CDOCommitInfo commitInfo = transaction.commit();
                if (commitInfo != null) {
                    CDOView view = checkout.getView();
                    view.waitForUpdate(commitInfo.getTimeStamp());
                }
            }
            catch (Exception ex) {
                throw IOUtil.ioException((Exception)ex);
            }
        }
        finally {
            IOUtil.closeSilent((Closeable)transaction);
        }
    }

    private static CDOExplorerURIHandler<?> getURIHandler(CDOResourceNode node) {
        if (node instanceof CDOTextResource) {
            return TEXT;
        }
        if (node instanceof CDOBinaryResource) {
            return TEXT;
        }
        return null;
    }

    public static URI createURI(CDOCheckout checkout, CDOResourceNode node) {
        CDOExplorerURIHandler<?> uriHandler = CDOExplorerURIHandler.getURIHandler(node);
        if (uriHandler == null) {
            return null;
        }
        String scheme = uriHandler.getScheme();
        String authority = checkout.getID();
        String[] segments = node.getURI().segments();
        return URI.createHierarchicalURI((String)scheme, (String)authority, null, (String[])segments, null, null);
    }

    private static final class BinaryURIRHandler
    extends CDOExplorerURIHandler<CDOBinaryResource> {
        public BinaryURIRHandler() {
            super("binary");
        }

        @Override
        protected CDOBinaryResource getNode(CDOView view, String path) throws CDOResourceNodeNotFoundException {
            return view.getBinaryResource(path);
        }

        @Override
        protected CDOBinaryResource getOrCreateNode(CDOTransaction transaction, String path) {
            return transaction.getOrCreateBinaryResource(path);
        }

        @Override
        protected InputStream createInputStream(CDOBinaryResource node) throws IOException {
            return node.getContents().getContents();
        }

        @Override
        protected void setContents(CDOBinaryResource node, byte[] bytes, CDOLobStore lobStore) throws IOException {
            CDOBlob blob = new CDOBlob((InputStream)new ByteArrayInputStream(bytes), lobStore);
            node.setContents(blob);
        }
    }

    @FunctionalInterface
    private static interface ResourceNodeModifier<NODE extends CDOResourceNode> {
        public void modify(NODE var1) throws IOException;
    }

    private static final class TextURIHandler
    extends CDOExplorerURIHandler<CDOTextResource> {
        public TextURIHandler() {
            super("text");
        }

        @Override
        protected CDOTextResource getNode(CDOView view, String path) throws CDOResourceNodeNotFoundException {
            return view.getTextResource(path);
        }

        @Override
        protected CDOTextResource getOrCreateNode(CDOTransaction transaction, String path) {
            return transaction.getOrCreateTextResource(path);
        }

        @Override
        protected InputStream createInputStream(CDOTextResource node) throws IOException {
            CDOClob clob = node.getContents();
            if (clob == null) {
                return new InputStream(){

                    @Override
                    public int read() throws IOException {
                        return -1;
                    }
                };
            }
            return new ReaderInputStream(clob.getContents(), node.getEncoding());
        }

        @Override
        protected void setContents(CDOTextResource node, byte[] bytes, CDOLobStore lobStore) throws IOException {
            String encoding = node.getEncoding();
            if (encoding == null) {
                encoding = StandardCharsets.UTF_8.toString();
            }
            CDOClob clob = new CDOClob((Reader)new StringReader(new String(bytes, encoding)), lobStore);
            node.setContents(clob);
        }
    }
}

