/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.internal.util.factory;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionDelta;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IRegistryChangeEvent;
import org.eclipse.core.runtime.IRegistryChangeListener;
import org.eclipse.core.runtime.Platform;
import org.eclipse.net4j.internal.util.bundle.OM;
import org.eclipse.net4j.util.container.IManagedContainer;
import org.eclipse.net4j.util.factory.FactoryDescriptor;
import org.eclipse.net4j.util.factory.IFactory;
import org.eclipse.net4j.util.factory.IFactoryKey;
import org.eclipse.net4j.util.registry.HashMapRegistry;

public class PluginFactoryRegistry
extends HashMapRegistry<IFactoryKey, IFactory> {
    public static final String NAMESPACE = "org.eclipse.net4j.util";
    public static final String EXT_POINT = "factories";
    private final IManagedContainer container;
    private Object extensionRegistryListener;

    public PluginFactoryRegistry(IManagedContainer container) {
        this.container = container;
    }

    @Override
    public IFactory get(Object key) {
        FactoryDescriptor descriptor;
        IFactory factory = (IFactory)super.get(key);
        if (factory instanceof FactoryDescriptor && (factory = (descriptor = (FactoryDescriptor)factory).createFactory()) != null && factory != descriptor) {
            this.put(factory.getKey(), factory);
        }
        return factory;
    }

    public void registerFactory(FactoryDescriptor factory) {
        this.put(factory.getKey(), factory);
    }

    @Override
    protected void doActivate() throws Exception {
        super.doActivate();
        try {
            this.doActivateOSGi();
        }
        catch (Throwable t) {
            OM.LOG.warn(t);
        }
    }

    @Override
    protected void doDeactivate() throws Exception {
        try {
            this.doDeactivateOSGi();
        }
        catch (Throwable t) {
            OM.LOG.warn(t);
        }
        this.clear();
        super.doDeactivate();
    }

    protected final IManagedContainer getManagedContainer() {
        return this.container;
    }

    private void doActivateOSGi() {
        IConfigurationElement[] elements;
        IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
        if (extensionRegistry == null) {
            return;
        }
        IConfigurationElement[] iConfigurationElementArray = elements = extensionRegistry.getConfigurationElementsFor(NAMESPACE, EXT_POINT);
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            this.registerFactory(new FactoryDescriptor(element));
            ++n2;
        }
        IRegistryChangeListener listener = new IRegistryChangeListener(){

            public void registryChanged(IRegistryChangeEvent event) {
                IExtensionDelta[] deltas;
                IExtensionDelta[] iExtensionDeltaArray = deltas = event.getExtensionDeltas(PluginFactoryRegistry.NAMESPACE, PluginFactoryRegistry.EXT_POINT);
                int n = deltas.length;
                int n2 = 0;
                while (n2 < n) {
                    IExtensionDelta delta = iExtensionDeltaArray[n2];
                    OM.LOG.warn("ExtensionDelta not handled: " + delta);
                    ++n2;
                }
            }
        };
        extensionRegistry.addRegistryChangeListener(listener, NAMESPACE);
        this.extensionRegistryListener = listener;
    }

    private void doDeactivateOSGi() {
        IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
        if (extensionRegistry == null) {
            return;
        }
        extensionRegistry.removeRegistryChangeListener((IRegistryChangeListener)this.extensionRegistryListener);
    }
}

