/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.security.internal.ui.util;

import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.emf.cdo.security.internal.ui.util.OneToManyBlock;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IFilter;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.IManagedForm;

public class OneToManyTableBlock
extends OneToManyBlock {
    public OneToManyTableBlock(DataBindingContext context, EditingDomain domain, AdapterFactory adapterFactory, ITableConfiguration tableConfig) {
        super(context, domain, adapterFactory, tableConfig);
    }

    protected ITableConfiguration getConfiguration() {
        return (ITableConfiguration)super.getConfiguration();
    }

    protected boolean isTable() {
        return true;
    }

    protected void configureColumns(final TableViewer viewer, TableColumnLayout layout) {
        super.configureColumns(viewer, layout);
        viewer.getTable().setHeaderVisible(true);
        viewer.getTable().setLinesVisible(true);
        final ITableConfiguration tableConfig = this.getConfiguration();
        String[] columnTitles = tableConfig.getColumnTitles();
        int i = 0;
        while (i < columnTitles.length) {
            TableViewerColumn column = new TableViewerColumn(viewer, 16384);
            column.getColumn().setText(columnTitles[i]);
            layout.setColumnData((Widget)column.getColumn(), (ColumnLayoutData)new ColumnWeightData(tableConfig.getColumnWeight(i), tableConfig.getColumnMinimumSize(i), tableConfig.isColumnResizable(i)));
            final int columnIndex = i++;
            column.setLabelProvider(tableConfig.getLabelProvider(viewer, columnIndex));
            column.setEditingSupport(new EditingSupport((ColumnViewer)viewer){

                protected void setValue(Object element, Object value) {
                    tableConfig.setValue(viewer, element, columnIndex, value);
                }

                protected Object getValue(Object element) {
                    return tableConfig.getValue(viewer, element, columnIndex);
                }

                protected boolean canEdit(Object element) {
                    return tableConfig.canEdit(viewer, element, columnIndex);
                }

                protected CellEditor getCellEditor(Object element) {
                    return tableConfig.getCellEditor(viewer, columnIndex);
                }
            });
        }
    }

    public static interface ITableConfiguration
    extends OneToManyBlock.IOneToManyConfiguration {
        public String[] getColumnTitles();

        public int getColumnWeight(int var1);

        public int getColumnMinimumSize(int var1);

        public boolean isColumnResizable(int var1);

        public CellLabelProvider getLabelProvider(TableViewer var1, int var2);

        public boolean canEdit(TableViewer var1, Object var2, int var3);

        public void setValue(TableViewer var1, Object var2, int var3, Object var4);

        public Object getValue(TableViewer var1, Object var2, int var3);

        public CellEditor getCellEditor(TableViewer var1, int var2);
    }

    public static abstract class TableConfiguration
    extends OneToManyBlock.OneToManyConfiguration
    implements ITableConfiguration {
        public TableConfiguration(IManagedForm managedForm, EReference reference, EClass itemType, IFilter filter) {
            super(managedForm, reference, itemType, filter);
        }

        public TableConfiguration(IManagedForm managedForm, EReference reference, EClass itemType) {
            super(managedForm, reference, itemType);
        }

        public TableConfiguration(IManagedForm managedForm, EReference reference, IFilter filter) {
            super(managedForm, reference, filter);
        }

        public TableConfiguration(IManagedForm managedForm, EReference reference) {
            super(managedForm, reference);
        }
    }
}

