/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.internal.buddies.protocol;

import org.eclipse.net4j.buddies.common.ICollaborationProvider;
import org.eclipse.net4j.buddies.common.ISession;
import org.eclipse.net4j.buddies.internal.common.protocol.MessageIndication;
import org.eclipse.net4j.connector.IConnector;
import org.eclipse.net4j.internal.buddies.ClientSession;
import org.eclipse.net4j.internal.buddies.Self;
import org.eclipse.net4j.internal.buddies.protocol.BuddyAddedIndication;
import org.eclipse.net4j.internal.buddies.protocol.BuddyRemovedIndication;
import org.eclipse.net4j.internal.buddies.protocol.ClientBuddyStateIndication;
import org.eclipse.net4j.internal.buddies.protocol.ClientCollaborationLeftIndication;
import org.eclipse.net4j.internal.buddies.protocol.CollaborationInitiatedIndication;
import org.eclipse.net4j.internal.buddies.protocol.FacilityInstalledIndication;
import org.eclipse.net4j.signal.SignalProtocol;
import org.eclipse.net4j.signal.SignalReactor;
import org.eclipse.net4j.util.concurrent.ConcurrencyUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuddiesClientProtocol
extends SignalProtocol<ClientSession> {
    private static final long GET_SESSION_TIMEOUT = 20000L;
    private static final int GET_SESSION_INTERVAL = 100;

    public BuddiesClientProtocol(IConnector connector) {
        super("buddies");
        this.open(connector);
    }

    protected SignalReactor createSignalReactor(short signalID) {
        switch (signalID) {
            case 3: {
                return new BuddyAddedIndication(this);
            }
            case 4: {
                return new BuddyRemovedIndication(this);
            }
            case 5: {
                return new ClientBuddyStateIndication(this);
            }
            case 7: {
                return new CollaborationInitiatedIndication(this);
            }
            case 8: {
                return new ClientCollaborationLeftIndication(this, this.getSelf());
            }
            case 12: {
                return new FacilityInstalledIndication(this);
            }
            case 13: {
                return new MessageIndication((SignalProtocol)this, (ICollaborationProvider)this.getSelf());
            }
        }
        return super.createSignalReactor(signalID);
    }

    protected Self getSelf() {
        ISession session = (ISession)this.getInfraStructure();
        return (Self)session.getSelf();
    }

    public ClientSession getSession() {
        int max = 200;
        int i = 0;
        while (i < max) {
            ClientSession session = (ClientSession)this.getInfraStructure();
            if (session != null) {
                return session;
            }
            ConcurrencyUtil.sleep((long)100L);
            ++i;
        }
        throw new IllegalStateException("No session after " + max + " milliseconds");
    }
}

