/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.trace;

import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.internal.net4j.buffer.Buffer;
import org.eclipse.net4j.buffer.BufferState;
import org.eclipse.net4j.buffer.IBuffer;
import org.eclipse.net4j.internal.trace.BufferTracer;
import org.eclipse.net4j.internal.trace.ElementCounters;

public class Element {
    private static final Map<Object, Element> ELEMENTS = new WeakHashMap<Object, Element>();
    private final int id;
    private final String type;

    protected Element(int id, String type) {
        this.type = type;
        this.id = id;
    }

    public Element(String type) {
        this(ElementCounters.INSTANCE.nextID(type), type);
    }

    public final int id() {
        return this.id;
    }

    public final String type() {
        return this.type;
    }

    public String toString() {
        return String.valueOf(this.type) + "[" + this.id + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Element getOrNull(Object object) {
        Map<Object, Element> map = ELEMENTS;
        synchronized (map) {
            return ELEMENTS.get(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Element get(Object object) {
        Element element;
        boolean created = false;
        Map<Object, Element> map = ELEMENTS;
        synchronized (map) {
            element = ELEMENTS.get(object);
            if (element == null) {
                if (object instanceof Buffer) {
                    Buffer buffer = (Buffer)object;
                    element = new BufferElement(buffer.getID());
                    created = true;
                } else if (object instanceof Thread) {
                    Thread thread = (Thread)object;
                    element = new ThreadElement(thread.getName());
                } else {
                    element = new Element(object.getClass().getSimpleName());
                    created = true;
                }
                ELEMENTS.put(object, element);
            }
        }
        if (created && BufferTracer.LISTENER != null) {
            BufferTracer.LISTENER.elementCreated(element);
        }
        return element;
    }

    public static BufferElement get(IBuffer buffer) {
        return (BufferElement)Element.get((Object)buffer);
    }

    public static ThreadElement get(Thread thread) {
        return (ThreadElement)Element.get((Object)thread);
    }

    public static final class BufferElement
    extends Element {
        public static final String TYPE = "Buffer";
        private Element provider;
        private Element owner;
        private Element thread;
        private BufferState state;
        private int position;
        private int limit;
        private boolean eos;
        private boolean ccam;

        public BufferElement(int id) {
            super(id, TYPE);
        }

        public Element getProvider() {
            return this.provider;
        }

        public void setProvider(Object object) {
            this.provider = BufferElement.get(object);
        }

        public Element getOwner() {
            return this.owner;
        }

        public void setOwner(Object object) {
            this.updateThread();
            Element newOwner = BufferElement.get(object);
            if (this.owner != newOwner && newOwner.getClass() != BufferElement.class) {
                Element oldOwner = this.owner;
                this.owner = newOwner;
                BufferTracer.LISTENER.ownerChanged(this, oldOwner, newOwner);
            }
        }

        public Element getThread() {
            return this.thread;
        }

        public BufferState getState() {
            return this.state;
        }

        public int getPosition() {
            return this.position;
        }

        public int getLimit() {
            return this.limit;
        }

        public boolean isEOS() {
            return this.eos;
        }

        public boolean isCCAM() {
            return this.ccam;
        }

        public void update(BufferState newState, int newPosition, int newLimit, boolean newEOS, boolean newCCAM) {
            this.updateThread();
            if (this.state != newState) {
                BufferState oldState = this.state;
                this.state = newState;
                BufferTracer.LISTENER.stateChanged(this, oldState, newState);
            }
            if (this.position != newPosition) {
                int oldPosition = this.position;
                this.position = newPosition;
                BufferTracer.LISTENER.positionChanged(this, oldPosition, newPosition);
            }
            if (this.limit != newLimit) {
                int oldLimit = this.limit;
                this.limit = newLimit;
                BufferTracer.LISTENER.limitChanged(this, oldLimit, newLimit);
            }
            if (this.eos != newEOS) {
                this.eos = newEOS;
                BufferTracer.LISTENER.eosChanged(this, newEOS);
            }
            if (this.ccam != newCCAM) {
                this.ccam = newCCAM;
                BufferTracer.LISTENER.ccamChanged(this, newCCAM);
            }
        }

        private void updateThread() {
            ThreadElement newThread;
            ThreadElement threadElement = newThread = this.state == BufferState.RELEASED ? null : BufferElement.get(Thread.currentThread());
            if (this.thread != newThread) {
                Element oldThread = this.thread;
                this.thread = newThread;
                BufferTracer.LISTENER.threadChanged(this, oldThread, newThread);
            }
        }
    }

    public static final class ThreadElement
    extends Element {
        public static final String TYPE = "Thread";
        private String name;

        public ThreadElement(String name) {
            super(TYPE);
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String toString() {
            return String.valueOf(this.type()) + "[" + this.id() + ", " + this.name + "]";
        }
    }
}

