/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.buddies.chat.internal.ui;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.net4j.buddies.chat.IChat;
import org.eclipse.net4j.buddies.chat.IComment;
import org.eclipse.net4j.buddies.chat.internal.ui.messages.Messages;
import org.eclipse.net4j.buddies.internal.chat.CommentEvent;
import org.eclipse.net4j.buddies.internal.ui.views.CollaborationsPane;
import org.eclipse.net4j.buddies.internal.ui.views.FacilityPane;
import org.eclipse.net4j.ui.shared.SharedIcons;
import org.eclipse.net4j.util.StringUtil;
import org.eclipse.net4j.util.event.IEvent;
import org.eclipse.net4j.util.ui.actions.SafeAction;
import org.eclipse.net4j.util.ui.widgets.SashComposite;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

public class ChatPane
extends FacilityPane {
    private SashComposite sashComposite;
    private Text input;
    private Text output;

    public ChatPane(CollaborationsPane collaborationsPane, int style) {
        super(collaborationsPane, style);
    }

    protected void handleEvent(IEvent event) throws Exception {
        if (event instanceof CommentEvent) {
            CommentEvent e = (CommentEvent)event;
            IComment comment = e.getComment();
            String text = comment.getText();
            this.output.append(String.valueOf(comment.getSenderID()) + ": " + text + StringUtil.NL);
        }
    }

    protected Control createUI(Composite parent) {
        this.sashComposite = new SashComposite(parent, 0, 16, 80){

            protected Control createControl1(Composite parent) {
                ChatPane.this.output = new Text(parent, 2);
                return ChatPane.this.output;
            }

            protected Control createControl2(Composite parent) {
                ChatPane.this.input = new Text(parent, 2);
                ChatPane.this.input.addKeyListener((KeyListener)new KeyAdapter(){

                    public void keyPressed(KeyEvent e) {
                        if ((e.character == '\r' || e.character == '\n') && e.stateMask == 0) {
                            ((IChat)ChatPane.this.getFacility()).sendComment(ChatPane.this.input.getText());
                            ChatPane.this.input.setText("");
                            e.doit = false;
                        }
                    }
                });
                return ChatPane.this.input;
            }
        };
        this.sashComposite.setVertical(true);
        return this.sashComposite;
    }

    protected void fillCoolBar(IContributionManager manager) {
        manager.add((IAction)new SafeAction(Messages.getString("ChatPane.2"), Messages.getString("ChatPane.3"), SharedIcons.getDescriptor((String)"etool16/vertical_layout")){

            protected void safeRun() throws Exception {
                ChatPane.this.sashComposite.setVertical(true);
            }
        });
        manager.add((IAction)new SafeAction(Messages.getString("ChatPane.4"), Messages.getString("ChatPane.5"), SharedIcons.getDescriptor((String)"etool16/horizontal_layout")){

            protected void safeRun() throws Exception {
                ChatPane.this.sashComposite.setVertical(false);
            }
        });
    }
}

