/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.common.revision;

import java.util.Collection;
import org.eclipse.emf.cdo.common.model.CDOModelUtil;
import org.eclipse.emf.cdo.common.model.CDOType;
import org.eclipse.emf.cdo.common.revision.CDOList;
import org.eclipse.emf.cdo.common.revision.CDOListFactory;
import org.eclipse.emf.cdo.spi.common.revision.CDOReferenceAdjuster;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDOList;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EStructuralFeature;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CDOListImpl
extends BasicEList<Object>
implements InternalCDOList.ConfigurableEquality {
    public static final CDOListFactory FACTORY = new CDOListFactory(){

        public CDOList createList(int initialCapacity, int size, int initialChunk) {
            return new CDOListImpl(initialCapacity, size);
        }
    };
    private static final byte FROZEN_FLAG = 1;
    private static final byte USE_EQUALS_FLAG = 2;
    private static final long serialVersionUID = 1L;
    private transient byte flags = (byte)2;

    public CDOListImpl(int initialCapacity, int size) {
        super(initialCapacity);
        int j = 0;
        while (j < size) {
            this.add(UNINITIALIZED);
            ++j;
        }
    }

    @Override
    public InternalCDOList clone(EClassifier classifier) {
        CDOType type = CDOModelUtil.getType(classifier);
        int size = this.size();
        CDOListImpl list = new CDOListImpl(size, 0);
        list.setUseEquals(this.useEquals());
        int j = 0;
        while (j < size) {
            Object value = this.get(j);
            list.add(j, type.copyValue(value));
            ++j;
        }
        return list;
    }

    @Override
    public Object get(int index, boolean resolve) {
        return super.get(index);
    }

    @Override
    public boolean adjustReferences(CDOReferenceAdjuster revisionAdjuster, EStructuralFeature feature) {
        boolean changed = false;
        CDOType type = CDOModelUtil.getType(feature);
        int size = this.size();
        int i = 0;
        while (i < size) {
            Object element = super.get(i);
            this.handleAdjustReference(i, element);
            Object newID = type.adjustReferences(revisionAdjuster, element, feature, i);
            if (newID != element) {
                super.set(i, newID);
                changed = true;
            }
            ++i;
        }
        return changed;
    }

    protected void handleAdjustReference(int index, Object element) {
    }

    @Override
    public void freeze() {
        this.flags = (byte)(this.flags | 1);
    }

    private void checkFrozen() {
        if ((this.flags & 1) != 0) {
            throw new IllegalStateException("Cannot modify a frozen list");
        }
    }

    public boolean add(Object o) {
        this.checkFrozen();
        return super.add(o);
    }

    public boolean remove(Object o) {
        this.checkFrozen();
        return super.remove(o);
    }

    public boolean addAll(Collection<? extends Object> c) {
        this.checkFrozen();
        return super.addAll(c);
    }

    public boolean addAll(int index, Collection<? extends Object> c) {
        this.checkFrozen();
        return super.addAll(index, c);
    }

    public boolean removeAll(Collection<?> c) {
        this.checkFrozen();
        return super.removeAll(c);
    }

    public boolean retainAll(Collection<?> c) {
        this.checkFrozen();
        return super.retainAll(c);
    }

    public void clear() {
        this.checkFrozen();
        super.clear();
    }

    public Object set(int index, Object element) {
        this.checkFrozen();
        return super.set(index, element);
    }

    public void add(int index, Object element) {
        this.checkFrozen();
        super.add(index, element);
    }

    public Object remove(int index) {
        this.checkFrozen();
        return super.remove(index);
    }

    @Override
    public void setWithoutFrozenCheck(int index, Object element) {
        super.set(index, element);
    }

    public final boolean useEquals() {
        return (this.flags & 2) != 0;
    }

    @Override
    public final void setUseEquals(boolean useEquals) {
        this.flags = useEquals ? (byte)(this.flags | 2) : (byte)(this.flags & 0xFFFFFFFD);
    }

    public static class IndexOutOfBoundsException
    extends BasicEList.BasicIndexOutOfBoundsException {
        private static final long serialVersionUID = 1L;

        public IndexOutOfBoundsException(int index, int size) {
            super(index, size);
        }
    }
}

