/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.internal.tcp.ssl;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.channels.SocketChannel;
import java.text.MessageFormat;
import org.eclipse.net4j.ILocationAware;
import org.eclipse.net4j.internal.tcp.bundle.OM;
import org.eclipse.net4j.internal.tcp.ssl.SSLConnector;
import org.eclipse.net4j.tcp.ITCPSelector;

public class SSLClientConnector
extends SSLConnector {
    public SSLClientConnector() {
        try {
            SocketChannel socketChannel = SocketChannel.open();
            socketChannel.socket().setReuseAddress(true);
            socketChannel.configureBlocking(false);
            this.setSocketChannel(socketChannel);
        }
        catch (IOException ex) {
            OM.LOG.error((Throwable)ex);
        }
    }

    public ILocationAware.Location getLocation() {
        return ILocationAware.Location.CLIENT;
    }

    public String toString() {
        if (this.getUserID() == null) {
            return MessageFormat.format("SSLClientConnector[{0}:{1}]", this.getHost(), this.getPort());
        }
        return MessageFormat.format("SSLClientConnector[{2}@{0}:{1}]", this.getHost(), this.getPort(), this.getUserID());
    }

    protected void doBeforeActivate() throws Exception {
        super.doBeforeActivate();
        if (this.getHost() == null) {
            throw new IllegalStateException("host == null");
        }
        if (this.getPort() == 0) {
            throw new IllegalStateException("port == 0");
        }
    }

    public void handleRegistration(ITCPSelector selector, SocketChannel socketChannel) {
        super.handleRegistration(selector, socketChannel);
        try {
            InetAddress addr = InetAddress.getByName(this.getHost());
            InetSocketAddress sAddr = new InetSocketAddress(addr, this.getPort());
            this.getSocketChannel().connect(sAddr);
        }
        catch (Exception ex) {
            OM.LOG.error((Throwable)ex);
            this.deactivateAsync();
        }
    }
}

