/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.spi.server;

import java.util.Dictionary;
import org.eclipse.emf.cdo.internal.server.bundle.CDOServerApplication;
import org.eclipse.emf.cdo.server.IStoreAccessor;
import org.eclipse.emf.cdo.server.StoreThreadLocal;
import org.eclipse.emf.cdo.spi.server.InternalRepository;
import org.eclipse.net4j.util.container.IManagedContainer;
import org.eclipse.net4j.util.factory.Factory;
import org.eclipse.net4j.util.factory.ProductCreationException;
import org.eclipse.osgi.framework.console.CommandInterpreter;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CDOCommand
extends Factory {
    public static final String PRODUCT_GROUP = "org.eclipse.emf.cdo.server.commands";
    public static final String INDENT = "   ";
    private static final CommandParameter[] NO_PARAMETERS = new CommandParameter[0];
    private final String description;
    private final CommandParameter[] parameters;
    private CommandInterpreter interpreter;
    private long start;

    public CDOCommand(String name, String description, CommandParameter ... parameters) {
        super(PRODUCT_GROUP, name);
        this.description = description;
        this.parameters = parameters == null ? NO_PARAMETERS : parameters;
    }

    public CDOCommand(String name, String description) {
        this(name, description, NO_PARAMETERS);
    }

    public final CDOCommand create(String description) throws ProductCreationException {
        return this;
    }

    public final CommandInterpreter getInterpreter() {
        return this.interpreter;
    }

    public final void setInterpreter(CommandInterpreter interpreter) {
        this.interpreter = interpreter;
    }

    public final String getName() {
        return this.getType();
    }

    public final String getDescription() {
        return this.description;
    }

    public final CommandParameter[] getParameters() {
        return this.parameters;
    }

    public final String getSyntax() {
        StringBuilder builder = new StringBuilder();
        builder.append("cdo ");
        builder.append(this.getName());
        CommandParameter[] commandParameterArray = this.parameters;
        int n = this.parameters.length;
        int n2 = 0;
        while (n2 < n) {
            CommandParameter parameter = commandParameterArray[n2];
            builder.append(" ");
            if (parameter.isOptional()) {
                builder.append("[");
            }
            if (!parameter.isLiteral()) {
                builder.append("<");
            }
            builder.append(parameter.getName());
            if (!parameter.isLiteral()) {
                builder.append(">");
            }
            if (parameter.isOptional()) {
                builder.append("]");
            }
            ++n2;
        }
        return builder.toString();
    }

    public final Object executeCommand(String cmd) {
        return this.interpreter.execute(cmd);
    }

    public final void print(Object o) {
        this.interpreter.print(o);
    }

    public final void println() {
        this.interpreter.println();
    }

    public final void println(Object o) {
        this.interpreter.println(o);
    }

    public final void printStackTrace(Throwable t) {
        this.interpreter.printStackTrace(t);
    }

    public final void printDictionary(Dictionary<?, ?> dic, String title) {
        this.interpreter.printDictionary(dic, title);
    }

    public final void printBundleResource(Bundle bundle, String resource) {
        this.interpreter.printBundleResource(bundle, resource);
    }

    public final void execute() throws Exception {
        int length = this.parameters.length;
        String[] args = new String[length];
        int i = 0;
        while (i < this.parameters.length) {
            CommandParameter parameter = this.parameters[i];
            String arg = parameter.isOptional() ? this.nextArgumentOptional() : this.nextArgument();
            args[i] = arg;
            ++i;
        }
        this.start = System.currentTimeMillis();
        this.execute(args);
    }

    protected final String duration() {
        long millis = System.currentTimeMillis() - this.start;
        if (millis < 1000L) {
            return String.valueOf(millis) + " millis";
        }
        long duration = millis / 1000L;
        long s = duration % 60L;
        long m = duration / 60L % 60L;
        long h = duration / 3600L % 24L;
        return String.format("%d:%02d:%02d", h, m, s);
    }

    public abstract void execute(String[] var1) throws Exception;

    private String nextArgument() {
        String argument = this.interpreter.nextArgument();
        if (argument == null && this.parameters != null) {
            throw new CommandException("Syntax: " + this.getSyntax());
        }
        return argument;
    }

    private String nextArgumentOptional() {
        return this.interpreter.nextArgument();
    }

    public static CommandParameter[] parameters(CommandParameter parameter, CommandParameter[] parameters) {
        if (parameters == null || parameters.length == 0) {
            return new CommandParameter[]{parameter};
        }
        CommandParameter[] result = new CommandParameter[1 + parameters.length];
        result[0] = parameter;
        System.arraycopy(parameters, 0, result, 1, parameters.length);
        return result;
    }

    public static CommandParameter parameter(String name, boolean optional) {
        return new CommandParameter(name, optional);
    }

    public static CommandParameter parameter(String name) {
        return CDOCommand.parameter(name, false);
    }

    public static CommandParameter optional(String name) {
        return CDOCommand.parameter(name, true);
    }

    protected static String[] trimFirstArgument(String[] args) {
        int length = args.length - 1;
        String[] result = new String[length];
        System.arraycopy(args, 1, result, 0, length);
        return result;
    }

    public static final class CommandException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public CommandException(String message) {
            super(message);
        }
    }

    public static final class CommandParameter {
        private final String name;
        private final boolean optional;
        private final boolean literal;

        public CommandParameter(String name, boolean optional) {
            this(name, optional, false);
        }

        private CommandParameter(String name, boolean optional, boolean literal) {
            this.name = name;
            this.optional = optional;
            this.literal = literal;
        }

        public String getName() {
            return this.name;
        }

        public boolean isOptional() {
            return this.optional;
        }

        public boolean isLiteral() {
            return this.literal;
        }

        public CommandParameter literal() {
            return new CommandParameter(this.name, this.optional, true);
        }
    }

    public static abstract class WithAccessor
    extends WithRepository {
        public WithAccessor(String name, String description, CommandParameter ... parameters) {
            super(name, description, parameters);
        }

        public WithAccessor(String name, String description) {
            this(name, description, NO_PARAMETERS);
        }

        public final void execute(InternalRepository repository, String[] args) throws Exception {
            IStoreAccessor accessor = repository.getStore().getReader(null);
            StoreThreadLocal.setAccessor(accessor);
            try {
                this.execute(repository, accessor, args);
            }
            finally {
                StoreThreadLocal.release();
            }
        }

        public abstract void execute(InternalRepository var1, IStoreAccessor var2, String[] var3) throws Exception;
    }

    public static abstract class WithRepository
    extends CDOCommand {
        public WithRepository(String name, String description, CommandParameter ... parameters) {
            super(name, description, WithRepository.parameters(WithRepository.parameter("repository-name"), parameters));
        }

        public WithRepository(String name, String description) {
            this(name, description, NO_PARAMETERS);
        }

        public final void execute(String[] args) throws Exception {
            String repositoryName = args[0];
            InternalRepository repository = this.getRepository(repositoryName);
            if (repository == null) {
                throw new CommandException("Repository not found: " + repositoryName);
            }
            this.execute(repository, WithRepository.trimFirstArgument(args));
        }

        public abstract void execute(InternalRepository var1, String[] var2) throws Exception;

        private InternalRepository getRepository(String name) {
            IManagedContainer container = CDOServerApplication.getContainer();
            Object[] objectArray = container.getElements("org.eclipse.emf.cdo.server.repositories");
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                InternalRepository repository;
                Object element = objectArray[n2];
                if (element instanceof InternalRepository && (repository = (InternalRepository)element).getName().equals(name)) {
                    return repository;
                }
                ++n2;
            }
            return null;
        }
    }
}

