/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.tests;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.net4j.util.WrappedException;
import org.eclipse.net4j.util.event.IEvent;
import org.eclipse.net4j.util.event.IListener;
import org.junit.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestListener2
implements IListener {
    public static final int NO_TIME_STAMP = 0;
    private static final Set<Class<? extends IEvent>> NO_EVENT_CLASSES = Collections.emptySet();
    private static final long DEFAULT_TIMEOUT = 3000L;
    private final Map<IEvent, Long> events = new LinkedHashMap<IEvent, Long>();
    private final Collection<Class<? extends IEvent>> eventClasses;
    private long timeout;
    private String name;

    public TestListener2(Collection<Class<? extends IEvent>> eventClasses) {
        this(eventClasses, null);
    }

    public TestListener2(Class<? extends IEvent> eventClass) {
        this(TestListener2.singleton(eventClass));
    }

    public TestListener2(Collection<Class<? extends IEvent>> eventClasses, String name) {
        this.eventClasses = eventClasses != null ? eventClasses : NO_EVENT_CLASSES;
        this.name = name;
        this.timeout = 3000L;
    }

    public TestListener2(Class<? extends IEvent> eventClass, String name) {
        this(TestListener2.singleton(eventClass), name);
    }

    public boolean isApplicable(IEvent event) {
        if (this.eventClasses.isEmpty()) {
            return true;
        }
        Class<?> theClass = event.getClass();
        for (Class<? extends IEvent> eventClass : this.eventClasses) {
            if (!eventClass.isAssignableFrom(theClass)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyEvent(IEvent event) {
        if (this.isApplicable(event)) {
            long timeStamp = System.currentTimeMillis();
            if (timeStamp == 0L) {
                throw new IllegalStateException("Regular time stamp is equal to NO_TIME_STAMP");
            }
            TestListener2 testListener2 = this;
            synchronized (testListener2) {
                this.events.put(event, timeStamp);
                this.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<IEvent> getEvents() {
        TestListener2 testListener2 = this;
        synchronized (testListener2) {
            return new ArrayList<IEvent>(this.events.keySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getTimeStamp(IEvent event) {
        Long timeStamp;
        TestListener2 testListener2 = this;
        synchronized (testListener2) {
            timeStamp = this.events.get(event);
        }
        if (timeStamp == null) {
            return 0L;
        }
        return timeStamp;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void waitFor(int n, long timeout) {
        long t = 0L;
        TestListener2 testListener2 = this;
        synchronized (testListener2) {
            while (this.events.size() < n) {
                if (timeout <= 0L) {
                    Assert.fail((String)"Timed out");
                }
                try {
                    t = System.currentTimeMillis();
                    this.wait(timeout);
                }
                catch (InterruptedException ex) {
                    throw WrappedException.wrap((Exception)ex);
                }
                timeout -= System.currentTimeMillis() - t;
            }
        }
    }

    public void waitFor(int i) {
        this.waitFor(i, this.timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearEvents() {
        TestListener2 testListener2 = this;
        synchronized (testListener2) {
            this.events.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String formatEvents(String prefix, String suffix) {
        StringBuilder builder = new StringBuilder();
        TestListener2 testListener2 = this;
        synchronized (testListener2) {
            for (Map.Entry<IEvent, Long> entry : this.events.entrySet()) {
                builder.append(String.valueOf(prefix) + entry.getValue() + ": " + entry.getKey() + suffix);
            }
        }
        return builder.toString();
    }

    public void dump(PrintStream out) {
        out.println(this);
        out.print(this.formatEvents("  ", "\n"));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(TestListener2.class.getSimpleName());
        builder.append('[');
        if (this.name != null) {
            builder.append("name=\"");
            builder.append(this.name);
            builder.append('\"');
        }
        if (!this.eventClasses.isEmpty()) {
            if (this.name != null) {
                builder.append(", ");
            }
            builder.append("eventClasses=[");
            boolean first = true;
            for (Class<? extends IEvent> eventClass : this.eventClasses) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append(eventClass.getSimpleName());
            }
            builder.append(']');
        }
        builder.append(']');
        return builder.toString();
    }

    private static Set<Class<? extends IEvent>> singleton(Class<? extends IEvent> eventClass) {
        HashSet<Class<? extends IEvent>> singleton = new HashSet<Class<? extends IEvent>>();
        singleton.add(eventClass);
        return singleton;
    }
}

