/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.tests.cache;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.net4j.util.cache.Cache;
import org.eclipse.net4j.util.tests.cache.Revision;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RevisionManager
extends Cache<Revision> {
    private Map<Integer, TimeLine> timeLines = new HashMap<Integer, TimeLine>();

    public Revision getRevision(int id, int version) {
        TimeLine timeLine = this.getTimeLine(id);
        return timeLine.getRevision(version);
    }

    public void evictElements(int elementCount) {
    }

    protected TimeLine getTimeLine(int id) {
        TimeLine timeLine = this.timeLines.get(id);
        if (timeLine == null) {
            timeLine = new TimeLine(id);
            this.timeLines.put(id, timeLine);
        }
        return timeLine;
    }

    protected Revision loadRevision(int id, int version) {
        Revision revision = new Revision(this, id, version);
        return revision;
    }

    protected void finalizeRevision(Revision revision) {
    }

    protected void unreachableElement(Reference<? extends Revision> reference) {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class CacheElement
    extends SoftReference<Revision> {
        private int id;
        private int version;

        public CacheElement(Revision revision, ReferenceQueue<Revision> queue) {
            super(revision, queue);
            this.id = revision.getID();
            this.version = revision.getVersion();
        }

        public String toString() {
            return "R" + this.id + "v" + this.version + (this.get() == null ? "" : " UNCLEARED");
        }
    }

    private class TimeLine {
        private int id;
        private List<Reference<Revision>> revisions = new ArrayList<Reference<Revision>>();

        public TimeLine(int id) {
            this.id = id;
        }

        public Revision getRevision(int version) {
            Revision revision;
            Iterator<Reference<Revision>> it = this.revisions.iterator();
            while (it.hasNext()) {
                Reference<Revision> reference = it.next();
                revision = reference.get();
                if (revision != null) {
                    if (revision.getVersion() != version) continue;
                    return revision;
                }
                it.remove();
                break;
            }
            long time = System.currentTimeMillis();
            revision = RevisionManager.this.loadRevision(this.id, version);
            time = System.currentTimeMillis() - time;
            this.addRevision(revision);
            return revision;
        }

        public void addRevision(Revision revision) {
            this.revisions.add(new CacheElement(revision, RevisionManager.this.getReferenceQueue()));
        }
    }
}

