/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.tests;

import java.io.IOException;
import java.rmi.AlreadyBoundException;
import org.eclipse.net4j.signal.RemoteException;
import org.eclipse.net4j.tests.AbstractProtocolTest;
import org.eclipse.net4j.tests.signal.ExceptionRequest;
import org.eclipse.net4j.tests.signal.TestSignalProtocol;
import org.eclipse.net4j.util.io.IOUtil;

public class ExceptionTest
extends AbstractProtocolTest {
    public void testExceptionInIRequesting() throws Exception {
        this.exceptionInPhase(1, false);
    }

    public void testExceptionInIndicating() throws Exception {
        this.exceptionInPhase(2, false);
    }

    public void testExceptionInResponding() throws Exception {
        this.exceptionInPhase(3, false);
    }

    public void testExceptionInConfirming() throws Exception {
        this.exceptionInPhase(4, false);
    }

    public void testIOExceptionInIRequesting() throws Exception {
        this.exceptionInPhase(1, true);
    }

    public void testIOExceptionInIndicating() throws Exception {
        this.exceptionInPhase(2, true);
    }

    public void testIOExceptionInResponding() throws Exception {
        this.exceptionInPhase(3, true);
    }

    public void testIOExceptionInConfirming() throws Exception {
        this.exceptionInPhase(4, true);
    }

    private void exceptionInPhase(int phase, boolean ioProblem) throws Exception {
        this.startTransport();
        TestSignalProtocol protocol = new TestSignalProtocol(this.getConnector());
        try {
            new ExceptionRequest(protocol, phase, ioProblem).send();
            ExceptionTest.fail((String)"Exception expected");
        }
        catch (Exception ex) {
            IOUtil.print((Throwable)ex);
            if (ioProblem) {
                IOException ioe = null;
                if (phase == 2 || phase == 3) {
                    if (ex instanceof RemoteException) {
                        ExceptionTest.assertEquals((boolean)((RemoteException)ex).whileResponding(), (phase == 3 ? 1 : 0) != 0);
                        ioe = (IOException)ex.getCause();
                    } else {
                        ExceptionTest.fail((String)"RemoteException expected");
                    }
                } else {
                    ioe = (IOException)ex;
                }
                ExceptionTest.assertEquals((String)"Simulated exception", (String)ioe.getMessage());
            }
            ClassNotFoundException cnfe = null;
            if (phase == 2 || phase == 3) {
                if (ex instanceof RemoteException) {
                    ExceptionTest.assertEquals((boolean)((RemoteException)ex).whileResponding(), (phase == 3 ? 1 : 0) != 0);
                    cnfe = (ClassNotFoundException)ex.getCause();
                } else {
                    ExceptionTest.fail((String)"RemoteException expected");
                }
            } else {
                cnfe = (ClassNotFoundException)ex;
            }
            AlreadyBoundException abe = (AlreadyBoundException)cnfe.getCause();
            ExceptionTest.assertEquals((String)"Simulated exception", (String)abe.getMessage());
        }
    }

    public static final class SSL
    extends ExceptionTest {
        protected boolean useJVMTransport() {
            return false;
        }

        protected boolean useSSLTransport() {
            return true;
        }
    }

    public static final class TCP
    extends ExceptionTest {
        protected boolean useJVMTransport() {
            return false;
        }

        protected boolean useSSLTransport() {
            return false;
        }
    }
}

