/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.ast.parser;

import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.m2m.internal.qvt.oml.ast.env.IVirtualOperationTable;
import org.eclipse.m2m.internal.qvt.oml.ast.env.VirtualTable;
import org.eclipse.m2m.internal.qvt.oml.ast.env.VirtualTableAdapter;
import org.eclipse.m2m.internal.qvt.oml.ast.parser.IntermediateClassFactory;
import org.eclipse.m2m.internal.qvt.oml.evaluator.ModuleInstanceFactory;
import org.eclipse.m2m.internal.qvt.oml.expressions.Module;
import org.eclipse.ocl.ecore.OperationCallExp;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExecutableXMIHelper {
    private static final String SOURCE_URI_BASE = "http://www.eclipse.org/m2m/1.0.0/QVT";
    private static final String VIRTUAL_TABLE_SOURCE = "http://www.eclipse.org/m2m/1.0.0/QVT/VTable";
    private static final String STATIC_SOURCE = "http://www.eclipse.org/m2m/1.0.0/QVT/static";
    private static final String OPERATION_CALL_SOURCE = "http://www.eclipse.org/m2m/1.0.0/QVT/opCall";
    private static final String OPERATION_CALL_DETAILS_OPCODE = "opCode";

    public static void fixResourceOnLoad(Resource resource) {
        ExecutableXMIHelper.fixOnLoad((TreeIterator<EObject>)resource.getAllContents());
    }

    public static void fixEObjectOnLoad(EObject eObj) {
        ExecutableXMIHelper.restoreEObjectOnLoad(eObj);
        ExecutableXMIHelper.fixOnLoad((TreeIterator<EObject>)eObj.eAllContents());
    }

    private static void fixOnLoad(TreeIterator<EObject> it) {
        while (it.hasNext()) {
            EObject nextObj = (EObject)it.next();
            ExecutableXMIHelper.restoreEObjectOnLoad(nextObj);
        }
    }

    private static void restoreEObjectOnLoad(EObject eObj) {
        if (eObj instanceof Module) {
            Module module = (Module)eObj;
            if (!(module.getEFactoryInstance() instanceof ModuleInstanceFactory)) {
                module.setEFactoryInstance((EFactory)new ModuleInstanceFactory());
            }
        } else if (eObj instanceof EOperation) {
            ExecutableXMIHelper.loadVTOperFromAnnotation((EOperation)eObj);
        } else if (eObj instanceof EPackage) {
            EPackage ePackage = (EPackage)eObj;
            if (IntermediateClassFactory.isIntermediatePackage(ePackage) && !(ePackage.getEFactoryInstance() instanceof IntermediateClassFactory)) {
                new IntermediateClassFactory(ePackage);
            }
        } else if (eObj instanceof EStructuralFeature) {
            ExecutableXMIHelper.loadStaticFeatureFromAnnotation((EStructuralFeature)eObj);
        } else if (eObj instanceof OperationCallExp) {
            ExecutableXMIHelper.loadOperationCallDetails((OperationCallExp)eObj);
        }
    }

    public static void fixResourceOnSave(Resource rc) {
        ExecutableXMIHelper.fixOnSave((TreeIterator<EObject>)rc.getAllContents());
    }

    public static void fixEObjectOnSave(EObject eObj) {
        ExecutableXMIHelper.prepareEObjectToSave(eObj);
        ExecutableXMIHelper.fixOnSave((TreeIterator<EObject>)eObj.eAllContents());
    }

    private static void fixOnSave(TreeIterator<EObject> it) {
        while (it.hasNext()) {
            EObject nextObj = (EObject)it.next();
            ExecutableXMIHelper.prepareEObjectToSave(nextObj);
        }
    }

    private static void prepareEObjectToSave(EObject eObj) {
        if (eObj instanceof EOperation) {
            ExecutableXMIHelper.saveVTOperTable2Annotation((EOperation)eObj);
        } else if (eObj instanceof EStructuralFeature) {
            ExecutableXMIHelper.saveStaticFeature((EStructuralFeature)eObj);
        } else if (eObj instanceof OperationCallExp) {
            ExecutableXMIHelper.saveOperationCallDetails((OperationCallExp)eObj);
        }
    }

    private static void loadVTOperFromAnnotation(EOperation operation) {
        EAnnotation annotation = operation.getEAnnotation(VIRTUAL_TABLE_SOURCE);
        if (annotation != null) {
            VirtualTable vt = VirtualTableAdapter.getAdapter(operation, true).getVirtualTable();
            for (EObject next : annotation.getReferences()) {
                if (!(next instanceof EOperation)) continue;
                vt.addOperation((EOperation)next);
            }
        }
    }

    private static void saveVTOperTable2Annotation(EOperation operation) {
        IVirtualOperationTable virtualTable = IVirtualOperationTable.Access.INSTANCE.getVirtualTable(operation);
        if (!(virtualTable instanceof VirtualTable)) {
            return;
        }
        if (operation.getEAnnotation(VIRTUAL_TABLE_SOURCE) != null) {
            return;
        }
        EAnnotation annotation = EcoreFactory.eINSTANCE.createEAnnotation();
        operation.getEAnnotations().add((Object)annotation);
        annotation.setSource(VIRTUAL_TABLE_SOURCE);
        VirtualTable vt = (VirtualTable)virtualTable;
        for (EOperation next : vt.getOperations()) {
            annotation.getReferences().add((Object)next);
        }
    }

    private static void saveStaticFeature(EStructuralFeature feature) {
        if (feature.getEAnnotation(STATIC_SOURCE) != null) {
            return;
        }
        if (IntermediateClassFactory.isFeatureStatic(feature)) {
            EAnnotation annotation = EcoreFactory.eINSTANCE.createEAnnotation();
            annotation.setSource(STATIC_SOURCE);
            feature.getEAnnotations().add((Object)annotation);
        }
    }

    private static void loadStaticFeatureFromAnnotation(EStructuralFeature feature) {
        EAnnotation annotation = feature.getEAnnotation(STATIC_SOURCE);
        if (annotation != null) {
            IntermediateClassFactory.markFeatureAsStatic(feature);
        }
    }

    private static void saveOperationCallDetails(OperationCallExp opCallExp) {
        if (opCallExp.getEAnnotation(OPERATION_CALL_SOURCE) != null) {
            return;
        }
        EAnnotation annotation = EcoreFactory.eINSTANCE.createEAnnotation();
        annotation.setSource(OPERATION_CALL_SOURCE);
        opCallExp.getEAnnotations().add((Object)annotation);
        annotation.getDetails().put((Object)OPERATION_CALL_DETAILS_OPCODE, (Object)String.valueOf(opCallExp.getOperationCode()));
    }

    private static void loadOperationCallDetails(OperationCallExp opCallExp) {
        EAnnotation annotation = opCallExp.getEAnnotation(OPERATION_CALL_SOURCE);
        if (annotation == null) {
            return;
        }
        String opCodeString = (String)annotation.getDetails().get((Object)OPERATION_CALL_DETAILS_OPCODE);
        if (opCodeString == null) {
            return;
        }
        try {
            opCallExp.setOperationCode(Integer.valueOf(opCodeString).intValue());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }
}

