/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.codegen.ecore.genmodel.GenPackage;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.codegen.dynamic.JavaClasspath;
import org.eclipse.ocl.examples.codegen.dynamic.JavaFileUtil;
import org.eclipse.ocl.pivot.utilities.URIUtil;
import org.eclipse.qvtd.compiler.AbstractCompilerOptions;
import org.eclipse.qvtd.compiler.CompilerChain;
import org.eclipse.qvtd.compiler.internal.utilities.CompilerUtil;
import org.osgi.framework.Bundle;

public class DefaultCompilerOptions
extends AbstractCompilerOptions {
    public static final @NonNull Map<Object, Object> defaultSavingOptions = new HashMap<Object, Object>();

    static {
        defaultSavingOptions.put("ENCODING", "UTF-8");
        defaultSavingOptions.put("LINE_DELIMITER", "\n");
        defaultSavingOptions.put("SCHEMA_LOCATION", Boolean.TRUE);
        defaultSavingOptions.put("SCHEMA_LOCATION_IMPLEMENTATION", Boolean.TRUE);
        defaultSavingOptions.put("LINE_WIDTH", 132);
        defaultSavingOptions.put("NORMALIZE_CONTENTS", Boolean.TRUE);
    }

    public DefaultCompilerOptions() {
        this.setOption("default", CompilerChain.SAVE_OPTIONS_KEY, this.getSaveOptions());
    }

    private static File getProjectFolder(@NonNull String projectName) throws IOException {
        String location;
        File projectFile;
        File outputClassPath;
        assert (EMFPlugin.IS_ECLIPSE_RUNNING);
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = workspaceRoot.getProject(projectName);
        if (project != null && (outputClassPath = JavaFileUtil.getOutputClassPath((File)(projectFile = new File(location = String.valueOf(project.getLocation()))))) != null) {
            return outputClassPath;
        }
        Bundle bundle = Platform.getBundle((String)projectName);
        if (bundle != null) {
            try {
                File bundleFile = FileLocator.getBundleFile((Bundle)bundle);
                bundleFile.isDirectory();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    public @NonNull Map<Object, Object> getSaveOptions() {
        HashMap<Object, Object> saveOptions = new HashMap<Object, Object>(defaultSavingOptions);
        saveOptions.put("NORMALIZE_CONTENTS", Boolean.TRUE);
        return saveOptions;
    }

    private void setClassStepOptions(@NonNull String projectName, @NonNull URI classURI) throws IOException {
        assert (EMFPlugin.IS_ECLIPSE_RUNNING);
        JavaClasspath classpath = CompilerUtil.createDefaultQVTiClasspath();
        File projectFolder = DefaultCompilerOptions.getProjectFolder(projectName);
        if (projectFolder != null) {
            classpath.addFile(projectFolder);
        }
        this.setOption("Class", CompilerChain.CLASSPATH_KEY, classpath);
        IFile classFiles = URIUtil.getResolvedFile((URI)classURI);
        if (classFiles == null) {
            throw new IOException("Failed to locate Class files folder '" + classURI + "'");
        }
        this.setOption("Class", CompilerChain.URI_KEY, URI.createFileURI((String)classFiles.getLocation().toString()));
    }

    public void setDebugGraphs(boolean dotGraphs, boolean yedGraphs) {
        this.setOption("QVTs", CompilerChain.SCHEDULER_DOT_GRAPHS, dotGraphs);
        this.setOption("QVTs", CompilerChain.SCHEDULER_YED_GRAPHS, yedGraphs);
    }

    public void setGenerateClassesOptions(@NonNull URI srcFileURI, @NonNull URI binFileURI, @NonNull JavaClasspath classpath, boolean isIncremental) {
        this.setOption("Java", CompilerChain.URI_KEY, srcFileURI);
        this.setOption("Java", CompilerChain.JAVA_INCREMENTAL_KEY, isIncremental);
        this.setOption("Java", CompilerChain.JAVA_GENERATED_DEBUG_KEY, true);
        this.setOption("Class", CompilerChain.CLASSPATH_KEY, classpath);
        this.setOption("Class", CompilerChain.URI_KEY, binFileURI);
    }

    public void setGenerateGenModelOptions(@NonNull URI genModelURI, @NonNull String basePrefix, @Nullable String copyright, @Nullable Collection<@NonNull GenPackage> usedGenPackages) {
        this.setOption("GenModel", CompilerChain.URI_KEY, genModelURI);
        Map<@NonNull String, @Nullable String> genModelOptions = this.basicGetOption("GenModel", CompilerChain.GENMODEL_OPTIONS_KEY);
        if (genModelOptions == null) {
            genModelOptions = new HashMap<String, String>();
            this.setOption("GenModel", CompilerChain.GENMODEL_OPTIONS_KEY, genModelOptions);
        }
        genModelOptions.put("genModelBasePrefix", basePrefix);
        if (copyright != null) {
            genModelOptions.put("genModelCopyrightText", copyright);
        }
        this.setOption("GenModel", CompilerChain.GENMODEL_USED_GENPACKAGES_KEY, usedGenPackages);
    }

    public void setQVTcGenerateOptions(@NonNull String projectName, @NonNull URI txURI, @NonNull URI genModelURI, @NonNull URI javaURI, @NonNull URI classURI) throws IOException {
        assert (EMFPlugin.IS_ECLIPSE_RUNNING);
        this.setOption("GenModel", CompilerChain.URI_KEY, genModelURI);
        IFile javaFiles = URIUtil.getResolvedFile((URI)javaURI);
        if (javaFiles == null) {
            throw new IOException("Failed to locate Java files folder '" + javaURI + "'");
        }
        this.setOption("Java", CompilerChain.URI_KEY, URI.createFileURI((String)javaFiles.getLocation().toString()));
        this.setClassStepOptions(projectName, classURI);
    }

    public void setQVTrGenerateOptions(@NonNull String projectName, @NonNull URI txURI, @NonNull URI genModelURI, @NonNull URI javaURI, @NonNull URI classURI) throws IOException {
        assert (EMFPlugin.IS_ECLIPSE_RUNNING);
        this.setOption("GenModel", CompilerChain.URI_KEY, genModelURI);
        this.setOption("GenModel", CompilerChain.GENMODEL_MODEL_DIRECTORY_KEY, javaURI.toPlatformString(false));
        String copyright = null;
        String basePrefix = projectName;
        Collection<GenPackage> usedGenPackages = null;
        this.setGenerateGenModelOptions(genModelURI, basePrefix, copyright, usedGenPackages);
        String javaFolder = javaURI.deresolve(URIUtil.PLATFORM_RESOURCE).toString();
        this.setOption("GenModel", CompilerChain.GENMODEL_MODEL_DIRECTORY_KEY, javaFolder);
        IFile javaFiles = URIUtil.getResolvedFile((URI)javaURI);
        if (javaFiles == null) {
            throw new IOException("Failed to locate Java files folder '" + javaURI + "'");
        }
        this.setOption("Java", CompilerChain.URI_KEY, URI.createFileURI((String)javaFiles.getLocation().toString()));
        this.setClassStepOptions(projectName, classURI);
    }

    public void setURIsFromStrings(@NonNull String @NonNull [] keys, @NonNull Map<String, String> key2value) {
        String[] stringArray = keys;
        int n = keys.length;
        int n2 = 0;
        while (n2 < n) {
            @NonNull String key = stringArray[n2];
            String value = key2value.get(key);
            URI uri = value != null ? URI.createURI((String)value, (boolean)true) : null;
            this.setOption(key, CompilerChain.URI_KEY, uri);
            ++n2;
        }
    }

    public void setURIs2(@NonNull String @NonNull [] keys, @NonNull Map<@NonNull String, @NonNull URI> key2value) {
        String[] stringArray = keys;
        int n = keys.length;
        int n2 = 0;
        while (n2 < n) {
            @NonNull String key = stringArray[n2];
            URI uri = key2value.get(key);
            assert (uri != null);
            this.setOption(key, CompilerChain.URI_KEY, uri);
            ++n2;
        }
    }
}

