/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.codegen.ecore.genmodel.GenModelPackage;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.codegen.dynamic.ExplicitClassLoader;
import org.eclipse.ocl.examples.codegen.dynamic.JavaClasspath;
import org.eclipse.ocl.examples.codegen.dynamic.JavaFileUtil;
import org.eclipse.ocl.examples.codegen.dynamic.JavaSourceFileObject;
import org.eclipse.ocl.examples.codegen.generator.CodeGenerator;
import org.eclipse.ocl.pivot.internal.manager.PivotMetamodelManager;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.EnvironmentFactory;
import org.eclipse.ocl.pivot.utilities.PivotUtil;
import org.eclipse.qvtd.codegen.qvti.QVTiCodeGenOptions;
import org.eclipse.qvtd.codegen.qvti.java.QVTiCodeGenerator;
import org.eclipse.qvtd.compiler.AbstractCompilerStep;
import org.eclipse.qvtd.compiler.CompilerChain;
import org.eclipse.qvtd.compiler.CompilerChainException;
import org.eclipse.qvtd.compiler.CompilerOptions;
import org.eclipse.qvtd.compiler.internal.common.TypedModelsConfiguration;
import org.eclipse.qvtd.compiler.internal.common.TypedModelsConfigurations;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.ScheduleManager;
import org.eclipse.qvtd.compiler.internal.qvtc2qvtu.QVTc2QVTu;
import org.eclipse.qvtd.compiler.internal.qvti.analysis.QVTiProductionConsumption;
import org.eclipse.qvtd.compiler.internal.qvti.analysis.QVTimperativeDomainUsageAnalysis;
import org.eclipse.qvtd.compiler.internal.qvtm2qvts.QVTm2QVTs;
import org.eclipse.qvtd.compiler.internal.qvts2qvti.QVTs2QVTi;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.QVTs2QVTs;
import org.eclipse.qvtd.compiler.internal.qvtu2qvtm.QVTu2QVTm;
import org.eclipse.qvtd.compiler.internal.utilities.CompilerUtil;
import org.eclipse.qvtd.pivot.qvtbase.Transformation;
import org.eclipse.qvtd.pivot.qvtbase.utilities.QVTbaseEnvironmentFactory;
import org.eclipse.qvtd.pivot.qvtbase.utilities.QVTbaseUtil;
import org.eclipse.qvtd.pivot.qvtcore.utilities.QVTcEnvironmentFactory;
import org.eclipse.qvtd.pivot.qvtimperative.EntryPoint;
import org.eclipse.qvtd.pivot.qvtimperative.ImperativeModel;
import org.eclipse.qvtd.pivot.qvtimperative.ImperativeTransformation;
import org.eclipse.qvtd.pivot.qvtimperative.QVTimperativePackage;
import org.eclipse.qvtd.pivot.qvtimperative.evaluation.QVTiEnvironmentFactory;
import org.eclipse.qvtd.pivot.qvtimperative.utilities.QVTimperativeUtil;
import org.eclipse.qvtd.pivot.qvtschedule.RootRegion;
import org.eclipse.qvtd.pivot.qvtschedule.RuleRegion;
import org.eclipse.qvtd.pivot.qvtschedule.ScheduleModel;
import org.eclipse.qvtd.pivot.qvtschedule.utilities.QVTscheduleUtil;
import org.eclipse.qvtd.runtime.evaluation.Transformer;

public abstract class AbstractCompilerChain
extends CompilerUtil
implements CompilerChain {
    private static final @NonNull Map<@NonNull String, @NonNull String> step2fileExtension = new HashMap<String, String>();
    protected final @NonNull QVTiEnvironmentFactory environmentFactory;
    protected final @NonNull ResourceSet asResourceSet;
    protected final @NonNull CompilerOptions options;
    protected final @NonNull URI txURI;
    protected final @NonNull URI intermediateFileNamePrefixURI;
    private @Nullable List<@NonNull CompilerChain.Listener> listeners = null;
    protected final @NonNull Java2ClassCompilerStep java2classCompilerStep;
    protected final @NonNull QVTc2QVTuCompilerStep qvtc2qvtuCompilerStep;
    protected final @NonNull QVTu2QVTmCompilerStep qvtu2qvtmCompilerStep;
    protected final @NonNull QVTm2QVTsCompilerStep qvtm2qvtsCompilerStep;
    protected final @NonNull QVTs2QVTiCompilerStep qvts2qvtiCompilerStep;
    protected final @NonNull QVTi2JavaCompilerStep qvti2javaCompilerStep;

    static {
        step2fileExtension.put("UMLX", "umlx");
        step2fileExtension.put("QVTr", "qvtras");
        step2fileExtension.put("Trace", "trace.ecore");
        step2fileExtension.put("GenModel", "genmodel");
        step2fileExtension.put("QVTc", "qvtcas");
        step2fileExtension.put("QVTu", "qvtu.qvtcas");
        step2fileExtension.put("QVTm", "qvtm.qvtcas");
        step2fileExtension.put("QVTs", "qvtsas");
        step2fileExtension.put("QVTi", "qvtias");
        step2fileExtension.put("Java", "java");
        step2fileExtension.put("Class", "class");
    }

    public static void checkForProxyURIs(@NonNull Resource resource) throws CompilerChainException {
        Map unresolvedCrossReferences = EcoreUtil.UnresolvedProxyCrossReferencer.find((Resource)resource);
        if (unresolvedCrossReferences != null && unresolvedCrossReferences.size() > 0) {
            ArrayList<@NonNull String> proxyURIs = new ArrayList<String>();
            for (EObject eObject : unresolvedCrossReferences.keySet()) {
                proxyURIs.add(String.valueOf(EcoreUtil.getURI((EObject)eObject)));
            }
            Collections.sort(proxyURIs);
            StringBuilder s = new StringBuilder();
            s.append("Unresolved proxyURIs in " + resource.getURI());
            for (String proxyURI : proxyURIs) {
                s.append("\n\t" + proxyURI);
            }
            throw new CompilerChainException(s.toString(), new Object[0]);
        }
    }

    public static @Nullable String getDefaultFileExtension(@NonNull String key) {
        return step2fileExtension.get(key);
    }

    protected AbstractCompilerChain(@NonNull QVTiEnvironmentFactory environmentFactory, @NonNull URI txURI, @NonNull URI intermediateFileNamePrefixURI, @NonNull CompilerOptions options) {
        this.environmentFactory = environmentFactory;
        this.asResourceSet = environmentFactory.getMetamodelManager().getASResourceSet();
        this.txURI = txURI;
        this.intermediateFileNamePrefixURI = intermediateFileNamePrefixURI;
        this.options = options;
        this.java2classCompilerStep = this.createJava2ClassCompilerStep();
        this.qvtc2qvtuCompilerStep = this.createQVTc2QVTuCompilerStep();
        this.qvtu2qvtmCompilerStep = this.createQVTu2QVTmCompilerStep();
        this.qvtm2qvtsCompilerStep = this.createQVTm2QVTsCompilerStep();
        this.qvts2qvtiCompilerStep = this.createQVTs2QVTiCompilerStep();
        this.qvti2javaCompilerStep = this.createQVTi2JavaCompilerStep();
    }

    @Override
    public void addListener(@NonNull CompilerChain.Listener listener) {
        List<@NonNull CompilerChain.Listener> listeners2 = this.listeners;
        if (listeners2 == null) {
            this.listeners = listeners2 = new ArrayList<CompilerChain.Listener>();
        }
        if (!listeners2.contains(listener)) {
            listeners2.add(listener);
        }
    }

    @Override
    public <T> @Nullable T basicGetOption(@NonNull String stepKey, @NonNull CompilerOptions.Key<T> optionKey) {
        return this.options.basicGetOption(stepKey, optionKey);
    }

    @Override
    public @Nullable CompilerOptions.StepOptions basicGetOptions(@NonNull String stepKey) {
        return this.options.basicGetOptions(stepKey);
    }

    @Override
    public @Nullable URI basicGetURI(@NonNull String stepKey, @NonNull CompilerOptions.Key<URI> uriKey) {
        return (URI)this.basicGetOption(stepKey, URI_KEY);
    }

    @Override
    public @NonNull Class<? extends Transformer> build(@NonNull TypedModelsConfigurations typedModelsConfigurations, String ... genModelFiles) throws Exception {
        ImperativeTransformation asTransformation = this.compile(typedModelsConfigurations);
        return this.generate(asTransformation, genModelFiles);
    }

    @Override
    public void compiled(@NonNull String stepKey, @NonNull Object object) {
        List<@NonNull CompilerChain.Listener> listeners2 = this.listeners;
        if (listeners2 != null) {
            for (CompilerChain.Listener listener : listeners2) {
                listener.compiled(stepKey, object);
            }
        }
    }

    protected @NonNull Java2ClassCompilerStep createJava2ClassCompilerStep() {
        return new Java2ClassCompilerStep(this);
    }

    protected @NonNull QVTc2QVTuCompilerStep createQVTc2QVTuCompilerStep() {
        return new QVTc2QVTuCompilerStep(this);
    }

    protected @NonNull QVTi2JavaCompilerStep createQVTi2JavaCompilerStep() {
        return new QVTi2JavaCompilerStep(this);
    }

    protected @NonNull QVTm2QVTsCompilerStep createQVTm2QVTsCompilerStep() {
        return new QVTm2QVTsCompilerStep(this);
    }

    protected @NonNull QVTs2QVTiCompilerStep createQVTs2QVTiCompilerStep() {
        return new QVTs2QVTiCompilerStep(this);
    }

    protected @NonNull QVTu2QVTmCompilerStep createQVTu2QVTmCompilerStep() {
        return new QVTu2QVTmCompilerStep(this);
    }

    @Override
    public @NonNull Resource createResource(@NonNull URI uri, @NonNull String contentType) throws IOException {
        Resource resource = this.asResourceSet.createResource(uri, contentType);
        if (resource == null) {
            throw new IOException("Failed to create " + uri);
        }
        return resource;
    }

    @Override
    public void dispose() {
    }

    public @NonNull Class<? extends Transformer> generate(@NonNull ImperativeTransformation asTransformation, String ... genModelFiles) throws Exception {
        JavaResult javaResult = this.qvti2java(asTransformation, genModelFiles);
        return this.java2class(javaResult);
    }

    public @NonNull QVTiEnvironmentFactory getEnvironmentFactory() {
        return this.environmentFactory;
    }

    @Override
    public @NonNull URI getURI(@NonNull String stepKey, @NonNull CompilerOptions.Key<URI> uriKey) {
        URI uri = (URI)this.basicGetOption(stepKey, URI_KEY);
        return uri != null ? uri : this.intermediateFileNamePrefixURI.appendFileExtension(step2fileExtension.get(stepKey));
    }

    protected @NonNull Class<? extends Transformer> java2class(@NonNull JavaResult javaResult) throws Exception {
        return this.java2classCompilerStep.execute(this.txURI, javaResult);
    }

    protected @NonNull Resource qvtc2qvtm(@NonNull Resource cResource, @NonNull TypedModelsConfiguration typedModelsConfiguration) throws IOException {
        Resource uResource = this.qvtc2qvtuCompilerStep.execute(cResource, typedModelsConfiguration);
        return this.qvtu2qvtmCompilerStep.execute(uResource);
    }

    protected @NonNull JavaResult qvti2java(@NonNull ImperativeTransformation iTransformation, String ... genModelFiles) throws Exception {
        return this.qvti2javaCompilerStep.execute(this.txURI, iTransformation, genModelFiles);
    }

    protected @NonNull ImperativeTransformation qvtm2qvti(@NonNull Resource pResource, @NonNull TypedModelsConfiguration typedModelsConfiguration) throws IOException {
        ScheduleManager scheduleManager = this.qvtm2qvtsCompilerStep.execute(pResource, typedModelsConfiguration);
        return this.qvts2qvtiCompilerStep.execute(scheduleManager);
    }

    @Override
    public void removeListener(@NonNull CompilerChain.Listener listener) {
        List<@NonNull CompilerChain.Listener> listeners2 = this.listeners;
        if (listeners2 != null) {
            listeners2.remove(listener);
        }
    }

    @Override
    public void saveResource(@NonNull Resource asResource, @NonNull String stepKey) throws IOException {
        Map<Object, Object> saveOptions = this.basicGetOption(stepKey, CompilerChain.SAVE_OPTIONS_KEY);
        if (saveOptions != null) {
            asResource.save(saveOptions);
        }
        AbstractCompilerChain.assertNoResourceSetErrors(stepKey, asResource);
        if (this.basicGetOption(stepKey, CompilerChain.VALIDATE_KEY) == Boolean.TRUE) {
            AbstractCompilerChain.assertNoValidationErrors(stepKey, asResource);
        }
    }

    protected static class Java2ClassCompilerStep
    extends AbstractCompilerStep {
        public Java2ClassCompilerStep(@NonNull CompilerChain compilerChain) {
            super(compilerChain, "Class");
        }

        /*
         * Issues handling annotations - annotations may be inaccurate
         */
        public @NonNull Class<? extends Transformer> execute(@NonNull URI txURI, @NonNull JavaResult javaResult) throws Exception {
            JavaClasspath classpath = (JavaClasspath)this.basicGetOption(CLASSPATH_KEY);
            assert (classpath != null);
            java.net.URI uri = new File(javaResult.file, String.valueOf(javaResult.qualifiedClassName.replace(".", "/")) + ".java").getCanonicalFile().toURI();
            JavaSourceFileObject compilationUnit = new JavaSourceFileObject(uri);
            List<@NonNull JavaSourceFileObject> compilationUnits = Collections.singletonList(compilationUnit);
            String problemMessage = JavaFileUtil.compileClasses(compilationUnits, (String)javaResult.qualifiedClassName, (String)javaResult.classPath, (JavaClasspath)classpath);
            if (problemMessage != null) {
                throw new CompilerChainException(problemMessage, new Object[0]);
            }
            File classFilePath = new File(javaResult.classPath);
            @NonNull List packagePaths = JavaFileUtil.gatherPackageNames((File)classFilePath, null);
            ClassLoader testClassLoader = this.compilerChain.getClass().getClassLoader();
            ExplicitClassLoader classLoader = new ExplicitClassLoader(classFilePath, packagePaths, testClassLoader);
            Class txClass = classLoader.loadClass(javaResult.qualifiedClassName);
            assert (txClass != null);
            this.compiled(txClass);
            return txClass;
        }
    }

    protected static class JavaResult {
        @NonNull File file;
        @NonNull String code;
        @NonNull String qualifiedClassName;
        @NonNull String classPath;

        public JavaResult(@NonNull File file, @NonNull String code, @NonNull String qualifiedClassName, @NonNull String classPath) {
            this.file = file;
            this.code = code;
            this.qualifiedClassName = qualifiedClassName;
            this.classPath = classPath;
        }
    }

    protected static class QVTc2QVTuCompilerStep
    extends AbstractCompilerStep {
        public QVTc2QVTuCompilerStep(@NonNull CompilerChain compilerChain) {
            super(compilerChain, "QVTu");
        }

        public @NonNull Resource execute(@NonNull Resource cResource, @NonNull TypedModelsConfiguration typedModelsConfiguration) throws IOException {
            QVTbaseEnvironmentFactory.CreateStrategy savedStrategy = this.environmentFactory.setCreateStrategy(QVTcEnvironmentFactory.CREATE_STRATEGY);
            Transformation transformation = QVTbaseUtil.getTransformation((Resource)cResource);
            String s = typedModelsConfiguration.reconcile(transformation);
            if (s != null) {
                CompilerUtil.addTransformationError(this, transformation, "Inconsistent configuration\n" + s, new Object[0]);
            }
            try {
                Resource uResource = this.createResource("org.eclipse.qvtd.qvtcore");
                QVTc2QVTu tx = new QVTc2QVTu((EnvironmentFactory)this.environmentFactory, this, typedModelsConfiguration);
                tx.transform(cResource, uResource);
                Resource resource = this.saveResource(uResource);
                return resource;
            }
            finally {
                this.environmentFactory.setCreateStrategy(savedStrategy);
            }
        }
    }

    protected static class QVTi2JavaCompilerStep
    extends AbstractCompilerStep {
        public QVTi2JavaCompilerStep(@NonNull CompilerChain compilerChain) {
            super(compilerChain, "Java");
        }

        protected @NonNull JavaResult execute(@NonNull URI txURI, @NonNull ImperativeTransformation iTransformation, String ... genModelFiles) throws Exception {
            String javaCodeSource;
            Boolean javaIsGeneratedDebug;
            URI genModelURI;
            ResourceSet resourceSet = this.environmentFactory.getResourceSet();
            URI javaFileURI = this.compilerChain.getURI("Java", URI_KEY);
            URI classFileURI = this.compilerChain.getURI("Class", URI_KEY);
            resourceSet.getPackageRegistry().put((Object)"http://www.eclipse.org/emf/2002/GenModel", (Object)GenModelPackage.eINSTANCE);
            if (genModelFiles != null) {
                String[] stringArray = genModelFiles;
                int n = genModelFiles.length;
                int n2 = 0;
                while (n2 < n) {
                    String genModelFile = stringArray[n2];
                    URI resolvedURI = URI.createURI((String)genModelFile).resolve(txURI);
                    this.loadGenModel(resolvedURI);
                    ++n2;
                }
            }
            if ((genModelURI = this.compilerChain.basicGetURI("GenModel", URI_KEY)) != null) {
                URI resolvedURI = genModelURI.resolve(txURI);
                this.loadGenModel(resolvedURI);
            }
            QVTiCodeGenerator cg = new QVTiCodeGenerator(this.environmentFactory, iTransformation);
            QVTiCodeGenOptions options = cg.getOptions();
            options.setUseNullAnnotations(true);
            String javaExtraPrefix = (String)this.compilerChain.basicGetOption("Java", JAVA_EXTRA_PREFIX_KEY);
            if (javaExtraPrefix != null) {
                options.setPackagePrefix(javaExtraPrefix);
            }
            options.setIsGeneratedDebug((javaIsGeneratedDebug = (Boolean)this.compilerChain.basicGetOption("Java", JAVA_GENERATED_DEBUG_KEY)) == Boolean.TRUE);
            Boolean javaIsIncremental = (Boolean)this.compilerChain.basicGetOption("Java", JAVA_INCREMENTAL_KEY);
            options.setIsIncremental(javaIsIncremental == Boolean.TRUE);
            try {
                javaCodeSource = cg.generateClassFile();
            }
            catch (Exception e) {
                CompilerUtil.throwExceptionWithProblems((CodeGenerator)cg, e);
                javaCodeSource = "";
            }
            String javaFilePath = (String)ClassUtil.nonNullState((Object)javaFileURI.toFileString());
            String classFilePath = (String)ClassUtil.nonNullState((Object)classFileURI.toFileString());
            new File(classFilePath).mkdirs();
            File javaFile = cg.saveSourceFile(javaFilePath);
            this.compiled(javaFile);
            return new JavaResult(javaFile, javaCodeSource, cg.getQualifiedName(), classFilePath);
        }

        private void loadGenModel(@NonNull URI genModelURI) {
            ResourceSet resourceSet = this.environmentFactory.getResourceSet();
            PivotMetamodelManager metamodelManager = this.environmentFactory.getMetamodelManager();
            Resource csGenResource = resourceSet.getResource(genModelURI, true);
            for (EObject eObject : csGenResource.getContents()) {
                if (!(eObject instanceof GenModel)) continue;
                GenModel genModel = (GenModel)eObject;
                genModel.reconcile();
                metamodelManager.addGenModel(genModel);
            }
        }
    }

    protected static class QVTm2QVTsCompilerStep
    extends AbstractCompilerStep {
        public QVTm2QVTsCompilerStep(@NonNull CompilerChain compilerChain) {
            super(compilerChain, "QVTs");
        }

        public @NonNull ScheduleManager execute(@NonNull Resource pResource, @NonNull TypedModelsConfiguration typedModelsConfiguration) throws IOException {
            QVTbaseEnvironmentFactory.CreateStrategy savedStrategy = this.environmentFactory.setCreateStrategy(QVTcEnvironmentFactory.CREATE_STRATEGY);
            try {
                Resource sResource = this.createResource("org.eclipse.qvtd.qvtschedule");
                CompilerOptions.StepOptions schedulerOptions = this.compilerChain.basicGetOptions("QVTs");
                @Nullable String traceBaseURI = this.compilerChain.basicGetOption("Trace", CompilerChain.TRACE_BASE_URI_KEY);
                Transformation asTransformation = QVTbaseUtil.getTransformation((Resource)pResource);
                typedModelsConfiguration.reconcile(asTransformation);
                QVTm2QVTs qvtm2qvts = new QVTm2QVTs(this, (EnvironmentFactory)this.environmentFactory, asTransformation, typedModelsConfiguration, schedulerOptions, traceBaseURI);
                ScheduleManager scheduleManager = qvtm2qvts.getScheduleManager();
                sResource.getContents().add((Object)scheduleManager.getScheduleModel());
                Iterable<@NonNull RuleRegion> activeRegions = qvtm2qvts.transform();
                this.throwCompilerChainExceptionForErrors();
                String rootName = (String)ClassUtil.nonNullState((Object)pResource.getURI().trimFileExtension().trimFileExtension().lastSegment());
                QVTs2QVTs qvts2qvts = new QVTs2QVTs(this, scheduleManager, rootName);
                RootRegion rootRegion = qvts2qvts.transform(activeRegions);
                rootRegion.setReferredTransformation(asTransformation);
                this.throwCompilerChainExceptionForErrors();
                this.saveResource(sResource);
                ScheduleManager scheduleManager2 = scheduleManager;
                return scheduleManager2;
            }
            finally {
                this.environmentFactory.setCreateStrategy(savedStrategy);
            }
        }
    }

    protected static class QVTs2QVTiCompilerStep
    extends AbstractCompilerStep {
        public QVTs2QVTiCompilerStep(@NonNull CompilerChain compilerChain) {
            super(compilerChain, "QVTi");
        }

        public @NonNull ImperativeTransformation execute(@NonNull ScheduleManager scheduleManager) throws IOException {
            Resource iResource = this.createResource("org.eclipse.qvtd.qvtimperative");
            ScheduleModel scheduleModel = scheduleManager.getScheduleModel();
            ImperativeModel model = (ImperativeModel)PivotUtil.createModel(ImperativeModel.class, (EClass)QVTimperativePackage.Literals.IMPERATIVE_MODEL, null);
            iResource.getContents().add((Object)model);
            for (RootRegion rootRegion : QVTscheduleUtil.getOwnedRootRegions((ScheduleModel)scheduleModel)) {
                ScheduleManager directedScheduleManager = scheduleManager.getDirectedScheduleManager(rootRegion);
                QVTs2QVTi tx = new QVTs2QVTi(directedScheduleManager, this, this.environmentFactory);
                tx.transform(model, rootRegion);
            }
            QVTs2QVTi tx = new QVTs2QVTi(scheduleManager, this, this.environmentFactory);
            tx.resolveImports(model);
            this.saveResource(iResource);
            ImperativeTransformation iTransformation = (ImperativeTransformation)QVTbaseUtil.getTransformation((Resource)iResource);
            this.throwCompilerChainExceptionForErrors();
            QVTimperativeDomainUsageAnalysis domainUsageAnalysis = new QVTimperativeDomainUsageAnalysis((EnvironmentFactory)this.environmentFactory, this, (Transformation)iTransformation);
            domainUsageAnalysis.analyzeTransformation();
            for (EntryPoint iEntryPoint : QVTimperativeUtil.computeEntryPoints((ImperativeTransformation)iTransformation)) {
                QVTiProductionConsumption qvtiProductionConsumption = new QVTiProductionConsumption(this, domainUsageAnalysis, iEntryPoint);
                qvtiProductionConsumption.analyze();
                qvtiProductionConsumption.validate();
                scheduleManager.writeDebugGraphs(qvtiProductionConsumption, "design-check");
            }
            this.throwCompilerChainExceptionForErrors();
            return iTransformation;
        }
    }

    protected static class QVTu2QVTmCompilerStep
    extends AbstractCompilerStep {
        public QVTu2QVTmCompilerStep(@NonNull CompilerChain compilerChain) {
            super(compilerChain, "QVTm");
        }

        public @NonNull Resource execute(@NonNull Resource uResource) throws IOException {
            QVTbaseEnvironmentFactory.CreateStrategy savedStrategy = this.environmentFactory.setCreateStrategy(QVTcEnvironmentFactory.CREATE_STRATEGY);
            try {
                Resource mResource = this.createResource("org.eclipse.qvtd.qvtcore");
                QVTu2QVTm tx = new QVTu2QVTm((EnvironmentFactory)this.environmentFactory);
                tx.transform(uResource, mResource);
                Resource resource = this.saveResource(mResource);
                return resource;
            }
            finally {
                this.environmentFactory.setCreateStrategy(savedStrategy);
            }
        }
    }
}

