/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.xtext.qvtcore.tests;

import java.io.IOException;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.examples.codegen.dynamic.JavaClasspath;
import org.eclipse.ocl.examples.xtext.tests.TestFile;
import org.eclipse.ocl.examples.xtext.tests.TestFileSystemHelper;
import org.eclipse.ocl.examples.xtext.tests.TestFolder;
import org.eclipse.ocl.examples.xtext.tests.TestProject;
import org.eclipse.ocl.pivot.internal.resource.ProjectMap;
import org.eclipse.ocl.pivot.internal.utilities.OCLInternal;
import org.eclipse.ocl.pivot.model.OCLstdlib;
import org.eclipse.ocl.pivot.resource.ProjectManager;
import org.eclipse.qvtd.compiler.AbstractCompilerChain;
import org.eclipse.qvtd.compiler.CompilerChain;
import org.eclipse.qvtd.compiler.CompilerOptions;
import org.eclipse.qvtd.compiler.DefaultCompilerOptions;
import org.eclipse.qvtd.compiler.QVTcCompilerChain;
import org.eclipse.qvtd.compiler.internal.common.TypedModelsConfiguration;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.ScheduleManager;
import org.eclipse.qvtd.compiler.internal.qvtm2qvts.QVTm2QVTs;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.splitter.Splitter;
import org.eclipse.qvtd.examples.qvtcore.uml2rdbms.simpleuml2rdbms.UmlToRdbmsModelElement;
import org.eclipse.qvtd.pivot.qvtcore.utilities.QVTcore;
import org.eclipse.qvtd.pivot.qvtimperative.ImperativeTransformation;
import org.eclipse.qvtd.pivot.qvtimperative.evaluation.QVTiEnvironmentFactory;
import org.eclipse.qvtd.pivot.qvtschedule.impl.RuleRegionImpl;
import org.eclipse.qvtd.xtext.qvtbase.tests.AbstractTestQVT;
import org.eclipse.qvtd.xtext.qvtbase.tests.LoadTestCase;
import org.eclipse.qvtd.xtext.qvtbase.tests.utilities.XtextCompilerUtil;
import org.eclipse.qvtd.xtext.qvtcore.tests.Families2PersonsNormalizer;
import org.eclipse.qvtd.xtext.qvtcore.tests.Forward2ReverseNormalizer;
import org.eclipse.qvtd.xtext.qvtcore.tests.HSV2HSLNormalizer;
import org.eclipse.qvtd.xtext.qvtcore.tests.QVTcoreTestFileSystemHelper;
import org.eclipse.qvtd.xtext.qvtcore.tests.SimpleRDBMSNormalizer;
import org.eclipse.qvtd.xtext.qvtcore.tests.Upper2LowerNormalizer;
import org.eclipse.qvtd.xtext.qvtcore.tests.uml2rdbms.simplerdbms.SimplerdbmsPackage;
import org.eclipse.qvtd.xtext.qvtcore.tests.uml2rdbms.simpleuml.SimpleumlPackage;
import org.eclipse.qvtd.xtext.qvtcore.tests.uml2rdbms.simpleuml2rdbms.Simpleuml2rdbmsPackage;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class QVTcCompilerTests
extends LoadTestCase {
    private static boolean NO_MERGES = true;

    protected @NonNull OCLInternal createOCL() {
        return QVTcore.newInstance((ProjectManager)this.getTestProjectManager(), null);
    }

    protected @NonNull MyQVT createQVT(@NonNull String resultPrefix, @NonNull URI txURI) throws Exception {
        ProjectManager testProjectManager = this.getTestProjectManager();
        URI intermediateFileNamePrefixURI = this.getTestURI(resultPrefix);
        URI srcFileURI = this.getTestFileURI("test-src/");
        URI binFileURI = this.getTestFileURI("test-bin/");
        return new MyQVT(testProjectManager, this.getTestProject(), this.getTestBundleURI(), txURI, intermediateFileNamePrefixURI, srcFileURI, binFileURI);
    }

    protected @NonNull TestFileSystemHelper getTestFileSystemHelper() {
        return new QVTcoreTestFileSystemHelper();
    }

    @Before
    public void setUp() throws Exception {
        super.setUp();
        QVTm2QVTs.DEBUG_GRAPHS.setState(true);
        OCLstdlib.install();
        XtextCompilerUtil.doQVTcoreSetup();
        XtextCompilerUtil.doQVTimperativeSetup();
    }

    @After
    public void tearDown() throws Exception {
        super.tearDown();
    }

    @Test
    public void testQVTcCompiler_Families2Persons() throws Exception {
        EPackage.Registry registry = EPackage.Registry.INSTANCE;
        registry.remove((Object)"http://www.eclipse.org/qvtd/xtext/qvtcore/tests/Upper2Lower/1.0/Families");
        registry.remove((Object)"http://www.eclipse.org/qvtd/xtext/qvtcore/tests/Upper2Lower/1.0/Families2Persons");
        registry.remove((Object)"http://www.eclipse.org/qvtd/xtext/qvtcore/tests/Upper2Lower/1.0/Persons");
        ProjectManager testProjectManager = this.getTestProjectManager();
        TestProject testProject = this.getTestProject();
        TestFolder outputFolder = testProject.getOutputFolder("samples");
        URI modelsURI = this.getModelsURI("families2persons/samples");
        TestFile txFile = testProject.copyFiles(testProjectManager, null, this.getModelsURI("families2persons"), new String[]{"Families2Persons.qvtc", "Families.ecore", "Persons.ecore", "Families2Persons.ecore"});
        TestFile inFile = testProject.copyFiles(testProjectManager, outputFolder, modelsURI, new String[]{"Families.xmi"});
        URI outURI = this.getTestURI("Persons_Interpreted.xmi");
        TestFile refFile = testProject.copyFiles(testProjectManager, outputFolder, modelsURI, new String[]{"Persons_expected.xmi"});
        MyQVT myQVT = this.createQVT("Families2Persons", txFile.getURI());
        try {
            ImperativeTransformation iTransformation = myQVT.compileTransformation("person");
            myQVT.createInterpretedExecutor(iTransformation);
            myQVT.addInputURI("family", inFile.getURI());
            myQVT.executeTransformation();
            myQVT.addOutputURI("person", outURI);
            myQVT.saveModels(null);
            myQVT.checkOutput(outURI, refFile.getURI(), Families2PersonsNormalizer.INSTANCE);
        }
        finally {
            myQVT.dispose();
        }
    }

    @Test
    public void testQVTcCompiler_Families2Persons_CG() throws Exception {
        TestFile txFile = this.getTestProject().copyFiles(this.getTestProjectManager(), null, this.getModelsURI("families2persons"), new String[]{"Families2Persons.qvtc", "Families.ecore", "Persons.ecore", "Families2Persons.ecore", "Families2Persons.genmodel"});
        MyQVT myQVT = this.createQVT("Families2Persons", txFile.getURI());
        try {
            Class txClass = myQVT.buildTransformation_486938("person", false, new String[]{"Families2Persons.genmodel"});
            myQVT.assertRegionCount(RuleRegionImpl.class, 2);
            myQVT.createGeneratedExecutor(txClass);
            myQVT.addInputURI("family", this.getModelsURI("families2persons/samples/Families.xmi"));
            myQVT.executeTransformation();
            myQVT.addOutputURI("person", this.getTestURI("Persons_CG.xmi"));
            myQVT.saveModels(null);
            myQVT.checkOutput(this.getTestURI("Persons_CG.xmi"), this.getModelsURI("families2persons/samples/Persons_expected.xmi"), Families2PersonsNormalizer.INSTANCE);
            myQVT.createGeneratedExecutor(txClass);
            myQVT.addInputURI("family", this.getModelsURI("families2persons/samples/FamiliesBig.xmi"));
            myQVT.executeTransformation();
            myQVT.addOutputURI("person", this.getTestURI("PersonsBig_CG.xmi"));
            myQVT.saveModels(null);
            myQVT.checkOutput(this.getTestURI("PersonsBig_CG.xmi"), this.getModelsURI("families2persons/samples/PersonsBig_expected.xmi"), Families2PersonsNormalizer.INSTANCE);
        }
        finally {
            myQVT.dispose();
        }
    }

    @Test
    public void testQVTcCompiler_Forward2Reverse() throws Exception {
        EPackage.Registry registry = EPackage.Registry.INSTANCE;
        registry.remove((Object)"http://www.eclipse.org/qvtd/xtext/qvtcore/tests/forward2reverse/1.0/DoublyLinkList");
        registry.remove((Object)"http://www.eclipse.org/qvtd/xtext/qvtcore/tests/forward2reverse/1.0/List2List");
        ProjectManager testProjectManager = this.getTestProjectManager();
        TestProject testProject = this.getTestProject();
        TestFolder outputFolder = testProject.getOutputFolder("samples");
        URI modelsURI = this.getModelsURI("forward2reverse/samples");
        TestFile txFile = testProject.copyFiles(testProjectManager, null, this.getModelsURI("forward2reverse"), new String[]{"Forward2Reverse.qvtc", "DoublyLinkedList.ecore", "List2List.ecore"});
        TestFile inFile0 = testProject.copyFiles(testProjectManager, outputFolder, modelsURI, new String[]{"EmptyList.xmi"});
        TestFile inFile1 = testProject.copyFiles(testProjectManager, outputFolder, modelsURI, new String[]{"OneElementList.xmi"});
        TestFile inFile2 = testProject.copyFiles(testProjectManager, outputFolder, modelsURI, new String[]{"TwoElementList.xmi"});
        TestFile inFile3 = testProject.copyFiles(testProjectManager, outputFolder, modelsURI, new String[]{"ThreeElementList.xmi"});
        URI outURI0 = this.getTestURI("EmptyList_Interpreted.xmi");
        URI outURI1 = this.getTestURI("OneElementList_Interpreted.xmi");
        URI outURI2 = this.getTestURI("TwoElementList_Interpreted.xmi");
        URI outURI3 = this.getTestURI("ThreeElementList_Interpreted.xmi");
        TestFile refFile0 = testProject.copyFiles(testProjectManager, outputFolder, modelsURI, new String[]{"EmptyList_expected.xmi"});
        TestFile refFile1 = testProject.copyFiles(testProjectManager, outputFolder, modelsURI, new String[]{"OneElementList_expected.xmi"});
        TestFile refFile2 = testProject.copyFiles(testProjectManager, outputFolder, modelsURI, new String[]{"TwoElementList_expected.xmi"});
        TestFile refFile3 = testProject.copyFiles(testProjectManager, outputFolder, modelsURI, new String[]{"ThreeElementList_expected.xmi"});
        MyQVT myQVT = this.createQVT("Forward2Reverse", txFile.getURI());
        try {
            ImperativeTransformation iTransformation = myQVT.compileTransformation("reverse");
            myQVT.createInterpretedExecutor(iTransformation);
            myQVT.addInputURI("forward", inFile0.getURI());
            myQVT.executeTransformation();
            myQVT.addOutputURI("reverse", outURI0);
            myQVT.saveModels(null);
            myQVT.checkOutput(outURI0, refFile0.getURI(), Forward2ReverseNormalizer.INSTANCE);
            myQVT.createInterpretedExecutor(iTransformation);
            myQVT.addInputURI("forward", inFile1.getURI());
            myQVT.executeTransformation();
            myQVT.addOutputURI("reverse", outURI1);
            myQVT.saveModels(null);
            myQVT.checkOutput(outURI1, refFile1.getURI(), Forward2ReverseNormalizer.INSTANCE);
            myQVT.createInterpretedExecutor(iTransformation);
            myQVT.addInputURI("forward", inFile2.getURI());
            myQVT.executeTransformation();
            myQVT.addOutputURI("reverse", outURI2);
            myQVT.saveModels(null);
            myQVT.checkOutput(outURI2, refFile2.getURI(), Forward2ReverseNormalizer.INSTANCE);
            myQVT.createInterpretedExecutor(iTransformation);
            myQVT.addInputURI("forward", inFile3.getURI());
            myQVT.executeTransformation();
            myQVT.addOutputURI("reverse", outURI3);
            myQVT.saveModels(null);
            myQVT.checkOutput(outURI3, refFile3.getURI(), Forward2ReverseNormalizer.INSTANCE);
        }
        finally {
            myQVT.dispose();
        }
    }

    @Test
    public void testQVTcCompiler_Forward2Reverse_CG() throws Exception {
        TestFile txFile = this.getTestProject().copyFiles(this.getTestProjectManager(), null, this.getModelsURI("forward2reverse"), new String[]{"Forward2Reverse.qvtc", "DoublyLinkedList.ecore", "List2List.ecore", "List2List.genmodel"});
        MyQVT myQVT = this.createQVT("Forward2Reverse", txFile.getURI());
        try {
            Class txClassReverse = myQVT.buildTransformation("forward", false, new String[]{"List2List.genmodel"});
            myQVT.assertRegionCount(RuleRegionImpl.class, 0);
            myQVT.createGeneratedExecutor(txClassReverse);
            myQVT.addInputURI("reverse", this.getModelsURI("forward2reverse/samples/ThreeElementList.xmi"));
            myQVT.executeTransformation();
            myQVT.addOutputURI("forward", this.getTestURI("ThreeElementList_Reverse_CG.xmi"));
            myQVT.saveModels(null);
            myQVT.checkOutput(this.getTestURI("ThreeElementList_Reverse_CG.xmi"), this.getModelsURI("forward2reverse/samples/ThreeElementList_expected.xmi"), Forward2ReverseNormalizer.INSTANCE);
            Class txClass = myQVT.buildTransformation("reverse", false, new String[]{"List2List.genmodel"});
            myQVT.createGeneratedExecutor(txClass);
            myQVT.addInputURI("forward", this.getModelsURI("forward2reverse/samples/EmptyList.xmi"));
            myQVT.executeTransformation();
            myQVT.addOutputURI("reverse", this.getTestURI("EmptyList_CG.xmi"));
            myQVT.saveModels(null);
            myQVT.checkOutput(this.getTestURI("EmptyList_CG.xmi"), this.getModelsURI("forward2reverse/samples/EmptyList_expected.xmi"), Forward2ReverseNormalizer.INSTANCE);
            myQVT.createGeneratedExecutor(txClass);
            myQVT.addInputURI("forward", this.getModelsURI("forward2reverse/samples/OneElementList.xmi"));
            myQVT.executeTransformation();
            myQVT.addOutputURI("reverse", this.getTestURI("OneElementList_CG.xmi"));
            myQVT.saveModels(null);
            myQVT.checkOutput(this.getTestURI("OneElementList_CG.xmi"), this.getModelsURI("forward2reverse/samples/OneElementList_expected.xmi"), Forward2ReverseNormalizer.INSTANCE);
            myQVT.createGeneratedExecutor(txClass);
            myQVT.addInputURI("forward", this.getModelsURI("forward2reverse/samples/TwoElementList.xmi"));
            myQVT.executeTransformation();
            myQVT.addOutputURI("reverse", this.getTestURI("TwoElementList_CG.xmi"));
            myQVT.saveModels(null);
            myQVT.checkOutput(this.getTestURI("TwoElementList_CG.xmi"), this.getModelsURI("forward2reverse/samples/TwoElementList_expected.xmi"), Forward2ReverseNormalizer.INSTANCE);
            myQVT.createGeneratedExecutor(txClass);
            myQVT.addInputURI("forward", this.getModelsURI("forward2reverse/samples/ThreeElementList.xmi"));
            myQVT.executeTransformation();
            myQVT.addOutputURI("reverse", this.getTestURI("ThreeElementList_CG.xmi"));
            myQVT.saveModels(null);
            myQVT.checkOutput(this.getTestURI("ThreeElementList_CG.xmi"), this.getModelsURI("forward2reverse/samples/ThreeElementList_expected.xmi"), Forward2ReverseNormalizer.INSTANCE);
        }
        finally {
            myQVT.dispose();
        }
    }

    @Test
    public void testQVTcCompiler_HSVToHSL() throws Exception {
        EPackage.Registry registry = EPackage.Registry.INSTANCE;
        registry.remove((Object)"http://www.eclipse.org/qvtd/xtext/qvtcore/tests/HSV2HLS/1.0/HSVtoHLS");
        registry.remove((Object)"http://www.eclipse.org/qvtd/xtext/qvtcore/tests/HSV2HLS/1.0/HSVTree");
        registry.remove((Object)"http://www.eclipse.org/qvtd/xtext/qvtcore/tests/HSV2HSL/1.0/HSLTree");
        TestFile txFile = this.getTestProject().copyFiles(this.getTestProjectManager(), null, this.getModelsURI("hsv2hsl"), new String[]{"HSV2HSL.qvtc", "HSLTree.ecore", "HSV2HSL.ecore", "HSVTree.ecore"});
        TestFile inFile = this.getTestProject().copyFiles(this.getTestProjectManager(), this.getTestProject().getOutputFolder("samples"), this.getModelsURI("hsv2hsl/samples"), new String[]{"SolarizedHSV.xmi"});
        URI outURI = this.getTestURI("SolarizedHSL_Interpreted.xmi");
        TestFile refFile = this.getTestProject().copyFiles(this.getTestProjectManager(), this.getTestProject().getOutputFolder("samples"), this.getModelsURI("hsv2hsl/samples"), new String[]{"SolarizedHSL_expected.xmi"});
        MyQVT myQVT = this.createQVT("HSV2HSL", txFile.getURI());
        try {
            ImperativeTransformation iTransformation = myQVT.compileTransformation("hsl");
            myQVT.createInterpretedExecutor(iTransformation);
            myQVT.addInputURI("hsv", inFile.getURI());
            myQVT.executeTransformation();
            myQVT.addOutputURI("hsl", outURI);
            myQVT.saveModels(null);
            myQVT.checkOutput(outURI, refFile.getURI(), HSV2HSLNormalizer.INSTANCE);
        }
        finally {
            myQVT.dispose();
        }
    }

    @Test
    public void testQVTcCompiler_HSVToHSL_CG() throws Exception {
        TestFile txFile = this.getTestProject().copyFiles(this.getTestProjectManager(), null, this.getModelsURI("hsv2hsl"), new String[]{"HSV2HSL.qvtc", "HSLTree.ecore", "HSV2HSL.ecore", "HSVTree.ecore", "HSV2HSL.genmodel"});
        MyQVT myQVT = this.createQVT("HSV2HSL", txFile.getURI());
        try {
            Class txClass = myQVT.buildTransformation("hsl", false, new String[]{"HSV2HSL.genmodel"});
            myQVT.assertRegionCount(RuleRegionImpl.class, 1);
            myQVT.createGeneratedExecutor(txClass);
            myQVT.addInputURI("hsv", this.getModelsURI("hsv2hsl/samples/SolarizedHSV.xmi"));
            myQVT.executeTransformation();
            myQVT.addOutputURI("hsl", this.getTestURI("SolarizedHSL_CG.xmi"));
            myQVT.saveModels(null);
            myQVT.checkOutput(this.getTestURI("SolarizedHSL_CG.xmi"), this.getModelsURI("hsv2hsl/samples/SolarizedHSL_expected.xmi"), HSV2HSLNormalizer.INSTANCE);
        }
        finally {
            myQVT.dispose();
        }
    }

    @Test
    public void testQVTcCompiler_SimpleUML2RDBMS() throws Exception {
        MyQVT myQVT = this.createQVT("SimpleUML2RDBMS", this.getModelsURI("uml2rdbms/SimpleUML2RDBMS.qvtcas"));
        myQVT.loadEcoreFile(this.getModelsURI("uml2rdbms/SimpleUML2RDBMS.ecore"), Simpleuml2rdbmsPackage.eINSTANCE);
        myQVT.loadEcoreFile(this.getModelsURI("uml2rdbms/SimpleUML.ecore"), SimpleumlPackage.eINSTANCE);
        myQVT.loadEcoreFile(this.getModelsURI("uml2rdbms/SimpleRDBMS.ecore"), SimplerdbmsPackage.eINSTANCE);
        try {
            ImperativeTransformation iTransformation = myQVT.compileTransformation("rdbms");
            myQVT.createInterpretedExecutor(iTransformation);
            myQVT.addInputURI("uml", this.getModelsURI("uml2rdbms/samples/SimplerUMLPeople.xmi"));
            myQVT.executeTransformation();
            myQVT.addOutputURI("rdbms", this.getTestURI("SimplerRDBMSPeople_Interpreted.xmi"));
            myQVT.saveModels(null);
            myQVT.checkOutput(this.getTestURI("SimplerRDBMSPeople_Interpreted.xmi"), this.getModelsURI("uml2rdbms/samples/SimplerRDBMSPeople_expected.xmi"), SimpleRDBMSNormalizer.INSTANCE);
            myQVT.createInterpretedExecutor(iTransformation);
            myQVT.addInputURI("uml", this.getModelsURI("uml2rdbms/samples/SimplerUMLPeople2.xmi"));
            myQVT.executeTransformation();
            myQVT.addOutputURI("rdbms", this.getTestURI("SimplerRDBMSPeople2_Interpreted.xmi"));
            myQVT.saveModels(null);
            myQVT.checkOutput(this.getTestURI("SimplerRDBMSPeople2_Interpreted.xmi"), this.getModelsURI("uml2rdbms/samples/SimplerRDBMSPeople2_expected.xmi"), SimpleRDBMSNormalizer.INSTANCE);
            myQVT.createInterpretedExecutor(iTransformation);
            myQVT.addInputURI("uml", this.getModelsURI("uml2rdbms/samples/SimpleUMLPeople.xmi"));
            myQVT.executeTransformation();
            myQVT.addOutputURI("rdbms", this.getTestURI("SimpleRDBMSPeople_Interpreted.xmi"));
            myQVT.saveModels(null);
            myQVT.checkOutput(this.getTestURI("SimpleRDBMSPeople_Interpreted.xmi"), this.getModelsURI("uml2rdbms/samples/SimpleRDBMSPeople_expected.xmi"), SimpleRDBMSNormalizer.INSTANCE);
        }
        finally {
            myQVT.dispose();
        }
    }

    @Test
    public void testQVTcCompiler_SimpleUML2RDBMS_CG() throws Exception {
        Splitter.RESULT.setState(true);
        Splitter.STAGES.setState(true);
        Splitter.RESULT.setState(true);
        MyQVT myQVT = this.createQVT("SimpleUML2RDBMS", this.getModelsURI("uml2rdbms/SimpleUML2RDBMS.qvtcas"));
        myQVT.setSuppressFailureDiagnosis(true);
        try {
            Class txClass = myQVT.buildTransformation("rdbms", false, new String[]{"SimpleUML2RDBMS.genmodel"});
            myQVT.createGeneratedExecutor(txClass);
            myQVT.addInputURI("uml", this.getModelsURI("uml2rdbms/samples/SimplerUMLPeople.xmi"));
            myQVT.executeTransformation();
            myQVT.addOutputURI("rdbms", this.getTestURI("SimplerRDBMSPeople_CG.xmi"));
            myQVT.saveModels(null);
            myQVT.checkOutput(this.getTestURI("SimplerRDBMSPeople_CG.xmi"), this.getModelsURI("uml2rdbms/samples/SimplerRDBMSPeople_expected.xmi"), SimpleRDBMSNormalizer.INSTANCE);
            myQVT.createGeneratedExecutor(txClass);
            myQVT.addInputURI("uml", this.getModelsURI("uml2rdbms/samples/SimplerUMLPeople2.xmi"));
            myQVT.executeTransformation();
            myQVT.addOutputURI("rdbms", this.getTestURI("SimplerRDBMSPeople2_CG.xmi"));
            myQVT.saveModels(null);
            myQVT.checkOutput(this.getTestURI("SimplerRDBMSPeople2_CG.xmi"), this.getModelsURI("uml2rdbms/samples/SimplerRDBMSPeople2_expected.xmi"), SimpleRDBMSNormalizer.INSTANCE);
            myQVT.createGeneratedExecutor(txClass);
            myQVT.addInputURI("uml", this.getModelsURI("uml2rdbms/samples/SimpleUMLPeople.xmi"));
            myQVT.executeTransformation();
            myQVT.addOutputURI("rdbms", this.getTestURI("SimpleRDBMSPeople_CG.xmi"));
            myQVT.saveModels(null);
            myQVT.checkOutput(this.getTestURI("SimpleRDBMSPeople_CG.xmi"), this.getModelsURI("uml2rdbms/samples/SimpleRDBMSPeople_expected.xmi"), SimpleRDBMSNormalizer.INSTANCE);
        }
        finally {
            myQVT.dispose();
        }
    }

    @Test
    public void testQVTcCompiler_SimpleUML2RDBMS_example_CG() throws Exception {
        Splitter.RESULT.setState(true);
        Splitter.STAGES.setState(true);
        Splitter.RESULT.setState(true);
        ProjectManager testProjectManager = this.getTestProjectManager();
        TestProject testProject = this.getTestProject();
        TestFolder outputFolder = testProject.getOutputFolder("samples");
        String exampleProjectName = "org.eclipse.qvtd.examples.qvtcore.uml2rdbms";
        URI modelsURI = URI.createPlatformResourceURI((String)("/" + exampleProjectName + "/model"), (boolean)true);
        URI modelsInURI = modelsURI.appendSegment("in");
        URI modelsOutURI = modelsURI.appendSegment("out");
        TestFile txFile = testProject.copyFiles(testProjectManager, null, modelsURI, new String[]{"SimpleUML2RDBMS.qvtc", "SimpleRDBMS.ecore", "SimpleUML.ecore", "SimpleUML2RDBMS.ecore", "SimpleUML2RDBMS.genmodel"});
        TestFile inFile = testProject.copyFiles(testProjectManager, outputFolder, modelsInURI, new String[]{"SimpleUMLPeople.xmi"});
        URI outURI = this.getTestURI("SimpleRDBMSPeople_CG.xmi");
        TestFile refFile = testProject.copyFiles(testProjectManager, outputFolder, modelsOutURI, new String[]{"SimpleRDBMSPeople_expected.xmi"});
        MyQVT myQVT = this.createQVT("SimpleUML2RDBMS", txFile.getURI());
        JavaClasspath classpath = myQVT.getClasspath();
        classpath.addClass(UmlToRdbmsModelElement.class);
        myQVT.setSuppressFailureDiagnosis(true);
        try {
            Class txClass = myQVT.buildTransformation("rdbms", false, new String[]{"SimpleUML2RDBMS.genmodel"});
            myQVT.assertRegionCount(RuleRegionImpl.class, NO_MERGES ? 10 : 11);
            myQVT.createGeneratedExecutor(txClass);
            myQVT.addInputURI("uml", inFile.getURI());
            myQVT.executeTransformation();
            myQVT.addOutputURI("rdbms", outURI);
            myQVT.saveModels(null);
            myQVT.checkOutput(outURI, refFile.getURI(), SimpleRDBMSNormalizer.INSTANCE);
        }
        finally {
            myQVT.dispose();
        }
    }

    @Test
    public void testQVTcCompiler_Upper2Lower() throws Exception {
        MyQVT myQVT = this.createQVT("Upper2Lower", this.getModelsURI("upper2lower/Upper2Lower.qvtcas"));
        try {
            ImperativeTransformation iTransformation = myQVT.compileTransformation("lowerGraph");
            myQVT.createInterpretedExecutor(iTransformation);
            myQVT.addInputURI("upperGraph", this.getModelsURI("upper2lower/samples/SimpleGraph.xmi"));
            myQVT.executeTransformation();
            myQVT.addOutputURI("lowerGraph", this.getTestURI("SimpleGraphLower_Interpreted.xmi"));
            myQVT.saveModels(null);
            myQVT.checkOutput(this.getTestURI("SimpleGraphLower_Interpreted.xmi"), this.getModelsURI("upper2lower/samples/SimpleGraphLower_expected.xmi"), Upper2LowerNormalizer.INSTANCE);
        }
        finally {
            myQVT.dispose();
        }
    }

    @Test
    public void testQVTcCompiler_Upper2Lower_CG() throws Exception {
        MyQVT myQVT = this.createQVT("upper2lower", this.getModelsURI("upper2lower/Upper2Lower.qvtcas"));
        try {
            Class txClass = myQVT.buildTransformation("lowerGraph", false, new String[]{"SimpleGraph2Graph.genmodel"});
            myQVT.createGeneratedExecutor(txClass);
            myQVT.addInputURI("upperGraph", this.getModelsURI("upper2lower/samples/SimpleGraph.xmi"));
            myQVT.executeTransformation();
            myQVT.addOutputURI("lowerGraph", this.getTestURI("SimpleGraphLower_CG.xmi"));
            myQVT.saveModels(null);
            myQVT.checkOutput(this.getTestURI("SimpleGraphLower_CG.xmi"), this.getModelsURI("upper2lower/samples/SimpleGraphLower_expected.xmi"), Upper2LowerNormalizer.INSTANCE);
        }
        finally {
            myQVT.dispose();
        }
    }

    protected class MyQVT
    extends AbstractTestQVT {
        public MyQVT(@NonNull ProjectManager projectManager, @NonNull TestProject testProject, @NonNull URI testBundleURI, @NonNull URI txURI, @NonNull URI intermediateFileNamePrefixURI, @NonNull URI srcFileURI, URI binFileURI) throws IOException {
            super(projectManager, testProject, testBundleURI, txURI, intermediateFileNamePrefixURI, srcFileURI, binFileURI);
        }

        protected @NonNull QVTcCompilerChain createCompilerChain(@NonNull URI txURI, @NonNull URI intermediateFileNamePrefixURI, @NonNull CompilerOptions options) {
            return new InstrumentedCompilerChain(this.getEnvironmentFactory(), txURI, intermediateFileNamePrefixURI, options);
        }

        protected @NonNull DefaultCompilerOptions createCompilerChainOptions() {
            DefaultCompilerOptions options = super.createCompilerChainOptions();
            options.setOption("QVTs", CompilerChain.SCHEDULER_NO_EARLY_MERGE, (Object)NO_MERGES);
            options.setOption("QVTs", CompilerChain.SCHEDULER_NO_LATE_CONSUMER_MERGE, (Object)NO_MERGES);
            return options;
        }

        protected @NonNull JavaClasspath createClassProjectNames() {
            JavaClasspath classpath = super.createClassProjectNames();
            classpath.addClass(((Object)((Object)this)).getClass());
            return classpath;
        }

        protected @NonNull String getBasePrefix() {
            return "org.eclipse.qvtd.xtext.qvtcore.tests";
        }

        protected @NonNull ProjectManager getTestProjectManager(@NonNull String pathFromCurrentWorkingDirectoryToFileSystem) throws Exception {
            return EMFPlugin.IS_ECLIPSE_RUNNING ? new ProjectMap(true) : QVTcCompilerTests.this.getTestProjectManager(pathFromCurrentWorkingDirectoryToFileSystem);
        }

        protected class InstrumentedCompilerChain
        extends QVTcCompilerChain {
            protected InstrumentedCompilerChain(@NonNull QVTiEnvironmentFactory environmentFactory, @NonNull URI txURI, @NonNull URI intermediateFileNamePrefixURI, CompilerOptions options) {
                super(environmentFactory, txURI, intermediateFileNamePrefixURI, options);
            }

            protected // Could not load outer class - annotation placement on inner may be incorrect
             @NonNull AbstractCompilerChain.QVTm2QVTsCompilerStep createQVTm2QVTsCompilerStep() {
                return new AbstractCompilerChain.QVTm2QVTsCompilerStep((CompilerChain)this){

                    public @NonNull ScheduleManager execute(@NonNull Resource pResource, @NonNull TypedModelsConfiguration typedModelsConfiguration) throws IOException {
                        ScheduleManager scheduleManager = super.execute(pResource, typedModelsConfiguration);
                        MyQVT.this.instrumentPartition(scheduleManager);
                        return scheduleManager;
                    }
                };
            }
        }
    }
}

