/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.pivot.qvtimperative.evaluation;

import java.util.HashMap;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.CollectionType;
import org.eclipse.ocl.pivot.Import;
import org.eclipse.ocl.pivot.NamedElement;
import org.eclipse.ocl.pivot.OCLExpression;
import org.eclipse.ocl.pivot.Operation;
import org.eclipse.ocl.pivot.OperationCallExp;
import org.eclipse.ocl.pivot.Package;
import org.eclipse.ocl.pivot.Parameter;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.StandardLibrary;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.TypedElement;
import org.eclipse.ocl.pivot.Variable;
import org.eclipse.ocl.pivot.evaluation.EvaluationEnvironment;
import org.eclipse.ocl.pivot.evaluation.Executor;
import org.eclipse.ocl.pivot.internal.evaluation.BasicEvaluationVisitor;
import org.eclipse.ocl.pivot.internal.evaluation.ExecutorInternal;
import org.eclipse.ocl.pivot.internal.messages.PivotMessagesInternal;
import org.eclipse.ocl.pivot.labels.ILabelGenerator;
import org.eclipse.ocl.pivot.library.AbstractOperation;
import org.eclipse.ocl.pivot.util.Visitable;
import org.eclipse.ocl.pivot.util.Visitor;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.PivotUtil;
import org.eclipse.ocl.pivot.utilities.ValueUtil;
import org.eclipse.ocl.pivot.values.CollectionValue;
import org.eclipse.ocl.pivot.values.InvalidValueException;
import org.eclipse.ocl.pivot.values.NullValue;
import org.eclipse.qvtd.pivot.qvtbase.BaseModel;
import org.eclipse.qvtd.pivot.qvtbase.Domain;
import org.eclipse.qvtd.pivot.qvtbase.Function;
import org.eclipse.qvtd.pivot.qvtbase.FunctionParameter;
import org.eclipse.qvtd.pivot.qvtbase.Pattern;
import org.eclipse.qvtd.pivot.qvtbase.Predicate;
import org.eclipse.qvtd.pivot.qvtbase.Rule;
import org.eclipse.qvtd.pivot.qvtbase.Transformation;
import org.eclipse.qvtd.pivot.qvtbase.TypedModel;
import org.eclipse.qvtd.pivot.qvtcorebase.Assignment;
import org.eclipse.qvtd.pivot.qvtcorebase.BottomPattern;
import org.eclipse.qvtd.pivot.qvtcorebase.CoreDomain;
import org.eclipse.qvtd.pivot.qvtcorebase.CorePattern;
import org.eclipse.qvtd.pivot.qvtcorebase.EnforcementOperation;
import org.eclipse.qvtd.pivot.qvtcorebase.GuardPattern;
import org.eclipse.qvtd.pivot.qvtcorebase.NavigationAssignment;
import org.eclipse.qvtd.pivot.qvtcorebase.OppositePropertyAssignment;
import org.eclipse.qvtd.pivot.qvtcorebase.PropertyAssignment;
import org.eclipse.qvtd.pivot.qvtcorebase.RealizedVariable;
import org.eclipse.qvtd.pivot.qvtcorebase.VariableAssignment;
import org.eclipse.qvtd.pivot.qvtcorebase.utilities.QVTcoreBaseUtil;
import org.eclipse.qvtd.pivot.qvtimperative.ConnectionAssignment;
import org.eclipse.qvtd.pivot.qvtimperative.ConnectionStatement;
import org.eclipse.qvtd.pivot.qvtimperative.ConnectionVariable;
import org.eclipse.qvtd.pivot.qvtimperative.ImperativeBottomPattern;
import org.eclipse.qvtd.pivot.qvtimperative.ImperativeDomain;
import org.eclipse.qvtd.pivot.qvtimperative.ImperativeModel;
import org.eclipse.qvtd.pivot.qvtimperative.Mapping;
import org.eclipse.qvtd.pivot.qvtimperative.MappingCall;
import org.eclipse.qvtd.pivot.qvtimperative.MappingCallBinding;
import org.eclipse.qvtd.pivot.qvtimperative.MappingLoop;
import org.eclipse.qvtd.pivot.qvtimperative.MappingSequence;
import org.eclipse.qvtd.pivot.qvtimperative.MappingStatement;
import org.eclipse.qvtd.pivot.qvtimperative.VariablePredicate;
import org.eclipse.qvtd.pivot.qvtimperative.evaluation.IQVTiEvaluationVisitor;
import org.eclipse.qvtd.pivot.qvtimperative.evaluation.QVTiExecutor;
import org.eclipse.qvtd.runtime.evaluation.InvocationFailedException;

public class QVTiEvaluationVisitor
extends BasicEvaluationVisitor
implements IQVTiEvaluationVisitor {
    protected final @NonNull QVTiExecutor executor;

    public QVTiEvaluationVisitor(@NonNull QVTiExecutor executor) {
        super((ExecutorInternal)executor);
        this.executor = executor;
    }

    private @Nullable Object doConnectionAccumulation(@NonNull ConnectionVariable targetVariable, @NonNull OCLExpression valueExpression) {
        try {
            Object connection = ((ExecutorInternal)this.context).getValueOf((TypedElement)targetVariable);
            CollectionValue.Accumulator connectionCollection = (CollectionValue.Accumulator)ValueUtil.asCollectionValue((Object)connection);
            Object values = valueExpression.accept((Visitor)this.undecoratedVisitor);
            if (values instanceof Iterable) {
                CollectionValue valuesCollection = ValueUtil.asCollectionValue((Object)values);
                for (Object value : valuesCollection) {
                    connectionCollection.add(value);
                }
            } else {
                connectionCollection.add(values);
            }
            return connectionCollection;
        }
        catch (RuntimeException e) {
            ((ExecutorInternal)this.context).replace((TypedElement)targetVariable, (Object)e);
            throw e;
        }
    }

    public @Nullable Object visitAssignment(@NonNull Assignment object) {
        return this.visiting((Visitable)object);
    }

    public @Nullable Object visitBaseModel(@NonNull BaseModel object) {
        return this.visiting((Visitable)object);
    }

    public @Nullable Object visitBottomPattern(@NonNull BottomPattern object) {
        return this.visiting((Visitable)object);
    }

    @Override
    public @Nullable Object visitConnectionAssignment(@NonNull ConnectionAssignment connectionAssignment) {
        OCLExpression valueExpression;
        ConnectionVariable targetVariable = connectionAssignment.getTargetVariable();
        if (targetVariable != null && (valueExpression = connectionAssignment.getValue()) != null) {
            return this.doConnectionAccumulation(targetVariable, valueExpression);
        }
        return null;
    }

    @Override
    public @Nullable Object visitConnectionStatement(@NonNull ConnectionStatement connectionStatement) {
        OCLExpression valueExpression;
        ConnectionVariable targetVariable = connectionStatement.getTargetVariable();
        if (targetVariable != null && (valueExpression = connectionStatement.getValue()) != null) {
            return this.doConnectionAccumulation(targetVariable, valueExpression);
        }
        return null;
    }

    @Override
    public Object visitConnectionVariable(@NonNull ConnectionVariable object) {
        return this.visiting((Visitable)object);
    }

    public @Nullable Object visitCoreDomain(@NonNull CoreDomain object) {
        return this.visiting((Visitable)object);
    }

    public @Nullable Object visitDomain(@NonNull Domain object) {
        return this.visiting((Visitable)object);
    }

    public @Nullable Object visitCorePattern(@NonNull CorePattern object) {
        return this.visiting((Visitable)object);
    }

    public @Nullable Object visitEnforcementOperation(@NonNull EnforcementOperation object) {
        return this.visiting((Visitable)object);
    }

    public @Nullable Object visitFunction(@NonNull Function object) {
        return this.visiting((Visitable)object);
    }

    public @Nullable Object visitFunctionParameter(@NonNull FunctionParameter object) {
        return this.visiting((Visitable)object);
    }

    public @Nullable Object visitGuardPattern(@NonNull GuardPattern object) {
        return this.visiting((Visitable)object);
    }

    @Override
    public @Nullable Object visitImperativeBottomPattern(@NonNull ImperativeBottomPattern object) {
        return this.visitBottomPattern(object);
    }

    @Override
    public @Nullable Object visitImperativeDomain(@NonNull ImperativeDomain object) {
        return this.visitCoreDomain(object);
    }

    @Override
    public @Nullable Object visitImperativeModel(@NonNull ImperativeModel imperativeModel) {
        for (Package pkge : imperativeModel.getOwnedPackages()) {
            pkge.accept((Visitor)this.undecoratedVisitor);
        }
        return true;
    }

    public @Nullable Object visitImport(@NonNull Import object) {
        return this.visiting((Visitable)object);
    }

    @Override
    public @Nullable Object visitMapping(@NonNull Mapping mapping) {
        return this.executor.internalExecuteMapping(mapping, this.undecoratedVisitor);
    }

    @Override
    public @Nullable Object visitMappingCall(@NonNull MappingCall mappingCall) {
        HashMap<Variable, Object> variable2value = new HashMap<Variable, Object>();
        for (MappingCallBinding binding : mappingCall.getBinding()) {
            Variable boundVariable = binding.getBoundVariable();
            if (boundVariable == null) {
                return null;
            }
            Type varType = boundVariable.getType();
            if (varType == null) {
                return null;
            }
            OCLExpression value = binding.getValue();
            if (value == null) {
                return null;
            }
            Object valueOrValues = value.accept((Visitor)this.undecoratedVisitor);
            Type valueType = this.idResolver.getDynamicTypeOf(valueOrValues);
            if (valueType.conformsTo((StandardLibrary)this.standardLibrary, varType)) {
                variable2value.put(boundVariable, valueOrValues);
                continue;
            }
            return null;
        }
        Mapping referredMapping = mappingCall.getReferredMapping();
        if (referredMapping == null) {
            return null;
        }
        return this.executor.internalExecuteMappingCall(mappingCall, variable2value, this.undecoratedVisitor);
    }

    @Override
    public @Nullable Object visitMappingCallBinding(@NonNull MappingCallBinding object) {
        return this.visiting((Visitable)object);
    }

    @Override
    public @Nullable Object visitMappingLoop(@NonNull MappingLoop mappingLoop) {
        EList<Variable> iterators;
        Object inValues = mappingLoop.getOwnedSource().accept((Visitor)this.undecoratedVisitor);
        if (inValues instanceof Iterable && (iterators = mappingLoop.getOwnedIterators()).size() > 0) {
            Variable iterator = (Variable)ClassUtil.nonNullState((Object)((Variable)iterators.get(0)));
            for (Object object : (Iterable)inValues) {
                ((ExecutorInternal)this.context).replace((TypedElement)iterator, object);
                mappingLoop.getOwnedBody().accept((Visitor)this.undecoratedVisitor);
            }
        }
        return true;
    }

    @Override
    public @Nullable Object visitMappingSequence(@NonNull MappingSequence mappingSequence) {
        for (MappingStatement mappingStatement : mappingSequence.getMappingStatements()) {
            if (mappingStatement == null) continue;
            ((ExecutorInternal)this.context).pushEvaluationEnvironment((NamedElement)mappingStatement, (OCLExpression)mappingSequence);
            try {
                mappingStatement.accept((Visitor)this.undecoratedVisitor);
            }
            finally {
                ((ExecutorInternal)this.context).popEvaluationEnvironment();
            }
        }
        return true;
    }

    @Override
    public @Nullable Object visitMappingStatement(@NonNull MappingStatement object) {
        return this.visiting((Visitable)object);
    }

    public @Nullable Object visitNavigationAssignment(@NonNull NavigationAssignment navigationAssignment) {
        Object slotObject = navigationAssignment.getSlotExpression().accept((Visitor)this.undecoratedVisitor);
        if (slotObject instanceof EObject) {
            Object childKey = null;
            try {
                Type type;
                Object boxedValue = navigationAssignment.getValue().accept((Visitor)this.undecoratedVisitor);
                Property targetProperty = QVTcoreBaseUtil.getTargetProperty((NavigationAssignment)navigationAssignment);
                Class instanceClass = PivotUtil.getEcoreInstanceClass((Property)targetProperty);
                Object ecoreValue = this.idResolver.ecoreValueOf(instanceClass, boxedValue);
                Property oppositeProperty = targetProperty.getOpposite();
                if (oppositeProperty != null && (type = oppositeProperty.getType()) instanceof CollectionType) {
                    boolean bl = ((CollectionType)type).isOrdered();
                }
                this.executor.internalExecuteNavigationAssignment(navigationAssignment, slotObject, ecoreValue, childKey);
                return null;
            }
            catch (InvocationFailedException e) {
                this.executor.internalExecuteNavigationAssignment(navigationAssignment, slotObject, (Object)e, childKey);
            }
        } else {
            throw new IllegalArgumentException("Unsupported " + navigationAssignment.eClass().getName() + " specification. The assigment slot expression evaluates to non-ecore value");
        }
        return true;
    }

    public Object visitOperationCallExp(@NonNull OperationCallExp operationCallExp) {
        Operation referredOperation = operationCallExp.getReferredOperation();
        if (referredOperation instanceof Function) {
            Function function = (Function)referredOperation;
            FunctionOperation implementation = new FunctionOperation(function);
            try {
                Object result = implementation.dispatch((Executor)this.context, operationCallExp, null);
                assert (!(result instanceof NullValue));
                return result;
            }
            catch (InvalidValueException e) {
                throw e;
            }
            catch (Exception e) {
                throw new InvalidValueException(e, PivotMessagesInternal.FailedToEvaluate_ERROR_, new Object[]{function, ILabelGenerator.Registry.INSTANCE.labelFor(null), operationCallExp});
            }
        }
        return super.visitOperationCallExp(operationCallExp);
    }

    public @Nullable Object visitOppositePropertyAssignment(@NonNull OppositePropertyAssignment navigationAssignment) {
        return this.visitNavigationAssignment((NavigationAssignment)navigationAssignment);
    }

    public @Nullable Object visitPackage(@NonNull Package pkge) {
        return true;
    }

    public @Nullable Object visitPattern(@NonNull Pattern object) {
        return this.visiting((Visitable)object);
    }

    public @Nullable Object visitPredicate(@NonNull Predicate predicate) {
        OCLExpression exp = predicate.getConditionExpression();
        Object expResult = exp.accept((Visitor)this.undecoratedVisitor);
        return expResult;
    }

    public @Nullable Object visitPropertyAssignment(@NonNull PropertyAssignment navigationAssignment) {
        return this.visitNavigationAssignment((NavigationAssignment)navigationAssignment);
    }

    public @Nullable Object visitRealizedVariable(@NonNull RealizedVariable realizedVariable) {
        return this.executor.internalExecuteRealizedVariable(realizedVariable, this.undecoratedVisitor);
    }

    public @Nullable Object visitRule(@NonNull Rule object) {
        return this.visiting((Visitable)object);
    }

    public @Nullable Object visitTransformation(@NonNull Transformation transformation) {
        return this.executor.internalExecuteTransformation(transformation, this.undecoratedVisitor);
    }

    public @Nullable Object visitTypedModel(@NonNull TypedModel object) {
        return this.visiting((Visitable)object);
    }

    public @Nullable Object visitVariableAssignment(@NonNull VariableAssignment variableAssignment) {
        OCLExpression valueExpression;
        Variable targetVariable = variableAssignment.getTargetVariable();
        if (targetVariable != null && (valueExpression = variableAssignment.getValue()) != null) {
            try {
                Object value = valueExpression.accept((Visitor)this.undecoratedVisitor);
                ((ExecutorInternal)this.context).replace((TypedElement)targetVariable, value);
                return value;
            }
            catch (RuntimeException e) {
                ((ExecutorInternal)this.context).replace((TypedElement)targetVariable, (Object)e);
                throw e;
            }
        }
        return null;
    }

    @Override
    public @Nullable Object visitVariablePredicate(@NonNull VariablePredicate variablePredicate) {
        OCLExpression exp = variablePredicate.getConditionExpression();
        if (exp == null) {
            return false;
        }
        Object value = exp.accept((Visitor)this.undecoratedVisitor);
        Variable variable = variablePredicate.getTargetVariable();
        Type guardType = variable.getType();
        Type valueType = this.idResolver.getDynamicTypeOf(value);
        if (guardType == null || !valueType.conformsTo((StandardLibrary)this.standardLibrary, guardType)) {
            return false;
        }
        ((ExecutorInternal)this.context).replace((TypedElement)variable, value);
        return true;
    }

    public class FunctionOperation
    extends AbstractOperation {
        protected final @NonNull Function function;

        public FunctionOperation(Function function) {
            this.function = function;
        }

        public @Nullable Object dispatch(@NonNull Executor executor, @NonNull OperationCallExp callExp, @Nullable Object sourceValue) {
            List arguments = callExp.getOwnedArguments();
            @Nullable Object[] argumentValues = new Object[arguments.size()];
            int i = 0;
            while (i < arguments.size()) {
                OCLExpression argument = (OCLExpression)arguments.get(i);
                assert (argument != null);
                argumentValues[i] = executor.evaluate(argument);
                ++i;
            }
            return this.evaluate(executor, callExp, sourceValue, argumentValues);
        }

        private @Nullable Object evaluate(@NonNull Executor executor, @NonNull OperationCallExp callExp, @Nullable Object sourceValue, Object ... argumentValues) {
            EvaluationEnvironment nestedEvaluationEnvironment = executor.pushEvaluationEnvironment((NamedElement)this.function, (OCLExpression)callExp);
            List parameters = this.function.getOwnedParameters();
            if (!parameters.isEmpty()) {
                int i = 0;
                while (i < parameters.size()) {
                    Object value = argumentValues[i];
                    nestedEvaluationEnvironment.add((TypedElement)ClassUtil.nonNullModel((Object)((Parameter)parameters.get(i))), value);
                    ++i;
                }
            }
            try {
                OCLExpression bodyExpression = this.function.getQueryExpression();
                assert (bodyExpression != null);
                Object object = executor.evaluate(bodyExpression);
                return object;
            }
            finally {
                executor.popEvaluationEnvironment();
            }
        }
    }
}

