/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvt.declarative.parser.qvtrelation;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import lpg.lpgjavaruntime.Monitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.ocl.Environment;
import org.eclipse.ocl.LookupException;
import org.eclipse.ocl.cst.CSTNode;
import org.eclipse.ocl.cst.CollectionLiteralExpCS;
import org.eclipse.ocl.cst.CollectionLiteralPartCS;
import org.eclipse.ocl.cst.DotOrArrowEnum;
import org.eclipse.ocl.cst.OCLExpressionCS;
import org.eclipse.ocl.cst.OperationCallExpCS;
import org.eclipse.ocl.cst.PathNameCS;
import org.eclipse.ocl.cst.SimpleNameCS;
import org.eclipse.ocl.cst.TypeCS;
import org.eclipse.ocl.cst.VariableExpCS;
import org.eclipse.ocl.ecore.CallOperationAction;
import org.eclipse.ocl.ecore.CollectionLiteralExp;
import org.eclipse.ocl.ecore.CollectionType;
import org.eclipse.ocl.ecore.Constraint;
import org.eclipse.ocl.ecore.EcoreFactory;
import org.eclipse.ocl.ecore.OperationCallExp;
import org.eclipse.ocl.ecore.SendSignalAction;
import org.eclipse.ocl.ecore.Variable;
import org.eclipse.ocl.expressions.OCLExpression;
import org.eclipse.ocl.expressions.PropertyCallExp;
import org.eclipse.ocl.expressions.VariableExp;
import org.eclipse.ocl.lpg.AbstractParser;
import org.eclipse.ocl.parser.AbstractOCLParser;
import org.eclipse.ocl.util.TypeUtil;
import org.eclipse.ocl.utilities.CallingASTNode;
import org.eclipse.qvt.declarative.ecore.QVTBase.Domain;
import org.eclipse.qvt.declarative.ecore.QVTBase.Function;
import org.eclipse.qvt.declarative.ecore.QVTBase.FunctionParameter;
import org.eclipse.qvt.declarative.ecore.QVTBase.Pattern;
import org.eclipse.qvt.declarative.ecore.QVTBase.Predicate;
import org.eclipse.qvt.declarative.ecore.QVTBase.QVTBaseFactory;
import org.eclipse.qvt.declarative.ecore.QVTBase.Rule;
import org.eclipse.qvt.declarative.ecore.QVTBase.TypedModel;
import org.eclipse.qvt.declarative.ecore.QVTRelation.DomainPattern;
import org.eclipse.qvt.declarative.ecore.QVTRelation.Key;
import org.eclipse.qvt.declarative.ecore.QVTRelation.QVTRelationFactory;
import org.eclipse.qvt.declarative.ecore.QVTRelation.Relation;
import org.eclipse.qvt.declarative.ecore.QVTRelation.RelationCallExp;
import org.eclipse.qvt.declarative.ecore.QVTRelation.RelationDomain;
import org.eclipse.qvt.declarative.ecore.QVTRelation.RelationDomainAssignment;
import org.eclipse.qvt.declarative.ecore.QVTRelation.RelationImplementation;
import org.eclipse.qvt.declarative.ecore.QVTRelation.RelationalTransformation;
import org.eclipse.qvt.declarative.ecore.QVTTemplate.CollectionTemplateExp;
import org.eclipse.qvt.declarative.ecore.QVTTemplate.ObjectTemplateExp;
import org.eclipse.qvt.declarative.ecore.QVTTemplate.PropertyTemplateItem;
import org.eclipse.qvt.declarative.ecore.QVTTemplate.QVTTemplateFactory;
import org.eclipse.qvt.declarative.ecore.QVTTemplate.TemplateExp;
import org.eclipse.qvt.declarative.ecore.utils.EcoreUtils;
import org.eclipse.qvt.declarative.modelregistry.environment.AbstractFileHandle;
import org.eclipse.qvt.declarative.modelregistry.environment.AbstractModelResolver;
import org.eclipse.qvt.declarative.modelregistry.util.ClassUtils;
import org.eclipse.qvt.declarative.parser.AbstractQVTAnalyzer;
import org.eclipse.qvt.declarative.parser.environment.CSTChildEnvironment;
import org.eclipse.qvt.declarative.parser.environment.ICSTEnvironment;
import org.eclipse.qvt.declarative.parser.qvt.cst.IdentifiedCS;
import org.eclipse.qvt.declarative.parser.qvt.cst.IdentifierCS;
import org.eclipse.qvt.declarative.parser.qvtrelation.QVTrLexer;
import org.eclipse.qvt.declarative.parser.qvtrelation.QVTrParser;
import org.eclipse.qvt.declarative.parser.qvtrelation.cst.AbstractDomainCS;
import org.eclipse.qvt.declarative.parser.qvtrelation.cst.CollectionTemplateCS;
import org.eclipse.qvt.declarative.parser.qvtrelation.cst.DefaultValueCS;
import org.eclipse.qvt.declarative.parser.qvtrelation.cst.DomainCS;
import org.eclipse.qvt.declarative.parser.qvtrelation.cst.KeyDeclCS;
import org.eclipse.qvt.declarative.parser.qvtrelation.cst.ModelDeclCS;
import org.eclipse.qvt.declarative.parser.qvtrelation.cst.ObjectTemplateCS;
import org.eclipse.qvt.declarative.parser.qvtrelation.cst.ParamDeclarationCS;
import org.eclipse.qvt.declarative.parser.qvtrelation.cst.PrimitiveTypeDomainCS;
import org.eclipse.qvt.declarative.parser.qvtrelation.cst.PropertyTemplateCS;
import org.eclipse.qvt.declarative.parser.qvtrelation.cst.QueryCS;
import org.eclipse.qvt.declarative.parser.qvtrelation.cst.RelationCS;
import org.eclipse.qvt.declarative.parser.qvtrelation.cst.TemplateCS;
import org.eclipse.qvt.declarative.parser.qvtrelation.cst.TopLevelCS;
import org.eclipse.qvt.declarative.parser.qvtrelation.cst.TransformationCS;
import org.eclipse.qvt.declarative.parser.qvtrelation.cst.UnitCS;
import org.eclipse.qvt.declarative.parser.qvtrelation.cst.VarDeclarationCS;
import org.eclipse.qvt.declarative.parser.qvtrelation.cst.WhenCS;
import org.eclipse.qvt.declarative.parser.qvtrelation.cst.WhereCS;
import org.eclipse.qvt.declarative.parser.qvtrelation.environment.IQVTrNodeEnvironment;
import org.eclipse.qvt.declarative.parser.qvtrelation.environment.QVTrDomainEnvironment;
import org.eclipse.qvt.declarative.parser.qvtrelation.environment.QVTrNestedEnvironment;
import org.eclipse.qvt.declarative.parser.qvtrelation.environment.QVTrQueryEnvironment;
import org.eclipse.qvt.declarative.parser.qvtrelation.environment.QVTrRelationEnvironment;
import org.eclipse.qvt.declarative.parser.qvtrelation.environment.QVTrTopLevelEnvironment;
import org.eclipse.qvt.declarative.parser.qvtrelation.environment.QVTrTransformationEnvironment;
import org.eclipse.qvt.declarative.parser.qvtrelation.environment.QVTrTypedModelEnvironment;
import org.eclipse.qvt.declarative.parser.ui.preferences.QVTPreferences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractQVTrAnalyzer
extends AbstractQVTAnalyzer<IQVTrNodeEnvironment> {
    static org.eclipse.emf.ecore.EcoreFactory emfEcoreFactory = org.eclipse.emf.ecore.EcoreFactory.eINSTANCE;
    static EcoreFactory oclEcoreFactory = EcoreFactory.eINSTANCE;

    public AbstractQVTrAnalyzer(QVTrParser parser, Monitor monitor) {
        super((AbstractOCLParser)parser, monitor);
    }

    protected IQVTrNodeEnvironment createdNestedEnvironment(CSTNode cstNode, Environment<EPackage, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, CallOperationAction, SendSignalAction, Constraint, EClass, EObject> env) {
        return new QVTrNestedEnvironment((IQVTrNodeEnvironment)env, cstNode);
    }

    private VariableExp<EClassifier, EParameter> createVariableExp(Environment<EPackage, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, CallOperationAction, SendSignalAction, Constraint, EClass, EObject> env, CSTNode cst, org.eclipse.ocl.expressions.Variable<EClassifier, EParameter> var) {
        VariableExp result = this.oclFactory.createVariableExp();
        this.initASTMapping(env, result, cst);
        if (var != null) {
            result.setType((Object)((EClassifier)var.getType()));
            result.setReferredVariable(var);
            result.setName(var.getName());
        }
        return result;
    }

    protected void declareCollectionTemplateCS(QVTrDomainEnvironment env, EClassifier type, CollectionTemplateCS collectionTemplateCS) {
        IdentifierCS tailIdentifier = collectionTemplateCS.getRestIdentifier();
        if (tailIdentifier != null) {
            env.createVariableDeclaration(tailIdentifier, type);
        }
        for (IdentifiedCS headIdentifier : collectionTemplateCS.getMemberIdentifier()) {
            if (!(headIdentifier instanceof TemplateCS)) continue;
            this.declareTemplateCS(env, (TemplateCS)headIdentifier, null);
        }
    }

    protected void declareDomainCS(QVTrRelationEnvironment env, DomainCS domainCS) {
        QVTrDomainEnvironment domainEnv = env.createEnvironment(domainCS);
        RelationDomain domain = domainEnv.getDomain();
        domain.setIsCheckable(domainCS.isCheckonly());
        domain.setIsEnforceable(domainCS.isEnforce());
        TemplateCS templateVariable = domainCS.getTemplate();
        EClassifier rootVariableType = this.resolveClassifier(domainEnv, "domainCS", templateVariable.getType());
        Variable variable = env.createVariableDeclaration(templateVariable.getIdentifier(), rootVariableType);
        domain.setRootVariable(variable);
    }

    protected void declareInputParamDeclarationCS(QVTrQueryEnvironment env, ParamDeclarationCS inputParamDeclarationCS) {
        FunctionParameter functionParameter = QVTBaseFactory.eINSTANCE.createFunctionParameter();
        env.initASTMapping(functionParameter, inputParamDeclarationCS);
        CSTChildEnvironment.setNameFromIdentifier((ENamedElement)functionParameter, (IdentifierCS)inputParamDeclarationCS.getIdentifier());
        functionParameter.setEType(this.resolveClassifier(env, "inputParamDeclarationCS", inputParamDeclarationCS.getType()));
        env.addParameter(functionParameter);
    }

    protected void declareMetaModelIdCS(QVTrTypedModelEnvironment env, IdentifierCS metaModelIdCS) {
        TypedModel typedModel = env.getTypedModel();
        String metaModelId = this.identifierCS(metaModelIdCS);
        metaModelIdCS.setAst((Object)typedModel);
        AbstractModelResolver resolver = env.getResolver();
        URI uri = resolver.getURI(metaModelId);
        if (uri == null) {
            this.ERROR(metaModelIdCS, "metaModelIdCS", "Unknown meta-model '" + this.formatString(metaModelId) + "'");
        } else {
            try {
                Resource resource = resolver.getResource(uri, true);
                if (resource == null) {
                    this.ERROR(metaModelIdCS, "metaModelIdCS", "Failed to load meta-model '" + this.formatString(metaModelId) + "'");
                } else {
                    EList contents = resource.getContents();
                    if (contents != null) {
                        for (EObject eObject : contents) {
                            if (eObject instanceof EPackage) {
                                typedModel.getUsedPackage().add((Object)((EPackage)eObject));
                                env.addMetaModelPackage(metaModelId, (EPackage)eObject);
                                continue;
                            }
                            this.ERROR(metaModelIdCS, "metaModelIdCS", "Non-EPackage '" + this.formatName(eObject) + "' ignored");
                        }
                    }
                }
            }
            catch (Exception e) {
                this.ERROR(metaModelIdCS, "metaModelIdCS", "Failed to load meta-model '" + this.formatString(metaModelId) + "' : " + e.getMessage());
            }
        }
    }

    protected void declareModelDeclCS(QVTrTransformationEnvironment env, ModelDeclCS modelDeclCS) {
        QVTrTypedModelEnvironment typedModelEnv = env.createEnvironment(modelDeclCS);
        if (typedModelEnv == null) {
            return;
        }
        for (IdentifierCS metaModelIdCS : modelDeclCS.getMetaModelId()) {
            if (this.isCancelled()) continue;
            this.declareMetaModelIdCS(typedModelEnv, metaModelIdCS);
        }
    }

    protected void declareOCLExpressionCS(QVTrDomainEnvironment env, EClassifier propertyType, OCLExpressionCS oclExpressionCS) {
        if (oclExpressionCS instanceof TemplateCS) {
            this.declareTemplateCS(env, (TemplateCS)oclExpressionCS, null);
        } else if (oclExpressionCS instanceof VariableExpCS) {
            env.createVariableDeclaration((VariableExpCS)oclExpressionCS, propertyType);
        } else if (oclExpressionCS instanceof CollectionLiteralExpCS) {
            for (CollectionLiteralPartCS collectionLiteralPartCS : ((CollectionLiteralExpCS)oclExpressionCS).getCollectionLiteralParts()) {
                this.declareOCLExpressionCS(env, propertyType, collectionLiteralPartCS.getExpressionCS());
            }
        }
    }

    protected void declarePredicateCS(QVTrRelationEnvironment env, OCLExpressionCS oclExpressionCS) {
        if (oclExpressionCS == null) {
            return;
        }
        Relation relation = this.isRelationCallExpCS(env, oclExpressionCS);
        if (relation != null) {
            this.declareRelationCallExpCS(env, relation, (OperationCallExpCS)oclExpressionCS);
        } else if (oclExpressionCS instanceof OperationCallExpCS) {
            this.declarePredicateCS(env, ((OperationCallExpCS)oclExpressionCS).getSource());
            EList arguments = ((OperationCallExpCS)oclExpressionCS).getArguments();
            if (arguments != null) {
                for (OCLExpressionCS argument : arguments) {
                    this.declarePredicateCS(env, argument);
                }
            }
        }
    }

    protected void declarePrimitiveTypeDomainCS(QVTrRelationEnvironment env, PrimitiveTypeDomainCS primitiveTypeDomainCS) {
        QVTrDomainEnvironment domainEnv = env.createEnvironment(primitiveTypeDomainCS);
        RelationDomain domain = domainEnv.getDomain();
        domain.setIsCheckable(false);
        domain.setIsEnforceable(false);
        EDataType rootVariableType = this.resolveDataType(env, "domainCS", primitiveTypeDomainCS.getType());
        Variable variable = env.createVariableDeclaration(primitiveTypeDomainCS.getIdentifier(), (EClassifier)rootVariableType);
        domain.setRootVariable(variable);
    }

    protected void declarePropertyTemplateCS(QVTrDomainEnvironment env, EClass parentType, PropertyTemplateCS propertyTemplateCS) {
        EClassifier propertyType = this.resolveProperty(env, parentType, propertyTemplateCS);
        OCLExpressionCS oclExpressionCS = propertyTemplateCS.getOclExpression();
        this.declareOCLExpressionCS(env, propertyType, oclExpressionCS);
    }

    protected void declareQueryCS(QVTrTransformationEnvironment env, QueryCS queryCS) {
        QVTrQueryEnvironment queryEnv = env.createEnvironment(queryCS);
        EClassifier returnType = this.resolveClassifier(env, "queryCS", queryCS.getType());
        for (ParamDeclarationCS inputParamDeclarationCS : queryCS.getInputParamDeclaration()) {
            this.declareInputParamDeclarationCS(queryEnv, inputParamDeclarationCS);
        }
        queryEnv.resolveQuery(returnType);
    }

    protected void declareRelationCS(QVTrTransformationEnvironment env, RelationCS relationCS) {
        QVTrRelationEnvironment relationEnv = env.createEnvironment(relationCS);
        for (AbstractDomainCS domainCS : relationCS.getDomain()) {
            if (domainCS instanceof PrimitiveTypeDomainCS) {
                this.declarePrimitiveTypeDomainCS(relationEnv, (PrimitiveTypeDomainCS)domainCS);
                continue;
            }
            this.declareDomainCS(relationEnv, (DomainCS)domainCS);
        }
    }

    protected void declareRelationCallExpCS(QVTrRelationEnvironment env, Relation relation, OperationCallExpCS relationCallExpCS) {
        int invokingCount;
        EList invokedDomains = relation.getDomain();
        EList invokingArguments = relationCallExpCS.getArguments();
        int invokedCount = invokedDomains != null ? invokedDomains.size() : 0;
        int n = invokingCount = invokingArguments != null ? invokingArguments.size() : 0;
        if (invokedCount != invokingCount) {
            this.ERROR(relationCallExpCS, "relationCallExpCS", "Expected " + invokedCount + " arguments");
            return;
        }
        int i = 0;
        while (i < invokedCount) {
            RelationDomain domain = (RelationDomain)invokedDomains.get(i);
            OCLExpressionCS argument = (OCLExpressionCS)invokingArguments.get(i);
            if (argument instanceof VariableExpCS) {
                env.createVariableDeclaration((VariableExpCS)argument, (EClassifier)domain.getRootVariable().getType(), (Domain)domain, true);
            }
            ++i;
        }
    }

    protected void declareTemplateCS(QVTrDomainEnvironment env, TemplateCS templateCS, EClassifier referredClassifier) {
        if (referredClassifier == null) {
            TypeCS typeCS = templateCS.getType();
            referredClassifier = this.resolveClassifier(env, "templateCS", typeCS);
            env.createVariableDeclaration(templateCS.getIdentifier(), referredClassifier);
        }
        if (templateCS instanceof ObjectTemplateCS) {
            if (referredClassifier == null || referredClassifier instanceof EClass) {
                for (PropertyTemplateCS propertyTemplateCS : ((ObjectTemplateCS)templateCS).getPropertyTemplate()) {
                    this.declarePropertyTemplateCS(env, (EClass)referredClassifier, propertyTemplateCS);
                }
            } else {
                this.ERROR(templateCS.getType(), "declareTemplateCS", "Non-class '" + this.formatType(referredClassifier) + "'");
            }
        } else if (templateCS instanceof CollectionTemplateCS) {
            this.declareCollectionTemplateCS(env, referredClassifier, (CollectionTemplateCS)templateCS);
        } else {
            this.ERROR(templateCS, "declareTemplateCS", "Unsupported " + this.formatClass(templateCS));
        }
    }

    protected void declareTransformationCS(QVTrTopLevelEnvironment topLevelEnvironment, TransformationCS transformationCS) {
        QVTrTransformationEnvironment env = topLevelEnvironment.createEnvironment(transformationCS);
        for (ModelDeclCS modelDeclCS : transformationCS.getModelDecl()) {
            if (this.isCancelled()) continue;
            this.declareModelDeclCS(env, modelDeclCS);
        }
        for (QueryCS queryCS : transformationCS.getQuery()) {
            if (this.isCancelled()) continue;
            this.declareQueryCS(env, queryCS);
        }
        for (RelationCS relationCS : transformationCS.getRelation()) {
            if (this.isCancelled()) continue;
            this.declareRelationCS(env, relationCS);
        }
    }

    protected CollectionTemplateExp defineCollectionTemplateCS(IQVTrNodeEnvironment env, CollectionTemplateCS collectionTemplateCS) {
        IdentifierCS identifier = collectionTemplateCS.getIdentifier();
        Variable variable = null;
        try {
            variable = env.tryLookupVariable(this.identifierCS(identifier));
        }
        catch (LookupException e) {
            this.ERROR(identifier, "CollectionTemplateCS", env.formatLookupException(e));
        }
        CollectionTemplateExp collectionTemplateExp = QVTTemplateFactory.eINSTANCE.createCollectionTemplateExp();
        env.initASTMapping(collectionTemplateExp, (CSTNode)collectionTemplateCS);
        EClassifier referredClassifier = variable != null ? (EClassifier)variable.getType() : this.typeCS(collectionTemplateCS.getType(), (Environment)env);
        if (referredClassifier == null) {
            referredClassifier = (EClassifier)this.getOCLEnvironment().getOCLStandardLibrary().getOclVoid();
        }
        EClassifier elementType = null;
        if (referredClassifier instanceof CollectionType) {
            elementType = (EClassifier)((CollectionType)referredClassifier).getElementType();
        }
        if (elementType == null) {
            elementType = (EClassifier)this.getOCLEnvironment().getOCLStandardLibrary().getOclVoid();
        }
        for (IdentifiedCS headIdentifier : collectionTemplateCS.getMemberIdentifier()) {
            if (headIdentifier instanceof TemplateCS) {
                TemplateExp headExpr = this.defineTemplateCS(env, (TemplateCS)headIdentifier);
                collectionTemplateExp.getMember().add((Object)headExpr);
                continue;
            }
            Variable headVariable = env.createVariableDeclaration(headIdentifier.getIdentifier(), elementType);
            org.eclipse.ocl.ecore.VariableExp headVariableExp = oclEcoreFactory.createVariableExp();
            env.initASTMapping(headVariableExp, (CSTNode)headIdentifier);
            headVariableExp.setReferredVariable((org.eclipse.ocl.expressions.Variable)headVariable);
            headVariableExp.setType((Object)elementType);
            collectionTemplateExp.getMember().add((Object)headVariableExp);
        }
        IdentifierCS tailIdentifier = collectionTemplateCS.getRestIdentifier();
        if (tailIdentifier != null) {
            Variable tailVariable = env.createVariableDeclaration(tailIdentifier, referredClassifier);
            collectionTemplateExp.setRest(tailVariable);
            tailIdentifier.setAst((Object)tailVariable);
        }
        collectionTemplateExp.setName(this.identifierCS(identifier));
        collectionTemplateExp.setBindsTo(variable);
        CollectionType referredCollectionType = (CollectionType)ClassUtils.asClass((Object)referredClassifier, CollectionType.class);
        collectionTemplateExp.setType((Object)referredClassifier);
        collectionTemplateExp.setReferredCollectionType(referredCollectionType);
        return collectionTemplateExp;
    }

    protected void defineDomainCS(QVTrRelationEnvironment env, RelationDomain relationDomain, DomainCS domainCS) {
        RelationImplementation relationImplementation;
        OperationCallExpCS implementedByCS;
        QVTrDomainEnvironment domainEnv = env.getEnvironment(domainCS);
        DomainPattern domainPattern = QVTRelationFactory.eINSTANCE.createDomainPattern();
        env.initASTMapping(domainPattern, domainCS);
        relationDomain.setPattern(domainPattern);
        domainPattern.setTemplateExpression(this.defineTemplateCS(domainEnv, domainCS.getTemplate()));
        EList<DefaultValueCS> defaultValueCSs = domainCS.getDefaultValue();
        if (defaultValueCSs != null) {
            for (DefaultValueCS defaultValueCS : defaultValueCSs) {
                EClassifier initialiserType;
                IdentifierCS identifierCS = defaultValueCS.getIdentifier();
                String identifier = this.identifierCS(identifierCS);
                Variable variable = env.getVariable(identifier);
                if (variable == null) {
                    this.ERROR(identifierCS, "identifierCS", "Undefined variable '" + this.formatString(identifier) + "'");
                    continue;
                }
                EClassifier variableType = (EClassifier)variable.getType();
                org.eclipse.ocl.ecore.OCLExpression initExpression = this.oclExpressionCS(defaultValueCS.getInitialiser(), (Environment<EPackage, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, CallOperationAction, SendSignalAction, Constraint, EClass, EObject>)domainEnv);
                EClassifier eClassifier = initialiserType = initExpression != null ? (EClassifier)initExpression.getType() : null;
                if (initExpression instanceof CollectionLiteralExp && variableType instanceof CollectionType) {
                    CollectionLiteralExp collectionLiteral = (CollectionLiteralExp)initExpression;
                    CollectionType collectionElementType = (CollectionType)variableType;
                    EList parts = collectionLiteral.getPart();
                    if (parts == null || parts.size() <= 0) {
                        initialiserType = (EClassifier)this.getCollectionType((Environment)env, collectionLiteral.getKind(), (EClassifier)collectionElementType.getElementType());
                    }
                }
                RelationDomainAssignment defaultInitializer = QVTRelationFactory.eINSTANCE.createRelationDomainAssignment();
                env.initASTMapping(defaultInitializer, defaultValueCS);
                identifierCS.setAst((Object)defaultInitializer);
                defaultInitializer.setVariable(variable);
                defaultInitializer.setValueExp(initExpression);
                relationDomain.getDefaultAssignment().add((Object)defaultInitializer);
                if (this.assignableToFrom(variableType, initialiserType)) continue;
                this.ERROR(defaultValueCS, "defaultValueCS", "Incompatible initialiser type '" + this.formatType(initialiserType) + "' for variable type '" + this.formatType(variableType) + "'");
            }
        }
        if ((implementedByCS = domainCS.getImplementedBy()) != null && (relationImplementation = this.defineImplementedByCS(env, relationDomain.getTypedModel(), implementedByCS)) != null) {
            env.getRelation().getOperationalImpl().add((Object)relationImplementation);
        }
    }

    protected RelationImplementation defineImplementedByCS(QVTrRelationEnvironment env, TypedModel typedModel, OperationCallExpCS implementedByCS) {
        RelationImplementation relationImplementation = QVTRelationFactory.eINSTANCE.createRelationImplementation();
        env.initASTMapping(relationImplementation, (CSTNode)implementedByCS);
        relationImplementation.setInDirectionOf(typedModel);
        OCLExpression<EClassifier> exp = this.operationCallExpCS(implementedByCS, (Environment<EPackage, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, CallOperationAction, SendSignalAction, Constraint, EClass, EObject>)env);
        if (exp instanceof OperationCallExp) {
            OperationCallExp opCall = (OperationCallExp)exp;
            relationImplementation.setImpl((EOperation)opCall.getReferredOperation());
        }
        return relationImplementation;
    }

    protected List<TransformationCS> defineImportClauseCS(QVTrTopLevelEnvironment env, UnitCS unitCS) {
        CSTNode cstNode;
        block6: {
            String sourceFolder = this.getSourceFolder(env);
            StringBuffer fileName = new StringBuffer();
            for (IdentifierCS id : unitCS.getIdentifier()) {
                fileName.append(id.getValue());
                fileName.append(".");
            }
            String fileNameString = null;
            File file = null;
            String[] stringArray = QVTPreferences.getRelationTextExtensions();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String textExtension = stringArray[n2];
                fileNameString = String.valueOf(fileName.toString()) + textExtension;
                file = new File(sourceFolder, fileNameString);
                if (file.exists()) break;
                file = null;
                ++n2;
            }
            if (file == null) {
                this.ERROR(unitCS, "importClauseCS", "Failed to locate any file for '" + this.formatString(fileName.toString()) + "'");
                return null;
            }
            try {
                FileReader fileReader = new FileReader(file);
                QVTrLexer lexer = new QVTrLexer(env.getFileEnvironment());
                QVTrParser parser = new QVTrParser(lexer);
                lexer.setFileName(file.toString());
                lexer.initialize(fileReader);
                lexer.lexToTokens((AbstractParser)parser);
                cstNode = parser.parseTokensToCST();
                if (cstNode != null) break block6;
                return null;
            }
            catch (IOException e) {
                this.ERROR(unitCS, "importClauseCS", "Failed to import '" + this.formatString(fileNameString) + "' : " + e.getMessage());
                return null;
            }
        }
        EList<TransformationCS> importedTransformationCS = ((TopLevelCS)cstNode).getTransformation();
        return importedTransformationCS;
    }

    protected Key defineKeyDeclCS(QVTrTransformationEnvironment env, KeyDeclCS keyDeclCS) {
        Key key = QVTRelationFactory.eINSTANCE.createKey();
        env.initASTMapping(key, keyDeclCS);
        PathNameCS classId = keyDeclCS.getClassId();
        if (classId != null) {
            classId.setAst((Object)key);
        }
        EClass identifiedClass = this.resolveClass(env, "keyDeclCS", (TypeCS)classId);
        key.setIdentifies(identifiedClass);
        for (IdentifiedCS propertyIdCS : keyDeclCS.getPropertyId()) {
            propertyIdCS.setAst((Object)key);
            EStructuralFeature resolvedProperty = this.resolveForwardProperty(env, identifiedClass, "keyDeclCS", propertyIdCS);
            if (resolvedProperty != null) {
                key.getPart().add((Object)resolvedProperty);
            } else {
                resolvedProperty = this.resolveReverseProperty(env, identifiedClass, "keyDeclCS", propertyIdCS);
                if (resolvedProperty != null) {
                    key.getOppositePart().add((Object)((EReference)resolvedProperty));
                } else {
                    resolvedProperty = this.resolveUnresolvedProperty(env, identifiedClass, "keyDeclCS", propertyIdCS);
                    key.getPart().add((Object)resolvedProperty);
                }
            }
            propertyIdCS.getIdentifier().setAst((Object)resolvedProperty);
        }
        return key;
    }

    protected TemplateExp defineObjectTemplateCS(IQVTrNodeEnvironment env, ObjectTemplateCS templateCS) {
        EClassifier referredClassifier;
        IdentifierCS identifier = templateCS.getIdentifier();
        Variable variable = null;
        try {
            variable = env.tryLookupVariable(this.identifierCS(identifier));
        }
        catch (LookupException e) {
            this.ERROR(identifier, "ObjectTemplateCS", env.formatLookupException(e));
        }
        ObjectTemplateExp objectTemplate = QVTTemplateFactory.eINSTANCE.createObjectTemplateExp();
        env.initASTMapping(objectTemplate, (CSTNode)templateCS);
        CSTChildEnvironment.setNameFromIdentifier((ENamedElement)objectTemplate, (IdentifierCS)identifier);
        if (variable != null) {
            referredClassifier = (EClassifier)variable.getType();
            objectTemplate.setBindsTo(variable);
        } else {
            referredClassifier = this.typeCS(templateCS.getType(), (Environment)env);
        }
        if (referredClassifier == null) {
            referredClassifier = (EClassifier)this.getOCLEnvironment().getOCLStandardLibrary().getOclVoid();
        }
        EClass referredClass = (EClass)ClassUtils.asClass((Object)referredClassifier, EClass.class);
        objectTemplate.setType((Object)referredClassifier);
        objectTemplate.setReferredClass(referredClass);
        for (PropertyTemplateCS propertyTemplateCS : templateCS.getPropertyTemplate()) {
            PropertyTemplateItem item = this.definePropertyTemplateCS(env, referredClass, propertyTemplateCS);
            if (item == null) continue;
            objectTemplate.getPart().add((Object)item);
        }
        return objectTemplate;
    }

    protected void definePredicateCS(IQVTrNodeEnvironment env, Pattern pattern, List<OCLExpressionCS> oclExpressionCSlist) {
        for (OCLExpressionCS oclExpressionCS : oclExpressionCSlist) {
            Predicate predicate = QVTBaseFactory.eINSTANCE.createPredicate();
            env.initASTMapping(predicate, (CSTNode)oclExpressionCS);
            pattern.getPredicate().add((Object)predicate);
            predicate.setConditionExpression(this.definePredicateOCLExpressionCS(env, oclExpressionCS));
        }
    }

    protected org.eclipse.ocl.ecore.OCLExpression definePredicateOCLExpressionCS(IQVTrNodeEnvironment env, OCLExpressionCS oclExpressionCS) {
        Relation relation = this.isRelationCallExpCS(env, oclExpressionCS);
        if (relation == null) {
            return this.oclExpressionCS(oclExpressionCS, (Environment<EPackage, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, CallOperationAction, SendSignalAction, Constraint, EClass, EObject>)env);
        }
        RelationCallExp relationCallExp = QVTRelationFactory.eINSTANCE.createRelationCallExp();
        env.initASTMapping(relationCallExp, (CSTNode)oclExpressionCS);
        ((OperationCallExpCS)oclExpressionCS).getSimpleNameCS().setAst((Object)relationCallExp);
        relationCallExp.setReferredRelation(relation);
        relationCallExp.setType((Object)((EClassifier)this.getBoolean()));
        for (OCLExpressionCS argumentCS : ((OperationCallExpCS)oclExpressionCS).getArguments()) {
            org.eclipse.ocl.ecore.OCLExpression argument = this.oclExpressionCS(argumentCS, (Environment<EPackage, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, CallOperationAction, SendSignalAction, Constraint, EClass, EObject>)env);
            if (argument == null) continue;
            relationCallExp.getArgument().add((Object)argument);
        }
        return relationCallExp;
    }

    protected PropertyTemplateItem definePropertyTemplateCS(IQVTrNodeEnvironment env, EClass referredClass, PropertyTemplateCS propertyTemplateCS) {
        PropertyTemplateItem propertyTemplateItem = QVTTemplateFactory.eINSTANCE.createPropertyTemplateItem();
        env.initASTMapping(propertyTemplateItem, propertyTemplateCS);
        EStructuralFeature eStructuralFeature = propertyTemplateCS.getReferredProperty();
        IdentifiedCS propertyIdCS = propertyTemplateCS.getPropertyId();
        propertyIdCS.setAst((Object)propertyTemplateItem);
        propertyIdCS.getIdentifier().setAst((Object)eStructuralFeature);
        org.eclipse.ocl.ecore.OCLExpression oclExpression = this.oclExpressionCS(propertyTemplateCS.getOclExpression(), (Environment<EPackage, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, CallOperationAction, SendSignalAction, Constraint, EClass, EObject>)env);
        propertyTemplateItem.setReferredProperty(eStructuralFeature);
        boolean isOpposite = propertyTemplateCS.isOpposite();
        propertyTemplateItem.setIsOpposite(isOpposite);
        propertyTemplateItem.setValue(oclExpression);
        if (eStructuralFeature != null && oclExpression != null) {
            EClassifier featureType = (EClassifier)this.uml.getOCLType(isOpposite ? eStructuralFeature.getEContainingClass() : eStructuralFeature);
            featureType = (EClassifier)TypeUtil.resolveType((Environment)env, (Object)featureType);
            env.checkFeatureCompatibility((CSTNode)propertyIdCS, featureType, oclExpression);
        }
        return propertyTemplateItem;
    }

    protected Function defineQueryCS(QVTrQueryEnvironment env, QueryCS queryCS) {
        Function query = env.getQuery();
        if (query.getQueryExpression() == null) {
            query.setQueryExpression(this.oclExpressionCS(queryCS.getOclExpression(), (Environment<EPackage, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, CallOperationAction, SendSignalAction, Constraint, EClass, EObject>)env));
        }
        return query;
    }

    protected Relation defineRelationCS(QVTrRelationEnvironment env, RelationCS relationCS) {
        Pattern pattern;
        Relation relation = env.getRelation();
        relation.setIsTopLevel(relationCS.isTop());
        for (VarDeclarationCS varDeclarationCS : relationCS.getVarDeclaration()) {
            this.defineVarDeclarationCS(env, varDeclarationCS);
            varDeclarationCS.setAst(relation);
        }
        int i = 0;
        for (AbstractDomainCS abstractDomainCS : relationCS.getDomain()) {
            if (this.isCancelled()) {
                return relation;
            }
            if (!(abstractDomainCS instanceof DomainCS)) continue;
            DomainCS domainCS = (DomainCS)abstractDomainCS;
            QVTrDomainEnvironment domainEnv = env.getEnvironment(domainCS);
            TemplateCS templateCS = domainCS.getTemplate();
            Variable rootVariable = env.getVariable(templateCS.getIdentifier().getValue());
            EClassifier rootClassifier = rootVariable != null ? (EClassifier)rootVariable.getType() : null;
            this.declareTemplateCS(domainEnv, templateCS, rootClassifier);
        }
        WhenCS whenCS = relationCS.getWhen();
        WhereCS whereCS = relationCS.getWhere();
        if (whenCS != null && whenCS.getExpr().size() > 0) {
            for (OCLExpressionCS exprCS : whenCS.getExpr()) {
                this.declarePredicateCS(env, exprCS);
            }
        }
        if (whereCS != null && whereCS.getExpr().size() > 0) {
            for (OCLExpressionCS exprCS : whereCS.getExpr()) {
                this.declarePredicateCS(env, exprCS);
            }
        }
        env.createReferencedVariables(this);
        IdentifierCS overridesCS = relationCS.getOverrides();
        if (overridesCS != null) {
            String overridesId = this.identifierCS(overridesCS);
            Relation overrides = env.getRelation(null, overridesId);
            if (overrides != null) {
                relation.setOverrides((Rule)overrides);
            } else {
                this.ERROR(overridesCS, "relationCS", "Failed to locate overriden '" + overridesId + "'");
            }
        }
        i = 0;
        for (AbstractDomainCS domainCS : relationCS.getDomain()) {
            if (this.isCancelled()) {
                return relation;
            }
            RelationDomain domain = (RelationDomain)relation.getDomain().get(i++);
            if (!(domainCS instanceof DomainCS)) continue;
            this.defineDomainCS(env, domain, (DomainCS)domainCS);
        }
        if (whenCS != null && whenCS.getExpr().size() > 0) {
            pattern = QVTBaseFactory.eINSTANCE.createPattern();
            env.initASTMapping(pattern, whenCS);
            this.definePredicateCS(env, pattern, (List<OCLExpressionCS>)whenCS.getExpr());
            relation.setWhen(pattern);
        }
        if (whereCS != null && whereCS.getExpr().size() > 0) {
            pattern = QVTBaseFactory.eINSTANCE.createPattern();
            env.initASTMapping(pattern, whereCS);
            this.definePredicateCS(env, pattern, (List<OCLExpressionCS>)whereCS.getExpr());
            relation.setWhere(pattern);
        }
        return relation;
    }

    protected RelationCallExp defineRelationCallExpCS(IQVTrNodeEnvironment env, Relation relation, OperationCallExpCS operationCallExpCS) {
        RelationCallExp relationCallExp = QVTRelationFactory.eINSTANCE.createRelationCallExp();
        env.initASTMapping(relationCallExp, (CSTNode)operationCallExpCS);
        operationCallExpCS.getSimpleNameCS().setAst((Object)relationCallExp);
        relationCallExp.setReferredRelation(relation);
        relationCallExp.setType((Object)((EClassifier)this.getBoolean()));
        for (OCLExpressionCS argumentCS : operationCallExpCS.getArguments()) {
            org.eclipse.ocl.ecore.OCLExpression argument = this.oclExpressionCS(argumentCS, (Environment<EPackage, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, CallOperationAction, SendSignalAction, Constraint, EClass, EObject>)env);
            if (argument == null) continue;
            relationCallExp.getArgument().add((Object)argument);
        }
        return relationCallExp;
    }

    protected TemplateExp defineTemplateCS(IQVTrNodeEnvironment env, TemplateCS templateCS) {
        TemplateExp templateExp = null;
        if (templateCS instanceof ObjectTemplateCS) {
            templateExp = this.defineObjectTemplateCS(env, (ObjectTemplateCS)templateCS);
        } else if (templateCS instanceof CollectionTemplateCS) {
            templateExp = this.defineCollectionTemplateCS(env, (CollectionTemplateCS)templateCS);
        } else {
            this.ERROR(templateCS, "templateCS", "Unsupported " + this.formatClass(templateCS));
        }
        OCLExpressionCS guardCS = templateCS.getGuardExpression();
        if (templateExp != null && guardCS != null) {
            templateExp.setWhere(this.definePredicateOCLExpressionCS(env, guardCS));
        }
        return templateExp;
    }

    protected void defineTopLevelCS(QVTrTopLevelEnvironment topLevelEnvironment) {
        TopLevelCS topLevelCS = (TopLevelCS)topLevelEnvironment.getCSTNode();
        for (UnitCS unitCS : topLevelCS.getImportClause()) {
            if (this.isCancelled()) {
                return;
            }
            List<TransformationCS> transformationCSs = this.defineImportClauseCS(topLevelEnvironment, unitCS);
            if (transformationCSs == null) continue;
            topLevelCS.getTransformation().addAll(transformationCSs);
        }
        for (TransformationCS transformationCS : topLevelCS.getTransformation()) {
            if (this.isCancelled()) continue;
            this.declareTransformationCS(topLevelEnvironment, transformationCS);
        }
        for (TransformationCS transformationCS : topLevelCS.getTransformation()) {
            if (this.isCancelled()) continue;
            this.defineTransformationCS(topLevelEnvironment, transformationCS);
        }
    }

    protected void defineTransformationCS(QVTrTopLevelEnvironment topLevelEnvironment, TransformationCS transformationCS) {
        QVTrTransformationEnvironment env = topLevelEnvironment.getEnvironment(transformationCS);
        RelationalTransformation transformation = env.getRelationalTransformation();
        for (KeyDeclCS keyDeclCS : transformationCS.getKeyDecl()) {
            transformation.getOwnedKey().add((Object)this.defineKeyDeclCS(env, keyDeclCS));
        }
        for (QueryCS queryCS : transformationCS.getQuery()) {
            Function query;
            int pathSize;
            if (this.isCancelled()) {
                return;
            }
            EList pathName = queryCS.getPathName().getSequenceOfNames();
            if (pathName == null || (pathSize = pathName.size()) <= 0) continue;
            RelationalTransformation scope = transformation;
            if (pathSize > 1) {
                scope = topLevelEnvironment.getRelationalTransformation(pathName.subList(0, pathSize - 1));
            }
            if ((query = (Function)EcoreUtils.getNamedElement((Collection)scope.getEOperations(), (String)((String)pathName.get(pathSize - 1)), Function.class)) == null) continue;
            QVTrQueryEnvironment queryEnv = env.getEnvironment(queryCS);
            this.defineQueryCS(queryEnv, queryCS);
        }
        for (RelationCS relationCS : transformationCS.getRelation()) {
            if (this.isCancelled()) {
                return;
            }
            QVTrRelationEnvironment relationEnv = env.getEnvironment(relationCS);
            this.defineRelationCS(relationEnv, relationCS);
        }
    }

    protected void defineVarDeclarationCS(QVTrRelationEnvironment env, VarDeclarationCS varDeclarationCS) {
        TypeCS typeCS = varDeclarationCS.getType();
        EClassifier type = this.resolveClassifier(env, "varDeclarationCS", typeCS);
        for (IdentifierCS varDeclarationId : varDeclarationCS.getVarDeclarationId()) {
            env.createVariableDeclaration(varDeclarationId, type);
        }
    }

    protected String getSourceFolder(IQVTrNodeEnvironment env) {
        AbstractFileHandle file = env.getResolver().getHandle();
        URI uri = file != null ? file.getURI() : null;
        File currentFile = uri != null ? new File(uri.toFileString()) : null;
        return currentFile != null ? currentFile.getParent() : null;
    }

    protected org.eclipse.ocl.ecore.OCLExpression isQueryCallExpCS(IQVTrNodeEnvironment env, OCLExpressionCS oclExpressionCS) {
        if (!(oclExpressionCS instanceof OperationCallExpCS)) {
            return null;
        }
        OperationCallExpCS operationCallExpCS = (OperationCallExpCS)oclExpressionCS;
        if (operationCallExpCS.getAccessor() != DotOrArrowEnum.NONE_LITERAL) {
            return null;
        }
        String name = operationCallExpCS.getSimpleNameCS().getValue();
        if (name == null) {
            return null;
        }
        OCLExpressionCS source = operationCallExpCS.getSource();
        if (source != null) {
            return null;
        }
        ArrayList<org.eclipse.ocl.ecore.OCLExpression> args = new ArrayList<org.eclipse.ocl.ecore.OCLExpression>();
        for (OCLExpressionCS arg : operationCallExpCS.getArguments()) {
            org.eclipse.ocl.ecore.OCLExpression argExpr = this.oclExpressionCS(arg, (Environment<EPackage, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, CallOperationAction, SendSignalAction, Constraint, EClass, EObject>)env);
            if (argExpr == null) {
                return env.createInvalidLiteralExp((CSTNode)oclExpressionCS);
            }
            args.add(argExpr);
        }
        List<Function> queries = env.getQueries(name, args);
        if (queries == null || queries.size() == 0) {
            this.ERROR(oclExpressionCS, "QueryCallExpCS", "Unable to resolve query '" + this.formatString(name) + "' with matching signature");
            return env.createInvalidLiteralExp((CSTNode)oclExpressionCS);
        }
        if (queries.size() > 1) {
            this.ERROR(oclExpressionCS, "QueryCallExpCS", "Unable to resolve query '" + this.formatString(name) + "' unambiguously");
            return env.createInvalidLiteralExp((CSTNode)oclExpressionCS);
        }
        Function query = queries.get(0);
        OperationCallExp queryCall = oclEcoreFactory.createOperationCallExp();
        env.initASTMapping(queryCall, (CSTNode)oclExpressionCS);
        queryCall.setName(name);
        queryCall.setEType(query.getEType());
        queryCall.setReferredOperation((Object)query);
        queryCall.getArgument().addAll(args);
        return queryCall;
    }

    protected Relation isRelationCallExpCS(IQVTrNodeEnvironment env, OCLExpressionCS oclExpressionCS) {
        if (!(oclExpressionCS instanceof OperationCallExpCS)) {
            return null;
        }
        OperationCallExpCS operationCallExpCS = (OperationCallExpCS)oclExpressionCS;
        if (operationCallExpCS.getAccessor() == DotOrArrowEnum.ARROW_LITERAL) {
            return null;
        }
        String name = operationCallExpCS.getSimpleNameCS().getValue();
        OCLExpressionCS source = operationCallExpCS.getSource();
        EList pathName = null;
        if (source instanceof PathNameCS) {
            pathName = ((PathNameCS)source).getSequenceOfNames();
        }
        Relation relation = env.getRelation((List<String>)pathName, name);
        if (pathName != null && relation == null) {
            this.ERROR(oclExpressionCS, "RelationCallExpCS", "Unable to resolve relation '" + this.formatPath((List)pathName, name) + "'");
        }
        return relation;
    }

    protected org.eclipse.ocl.ecore.OCLExpression oclExpressionCS(OCLExpressionCS oclExpressionCS, Environment<EPackage, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, CallOperationAction, SendSignalAction, Constraint, EClass, EObject> env) {
        IQVTrNodeEnvironment exprEnv = (IQVTrNodeEnvironment)env;
        org.eclipse.ocl.ecore.OCLExpression oclExpression = null;
        try {
            if (oclExpressionCS instanceof TemplateCS) {
                return this.defineTemplateCS((IQVTrNodeEnvironment)env, (TemplateCS)oclExpressionCS);
            }
            Relation relation = this.isRelationCallExpCS(exprEnv, oclExpressionCS);
            if (relation != null) {
                return this.defineRelationCallExpCS(exprEnv, relation, (OperationCallExpCS)oclExpressionCS);
            }
            oclExpression = (org.eclipse.ocl.ecore.OCLExpression)super.oclExpressionCS(oclExpressionCS, (Environment)exprEnv);
            if (oclExpression != null) {
                return oclExpression;
            }
        }
        catch (Exception e) {
            this.ERROR(oclExpressionCS, "oclExpressionCS", "Failed to parse expression : " + e.getClass().getName() + " - " + e.getMessage());
            e.printStackTrace();
            oclExpression = ((IQVTrNodeEnvironment)env).createInvalidLiteralExp((CSTNode)oclExpressionCS);
        }
        return oclExpression;
    }

    protected OCLExpression<EClassifier> operationCallExpCS(OperationCallExpCS operationCallExpCS, Environment<EPackage, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, CallOperationAction, SendSignalAction, Constraint, EClass, EObject> env) {
        org.eclipse.ocl.ecore.OCLExpression queryCall = this.isQueryCallExpCS((IQVTrNodeEnvironment)env, (OCLExpressionCS)operationCallExpCS);
        if (queryCall != null) {
            if (queryCall instanceof OperationCallExp) {
                this.checkAndSetAst((ICSTEnvironment)env, (CSTNode)operationCallExpCS.getSimpleNameCS(), (EObject)((OperationCallExp)queryCall).getReferredOperation());
            }
            return queryCall;
        }
        return super.operationCallExpCS(operationCallExpCS, env);
    }

    protected EClassifier resolveProperty(QVTrDomainEnvironment env, EClass parentType, PropertyTemplateCS propertyTemplateCS) {
        IdentifiedCS propertyIdCS = propertyTemplateCS.getPropertyId();
        EClassifier propertyType = null;
        EStructuralFeature resolvedProperty = this.resolveForwardProperty(env, parentType, "propertyTemplateCS", propertyIdCS);
        if (resolvedProperty != null) {
            propertyTemplateCS.setReferredProperty(resolvedProperty);
            propertyType = (EClassifier)this.uml.getOCLType((Object)resolvedProperty);
        } else {
            resolvedProperty = this.resolveReverseProperty(env, parentType, "propertyTemplateCS", propertyIdCS);
            if (resolvedProperty != null) {
                propertyTemplateCS.setReferredProperty(resolvedProperty);
                propertyTemplateCS.setOpposite(true);
                propertyType = (EClassifier)this.uml.getOCLType((Object)resolvedProperty.getEContainingClass());
            } else {
                resolvedProperty = this.resolveUnresolvedProperty(env, parentType, "propertyTemplateCS", propertyIdCS);
                propertyTemplateCS.setReferredProperty(resolvedProperty);
                propertyType = (EClassifier)this.uml.getOCLType((Object)resolvedProperty);
            }
        }
        propertyType = (EClassifier)TypeUtil.resolveType((Environment)env, (Object)propertyType);
        if (propertyType instanceof CollectionType && env.getASTMapping(propertyType) == null) {
            this.initASTMapping((Environment)env, propertyType, propertyTemplateCS);
        } else {
            propertyTemplateCS.setAst(propertyType);
        }
        return propertyType;
    }

    protected PropertyCallExp<EClassifier, EStructuralFeature> simplePropertyName(SimpleNameCS simpleNameCS, Environment<EPackage, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, CallOperationAction, SendSignalAction, Constraint, EClass, EObject> env, OCLExpression<EClassifier> source, EClassifier sourceElementType, String simpleName) {
        EReference property;
        PropertyCallExp propertyCall = super.simplePropertyName(simpleNameCS, env, source, sourceElementType, simpleName);
        if (propertyCall != null) {
            return propertyCall;
        }
        if (!(sourceElementType instanceof EClass)) {
            return null;
        }
        try {
            property = ((IQVTrNodeEnvironment)env).tryLookupOppositeProperty((EClass)sourceElementType, simpleName);
        }
        catch (LookupException e) {
            this.ERROR(simpleNameCS, "SimpleNameCS", ((IQVTrNodeEnvironment)env).formatLookupException(e));
            List matches = e.getAmbiguousMatches();
            if (matches.isEmpty()) {
                return null;
            }
            property = (EStructuralFeature)matches.get(0);
        }
        if (property == null) {
            return null;
        }
        this.TRACE("variableExpCS", "Property: " + simpleName);
        propertyCall = QVTRelationFactory.eINSTANCE.createOppositePropertyCallExp();
        this.initASTMapping(env, propertyCall, (CSTNode)simpleNameCS);
        propertyCall.setReferredProperty((Object)property);
        EClassifier resolvedSetType = (EClassifier)TypeUtil.resolveSetType(env, (Object)property.getEContainingClass());
        if (resolvedSetType != null) {
            ((IQVTrNodeEnvironment)env).getASTNodeToCSTNodeMap().put(resolvedSetType, simpleNameCS);
        }
        propertyCall.setType((Object)resolvedSetType);
        if (source != null) {
            propertyCall.setSource(source);
        } else {
            org.eclipse.ocl.expressions.Variable var = env.lookupImplicitSourceForProperty(simpleName);
            VariableExp<EClassifier, EParameter> result = this.createVariableExp(env, (CSTNode)simpleNameCS, (org.eclipse.ocl.expressions.Variable<EClassifier, EParameter>)var);
            propertyCall.setSource(result);
        }
        this.initPropertyPositions((CallingASTNode)propertyCall, (CSTNode)simpleNameCS);
        return propertyCall;
    }
}

