/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.wizards;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.imp.builder.ProjectNatureBase;
import org.eclipse.imp.wizards.NewProjectWizardFirstPage;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jdt.internal.ui.util.CoreUtility;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.internal.ui.wizards.ClassPathDetector;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMInstall2;
import org.eclipse.jdt.launching.IVMInstallType;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.ui.PreferenceConstants;
import org.eclipse.jdt.ui.wizards.JavaCapabilityConfigurationPage;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.WorkspaceModifyDelegatingOperation;

public abstract class NewProjectWizardSecondPage
extends JavaCapabilityConfigurationPage {
    private static final String FILENAME_PROJECT = ".project";
    private static final String FILENAME_CLASSPATH = ".classpath";
    private final NewProjectWizardFirstPage fFirstPage;
    private URI fCurrProjectLocation;
    private IProject fCurrProject;
    private boolean fKeepContent;
    private File fDotProjectBackup;
    private File fDotClasspathBackup;
    private Boolean fIsAutobuild = null;

    protected abstract ProjectNatureBase getProjectNature();

    protected abstract IPath getLanguageRuntimePath();

    public NewProjectWizardSecondPage(NewProjectWizardFirstPage firstPage) {
        this.fFirstPage = firstPage;
    }

    public void performFinish(IProgressMonitor monitor) throws CoreException, InterruptedException {
        try {
            monitor.beginTask("Creating project...", 3);
            if (this.fCurrProject == null) {
                this.updateProject((IProgressMonitor)new SubProgressMonitor(monitor, 1));
            }
            this.configureJavaProject((IProgressMonitor)new SubProgressMonitor(monitor, 2));
            String compliance = this.fFirstPage.getJRECompliance();
            if (compliance != null) {
                IJavaProject project = JavaCore.create((IProject)this.fCurrProject);
                Map options = project.getOptions(false);
                JavaModelUtil.setCompilanceOptions((Map)options, (String)compliance);
                project.setOptions(options);
            }
        }
        finally {
            monitor.done();
            this.fCurrProject = null;
            if (this.fIsAutobuild != null) {
                CoreUtility.enableAutoBuild((boolean)this.fIsAutobuild);
                this.fIsAutobuild = null;
            }
        }
    }

    public void setVisible(boolean visible) {
        if (visible) {
            IStatus status = this.changeToNewProject();
            if (status != null && !status.isOK()) {
                ErrorDialog.openError((Shell)this.getShell(), (String)"New Java Project", null, (IStatus)status);
            }
        } else {
            this.removeProject();
        }
        super.setVisible(visible);
        if (visible) {
            this.setFocus();
        }
    }

    private IStatus changeToNewProject() {
        this.fKeepContent = this.fFirstPage.getDetect();
        class UpdateRunnable
        implements IRunnableWithProgress {
            public IStatus infoStatus = Status.OK_STATUS;

            UpdateRunnable() {
            }

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    try {
                        if (NewProjectWizardSecondPage.this.fIsAutobuild == null) {
                            NewProjectWizardSecondPage.this.fIsAutobuild = CoreUtility.enableAutoBuild((boolean)false);
                        }
                        this.infoStatus = NewProjectWizardSecondPage.this.updateProject(monitor);
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                    catch (OperationCanceledException operationCanceledException) {
                        throw new InterruptedException();
                    }
                }
                finally {
                    monitor.done();
                }
            }
        }
        UpdateRunnable op = new UpdateRunnable();
        try {
            this.getContainer().run(true, false, (IRunnableWithProgress)new WorkspaceModifyDelegatingOperation((IRunnableWithProgress)op));
            return op.infoStatus;
        }
        catch (InvocationTargetException e) {
            ExceptionHandler.handle((InvocationTargetException)e, (Shell)this.getShell(), (String)"New Java Project", (String)"An error occurred while creating project. Check log for details.");
        }
        catch (InterruptedException interruptedException) {}
        return null;
    }

    final IStatus updateProject(IProgressMonitor monitor) throws CoreException, InterruptedException {
        IStatus result = StatusInfo.OK_STATUS;
        this.fCurrProject = this.fFirstPage.getProjectHandle();
        this.fCurrProjectLocation = this.getProjectLocationURI();
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            monitor.beginTask("Initializing project...", 7);
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            URI realLocation = this.fCurrProjectLocation;
            if (this.fCurrProjectLocation == null) {
                try {
                    URI rootLocation = ResourcesPlugin.getWorkspace().getRoot().getLocationURI();
                    realLocation = new URI(rootLocation.getScheme(), null, Path.fromPortableString((String)rootLocation.getPath()).append(this.fCurrProject.getName()).toString(), null);
                }
                catch (URISyntaxException uRISyntaxException) {
                    Assert.isTrue((boolean)false, (String)"Can't happen");
                }
            }
            this.rememberExistingFiles(realLocation);
            try {
                NewProjectWizardSecondPage.createProject((IProject)this.fCurrProject, (URI)this.fCurrProjectLocation, (IProgressMonitor)new SubProgressMonitor(monitor, 2));
            }
            catch (CoreException e) {
                if (e.getStatus().getCode() == 567) {
                    result = new StatusInfo(1, Messages.format((String)"A problem occurred while creating the project from existing source:\n\n''{0}''\n\nThe corrupt project file will be replaced by a valid one.", (Object)e.getLocalizedMessage()));
                    this.deleteProjectFile(realLocation);
                    if (this.fCurrProject.exists()) {
                        this.fCurrProject.delete(true, null);
                    }
                    NewProjectWizardSecondPage.createProject((IProject)this.fCurrProject, (URI)this.fCurrProjectLocation, null);
                }
                throw e;
            }
            IClasspathEntry[] entries = null;
            IPath outputLocation = null;
            if (this.fFirstPage.getDetect()) {
                if (!this.fCurrProject.getFile(FILENAME_CLASSPATH).exists()) {
                    ClassPathDetector detector = new ClassPathDetector(this.fCurrProject, (IProgressMonitor)new SubProgressMonitor(monitor, 2));
                    entries = detector.getClasspath();
                    outputLocation = detector.getOutputLocation();
                } else {
                    monitor.worked(2);
                }
            } else if (this.fFirstPage.isSrcBin()) {
                IFolder folder;
                IPreferenceStore store = PreferenceConstants.getPreferenceStore();
                Path srcPath = new Path(store.getString("org.eclipse.jdt.ui.wizards.srcBinFoldersSrcName"));
                Path binPath = new Path(store.getString("org.eclipse.jdt.ui.wizards.srcBinFoldersBinName"));
                if (srcPath.segmentCount() > 0) {
                    folder = this.fCurrProject.getFolder((IPath)srcPath);
                    CoreUtility.createFolder((IFolder)folder, (boolean)true, (boolean)true, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                } else {
                    monitor.worked(1);
                }
                if (binPath.segmentCount() > 0 && !binPath.equals((Object)srcPath)) {
                    folder = this.fCurrProject.getFolder((IPath)binPath);
                    CoreUtility.createDerivedFolder((IFolder)folder, (boolean)true, (boolean)true, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                } else {
                    monitor.worked(1);
                }
                IPath projectPath = this.fCurrProject.getFullPath();
                ArrayList<IClasspathEntry> cpEntries = new ArrayList<IClasspathEntry>();
                cpEntries.add(JavaCore.newSourceEntry((IPath)projectPath.append((IPath)srcPath)));
                cpEntries.addAll((Collection)Arrays.asList(this.getDefaultClasspathEntry()));
                entries = cpEntries.toArray(new IClasspathEntry[cpEntries.size()]);
                outputLocation = projectPath.append((IPath)binPath);
            } else {
                IPath projectPath = this.fCurrProject.getFullPath();
                ArrayList<IClasspathEntry> cpEntries = new ArrayList<IClasspathEntry>();
                cpEntries.add(JavaCore.newSourceEntry((IPath)projectPath));
                cpEntries.addAll((Collection)Arrays.asList(this.getDefaultClasspathEntry()));
                entries = cpEntries.toArray(new IClasspathEntry[cpEntries.size()]);
                outputLocation = projectPath;
                monitor.worked(2);
            }
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            this.init(JavaCore.create((IProject)this.fCurrProject), outputLocation, entries, false);
            this.configureJavaProject((IProgressMonitor)new SubProgressMonitor(monitor, 3));
            this.getProjectNature().addToProject(this.fCurrProject);
        }
        finally {
            monitor.done();
        }
        return result;
    }

    private URI getProjectLocationURI() throws CoreException {
        if (this.fFirstPage.isInWorkspace()) {
            return null;
        }
        return URIUtil.toURI((IPath)this.fFirstPage.getLocationPath());
    }

    private void deleteProjectFile(URI projectLocation) throws CoreException {
        IFileStore projectFile;
        IFileStore file = EFS.getStore((URI)projectLocation);
        if (file.fetchInfo().exists() && (projectFile = file.getChild(FILENAME_PROJECT)).fetchInfo().exists()) {
            projectFile.delete(0, null);
        }
    }

    private void rememberExistingFiles(URI projectLocation) throws CoreException {
        this.fDotProjectBackup = null;
        this.fDotClasspathBackup = null;
        IFileStore file = EFS.getStore((URI)projectLocation);
        if (file.fetchInfo().exists()) {
            IFileStore classpathFile;
            IFileStore projectFile = file.getChild(FILENAME_PROJECT);
            if (projectFile.fetchInfo().exists()) {
                this.fDotProjectBackup = this.createBackup(projectFile, "project-desc");
            }
            if ((classpathFile = file.getChild(FILENAME_CLASSPATH)).fetchInfo().exists()) {
                this.fDotClasspathBackup = this.createBackup(classpathFile, "classpath-desc");
            }
        }
    }

    private void restoreExistingFiles(URI projectLocation, IProgressMonitor monitor) throws CoreException {
        int ticks = ((this.fDotProjectBackup != null ? 1 : 0) + (this.fDotClasspathBackup != null ? 1 : 0)) * 2;
        monitor.beginTask("", ticks);
        try {
            IFileStore projectFile = EFS.getStore((URI)projectLocation).getChild(FILENAME_PROJECT);
            projectFile.delete(0, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            if (this.fDotProjectBackup != null) {
                this.copyFile(this.fDotProjectBackup, projectFile, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            }
        }
        catch (IOException e) {
            Status status = new Status(4, "org.eclipse.jdt.ui", 4, "Problem while restoring backup for .project", (Throwable)e);
            throw new CoreException((IStatus)status);
        }
        try {
            IFileStore classpathFile = EFS.getStore((URI)projectLocation).getChild(FILENAME_CLASSPATH);
            classpathFile.delete(0, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            if (this.fDotClasspathBackup != null) {
                this.copyFile(this.fDotClasspathBackup, classpathFile, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            }
        }
        catch (IOException e) {
            Status status = new Status(4, "org.eclipse.jdt.ui", 4, "Problem while restoring backup for .classpath", (Throwable)e);
            throw new CoreException((IStatus)status);
        }
    }

    private File createBackup(IFileStore source, String name) throws CoreException {
        try {
            File bak = File.createTempFile("eclipse-" + name, ".bak");
            this.copyFile(source, bak);
            return bak;
        }
        catch (IOException e) {
            Status status = new Status(4, "org.eclipse.jdt.ui", 4, Messages.format((String)"Problem while creating backup for ''{0}''", (Object)name), (Throwable)e);
            throw new CoreException((IStatus)status);
        }
    }

    private void copyFile(IFileStore source, File target) throws IOException, CoreException {
        InputStream is = source.openInputStream(0, null);
        FileOutputStream os = new FileOutputStream(target);
        this.copyFile(is, os);
    }

    private void copyFile(File source, IFileStore target, IProgressMonitor monitor) throws IOException, CoreException {
        FileInputStream is = new FileInputStream(source);
        OutputStream os = target.openOutputStream(0, monitor);
        this.copyFile(is, os);
    }

    private void copyFile(InputStream is, OutputStream os) throws IOException {
        try {
            int bytesRead;
            byte[] buffer = new byte[8192];
            while ((bytesRead = is.read(buffer)) != -1) {
                os.write(buffer, 0, bytesRead);
            }
        }
        finally {
            try {
                is.close();
            }
            finally {
                os.close();
            }
        }
    }

    private IClasspathEntry[] getDefaultClasspathEntry() {
        IPath langRuntimePath = this.getLanguageRuntimePath();
        IClasspathEntry langRuntimeCPE = JavaCore.newVariableEntry((IPath)langRuntimePath, null, null);
        String compliance = this.fFirstPage.getJRECompliance();
        IVMInstall inst = this.findMatchingJREInstall(compliance);
        Path jreContainerPath = new Path(JavaRuntime.JRE_CONTAINER);
        if (inst != null) {
            IPath newPath = jreContainerPath.append(inst.getVMInstallType().getId()).append(inst.getName());
            return new IClasspathEntry[]{langRuntimeCPE, JavaCore.newContainerEntry((IPath)newPath)};
        }
        IClasspathEntry[] defaultJRELibrary = PreferenceConstants.getDefaultJRELibrary();
        IClasspathEntry[] allEntries = new IClasspathEntry[defaultJRELibrary.length + 1];
        System.arraycopy(defaultJRELibrary, 0, allEntries, 0, defaultJRELibrary.length);
        allEntries[allEntries.length - 1] = langRuntimeCPE;
        return allEntries;
    }

    private IVMInstall findMatchingJREInstall(String compliance) {
        IVMInstallType vmInstallType = JavaRuntime.getVMInstallTypes()[0];
        IVMInstall[] vmInstalls = vmInstallType.getVMInstalls();
        int i = 0;
        while (i < vmInstalls.length) {
            IVMInstall2 vmInstall2;
            String vmVers;
            if (vmInstalls[i] instanceof IVMInstall2 && (vmVers = (vmInstall2 = (IVMInstall2)vmInstalls[i]).getJavaVersion()).startsWith(compliance)) {
                return vmInstalls[i];
            }
            ++i;
        }
        return null;
    }

    private void removeProject() {
        if (this.fCurrProject == null || !this.fCurrProject.exists()) {
            return;
        }
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                NewProjectWizardSecondPage.this.doRemoveProject(monitor);
            }
        };
        try {
            this.getContainer().run(true, true, (IRunnableWithProgress)new WorkspaceModifyDelegatingOperation(op));
        }
        catch (InvocationTargetException e) {
            ExceptionHandler.handle((InvocationTargetException)e, (Shell)this.getShell(), (String)"Error Creating Java Project", (String)"An error occurred while removing a temporary project.");
        }
        catch (InterruptedException interruptedException) {}
    }

    final void doRemoveProject(IProgressMonitor monitor) throws InvocationTargetException {
        boolean noProgressMonitor;
        boolean bl = noProgressMonitor = this.fCurrProjectLocation == null;
        if (monitor == null || noProgressMonitor) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask("Removing project...", 3);
        try {
            try {
                try {
                    URI projLoc = this.fCurrProject.getLocationURI();
                    boolean removeContent = !this.fKeepContent && this.fCurrProject.isSynchronized(2);
                    this.fCurrProject.delete(removeContent, false, (IProgressMonitor)new SubProgressMonitor(monitor, 2));
                    this.restoreExistingFiles(projLoc, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                }
                finally {
                    CoreUtility.enableAutoBuild((boolean)this.fIsAutobuild);
                    this.fIsAutobuild = null;
                }
            }
            catch (CoreException e) {
                throw new InvocationTargetException(e);
            }
        }
        finally {
            monitor.done();
            this.fCurrProject = null;
            this.fKeepContent = false;
        }
    }
}

