/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.runtime;

import org.eclipse.imp.language.LanguageRegistry;
import org.eclipse.imp.preferences.PreferenceCache;
import org.eclipse.imp.runtime.ImageDescriptorRegistry;
import org.eclipse.imp.runtime.PluginBase;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.FontRegistry;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IStartup;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class RuntimePlugin
extends PluginBase
implements IStartup {
    public static final String IMP_RUNTIME = "org.eclipse.imp.runtime";
    public static String LANGUAGE_DESCRIPTOR = "languageDescription";
    private FontRegistry fFontRegistry;
    private static RuntimePlugin sPlugin;
    private ImageDescriptorRegistry fImageDescriptorRegistry;

    public RuntimePlugin() {
        sPlugin = this;
    }

    public static RuntimePlugin getInstance() {
        return sPlugin;
    }

    public String getID() {
        return IMP_RUNTIME;
    }

    public FontRegistry getFontRegistry() {
        if (this.fFontRegistry == null) {
            this.fFontRegistry = new FontRegistry();
        }
        return this.fFontRegistry;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        IPreferenceStore prefStore = this.getPreferenceStore();
        PreferenceCache.emitMessages = prefStore.getBoolean("emitMessages");
        PreferenceCache.tabWidth = prefStore.getInt("tabWidth");
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        sPlugin = null;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)IMP_RUNTIME, (String)path);
    }

    private synchronized ImageDescriptorRegistry internalGetImageDescriptorRegistry() {
        if (this.fImageDescriptorRegistry == null) {
            this.fImageDescriptorRegistry = new ImageDescriptorRegistry();
        }
        return this.fImageDescriptorRegistry;
    }

    public static ImageDescriptorRegistry getImageDescriptorRegistry() {
        return RuntimePlugin.getInstance().internalGetImageDescriptorRegistry();
    }

    public void earlyStartup() {
        LanguageRegistry.initializeRegistryAsNeeded();
    }
}

