/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.runtime;

import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.imp.preferences.PreferencesService;
import org.eclipse.imp.runtime.IPluginLog;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public abstract class PluginBase
extends AbstractUIPlugin
implements IPluginLog {
    private ILog sLog = null;
    protected boolean fEmitInfoMessages = false;
    protected static PreferencesService preferencesService = null;

    public abstract String getID();

    public void maybeWriteInfoMsg(String msg) {
        if (!this.fEmitInfoMessages) {
            return;
        }
        if (msg == null) {
            msg = "No message given";
        }
        this.writeInfoMsg(msg);
    }

    public void writeInfoMsg(String msg) {
        if (msg == null) {
            msg = "No message given";
        }
        Status status = new Status(1, this.getID(), 0, msg, null);
        if (this.sLog == null) {
            this.sLog = this.getLog();
        }
        this.sLog.log((IStatus)status);
    }

    public void writeErrorMsg(String msg) {
        if (msg == null) {
            msg = "No message given";
        }
        Status status = new Status(4, this.getID(), 0, msg, null);
        if (this.sLog == null) {
            this.sLog = this.getLog();
        }
        this.sLog.log((IStatus)status);
    }

    public void logException(String msg, Throwable t) {
        if (msg == null) {
            msg = t == null || t.getMessage() == null ? "No message given" : t.getMessage();
        }
        Status status = new Status(4, this.getID(), 0, msg, t);
        if (this.sLog == null) {
            this.sLog = this.getLog();
        }
        this.sLog.log((IStatus)status);
    }

    public void refreshPrefs() {
    }

    public static PreferencesService getPreferencesService() {
        if (preferencesService == null) {
            preferencesService = new PreferencesService(ResourcesPlugin.getWorkspace().getRoot().getProject());
        }
        return preferencesService;
    }
}

