/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.preferences.fields;

import org.eclipse.imp.preferences.IPreferencesService;
import org.eclipse.imp.preferences.PreferencesTab;
import org.eclipse.imp.preferences.fields.StringFieldEditor;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;

public class IntegerFieldEditor
extends StringFieldEditor {
    protected int minValidValue = 0;
    protected int maxValidValue = Integer.MAX_VALUE;
    protected static final int DEFAULT_TEXT_LIMIT = 10;
    protected String errorMessage = "Value must be an integer between " + this.minValidValue + " and " + this.maxValidValue;

    public IntegerFieldEditor(PreferencePage page, PreferencesTab tab, IPreferencesService service, String level, String name, String labelText, int width, int strategy, Composite parent) {
        super(page, tab, service, level, name, labelText, width, strategy, parent);
    }

    public IntegerFieldEditor(PreferencePage page, PreferencesTab tab, IPreferencesService service, String level, String name, String labelText, int width, Composite parent) {
        super(page, tab, service, level, name, labelText, width, 0, parent);
    }

    public IntegerFieldEditor(PreferencePage page, PreferencesTab tab, IPreferencesService service, String level, String name, String labelText, Composite parent) {
        super(page, tab, service, level, name, labelText, 10, parent);
    }

    public void setValidRange(int min, int max) {
        this.minValidValue = min;
        this.maxValidValue = max;
    }

    public int getIntValue() throws NumberFormatException {
        return new Integer(this.getStringValue());
    }

    protected boolean checkState() {
        block4: {
            Text text = this.getTextControl(this.parent);
            if (text == null) {
                return false;
            }
            String numberString = text.getText();
            try {
                int number = Integer.valueOf(numberString);
                if (number < this.minValidValue || number > this.maxValidValue) break block4;
                this.clearErrorMessage();
                return true;
            }
            catch (NumberFormatException numberFormatException) {
                this.setErrorMessage(String.valueOf(this.getLevelName()) + ":  " + this.getLabelText() + "  " + "Number format exception");
                return false;
            }
        }
        this.setErrorMessage(String.valueOf(this.getLevelName()) + ":  " + this.getLabelText() + "  " + this.errorMessage);
        return false;
    }

    public String getLevelName() {
        if (this.preferencesLevel.equals("default")) {
            return "Default";
        }
        if (this.preferencesLevel.equals("configuration")) {
            return "Configuration";
        }
        if (this.preferencesLevel.equals("instance")) {
            return "Workspace";
        }
        if (this.preferencesLevel.equals("project")) {
            return "Project";
        }
        return "";
    }
}

