/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.engine.emfvm;

import org.eclipse.m2m.atl.engine.emfvm.Messages;
import org.eclipse.m2m.atl.engine.emfvm.VMException;

public class Bytecode {
    public static final int PUSH = 0;
    public static final int PUSHI = 1;
    public static final int PUSHD = 2;
    public static final int PUSHT = 3;
    public static final int PUSHF = 4;
    public static final int CALL = 5;
    public static final int LOAD = 6;
    public static final int STORE = 7;
    public static final int NEW = 8;
    public static final int ITERATE = 9;
    public static final int ENDITERATE = 10;
    public static final int DUP = 11;
    public static final int SET = 12;
    public static final int GET = 13;
    public static final int POP = 14;
    public static final int GETASM = 15;
    public static final int IF = 16;
    public static final int GOTO = 17;
    public static final int SWAP = 18;
    public static final int FINDME = 19;
    public static final int DUP_X1 = 20;
    public static final int DELETE = 21;
    public static final int PCALL = 22;
    public static final int NEWIN = 23;
    public static final String[] OPCODENAMES = new String[]{"push", "pushi", "pushd", "pusht", "pushf", "call", "load", "store", "new", "iterate", "enditerate", "dup", "set", "get", "pop", "getasm", "if", "goto", "swap", "findme", "dup_x1", "delete", "pcall", "newin"};
    private int opcode;
    private Object operand;
    private int value;
    private int value2;
    private String completeOperand;

    public Bytecode(String opcode) {
        if (opcode.equals("pusht")) {
            this.opcode = 3;
        } else if (opcode.equals("pushf")) {
            this.opcode = 4;
        } else if (opcode.equals("new")) {
            this.opcode = 8;
        } else if (opcode.equals("newin")) {
            this.opcode = 23;
        } else if (opcode.equals("iterate")) {
            this.opcode = 9;
        } else if (opcode.equals("enditerate")) {
            this.opcode = 10;
        } else if (opcode.equals("dup")) {
            this.opcode = 11;
        } else if (opcode.equals("pop")) {
            this.opcode = 14;
        } else if (opcode.equals("getasm")) {
            this.opcode = 15;
        } else if (opcode.equals("swap")) {
            this.opcode = 18;
        } else if (opcode.equals("findme")) {
            this.opcode = 19;
        } else if (opcode.equals("dup_x1")) {
            this.opcode = 20;
        } else if (opcode.equals("delete")) {
            this.opcode = 21;
        } else {
            throw new VMException(null, Messages.getString("ByteCode.UNSUPPORTEDOPCODEWOARGS", opcode));
        }
    }

    public Bytecode(String opcode, String operand) {
        if (opcode.equals("push")) {
            this.opcode = 0;
            this.operand = operand;
        } else if (opcode.equals("pushi")) {
            this.opcode = 1;
            this.operand = Integer.valueOf(operand);
        } else if (opcode.equals("pushd")) {
            this.opcode = 2;
            this.operand = Double.valueOf(operand);
        } else if (opcode.equals("call")) {
            this.opcode = 5;
            this.completeOperand = operand;
            this.operand = Bytecode.getOpName(operand);
            this.value = Bytecode.getNbArgs(operand);
        } else if (opcode.equals("load")) {
            this.opcode = 6;
            this.operand = operand;
            this.value = Integer.parseInt(operand);
        } else if (opcode.equals("store")) {
            this.opcode = 7;
            this.operand = operand;
            this.value = Integer.parseInt(operand);
        } else if (opcode.equals("set")) {
            this.opcode = 12;
            this.operand = operand;
        } else if (opcode.equals("get")) {
            this.opcode = 13;
            this.operand = operand;
        } else if (opcode.equals("if")) {
            this.opcode = 16;
            this.operand = operand;
            this.value = Integer.parseInt(operand);
        } else if (opcode.equals("goto")) {
            this.opcode = 17;
            this.operand = operand;
            this.value = Integer.parseInt(operand);
        } else if (opcode.equals("pcall")) {
            this.opcode = 22;
            this.completeOperand = operand;
            this.operand = Bytecode.getOpName(operand);
            this.value = Bytecode.getNbArgs(operand);
        } else {
            throw new VMException(null, Messages.getString("ByteCode.UNSUPPORTEDOPCODEWARGS", opcode));
        }
    }

    public String toString() {
        return String.valueOf(OPCODENAMES[this.opcode]) + (this.completeOperand != null ? " " + this.completeOperand : (this.operand != null ? " " + this.operand : ""));
    }

    private static int getNbArgs(String s) {
        int ret = 0;
        String tmp = s;
        tmp = tmp.replaceFirst("^.*\\(", "");
        while (!tmp.startsWith(")")) {
            ++ret;
            tmp = Bytecode.removeFirst(tmp);
        }
        return ret;
    }

    private static String removeFirst(String s) {
        String simple = "^J|I|B|S|D|A|(M|N)[^;]*;|L";
        String tmp = s;
        if (s.startsWith("T")) {
            tmp = tmp.substring(1);
            while (!tmp.startsWith(";")) {
                tmp = Bytecode.removeFirst(tmp);
            }
            tmp = tmp.substring(1);
        } else {
            tmp = tmp.matches("^(Q|G|C|E|O).*") ? Bytecode.removeFirst(s.substring(1)) : tmp.replaceFirst(simple, "");
        }
        return tmp;
    }

    private static String getOpName(String s) {
        return s.substring(s.indexOf(".") + 1, s.indexOf("("));
    }

    public int getOpcode() {
        return this.opcode;
    }

    public Object getOperand() {
        return this.operand;
    }

    public void setOperand(Object operand) {
        this.operand = operand;
    }

    public int getValue() {
        return this.value;
    }

    public int getValue2() {
        return this.value2;
    }

    public void setValue2(int value2) {
        this.value2 = value2;
    }

    public void setValue(int value) {
        this.value = value;
    }
}

