/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.profiler.ui.profilingdatatable;

import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.m2m.atl.profiler.core.util.ProfilingModelUtils;
import org.eclipse.m2m.atl.profiler.model.ATLOperation;
import org.eclipse.m2m.atl.profiler.model.ProfilingOperation;

public class MemoryComparator
extends ViewerComparator {
    private ColumnType col;
    private boolean asc;

    public MemoryComparator(ColumnType c) {
        this.col = c;
        this.asc = true;
    }

    public MemoryComparator(ColumnType c, boolean asc) {
        this.col = c;
        this.asc = asc;
    }

    public int compare(Viewer viewer, Object e1, Object e2) {
        long iop1 = 0L;
        long iop2 = 0L;
        if (this.col == ColumnType.InMem) {
            if (e1 instanceof ATLOperation) {
                ATLOperation op1 = (ATLOperation)e1;
                ATLOperation op2 = (ATLOperation)e2;
                iop1 = ProfilingModelUtils.getMinInMemoryUsage((ATLOperation)op1);
                iop2 = ProfilingModelUtils.getMinInMemoryUsage((ATLOperation)op2);
            } else if (e1 instanceof ProfilingOperation) {
                ProfilingOperation pop1 = (ProfilingOperation)e1;
                ProfilingOperation pop2 = (ProfilingOperation)e2;
                iop1 = pop1.getLaunchedMemoryUsage();
                iop2 = pop2.getLaunchedMemoryUsage();
            }
        } else if (this.col == ColumnType.MaxMem) {
            if (e1 instanceof ATLOperation) {
                ATLOperation op1 = (ATLOperation)e1;
                ATLOperation op2 = (ATLOperation)e2;
                iop1 = ProfilingModelUtils.getMaxMaxMemoryUsage((ATLOperation)op1);
                iop2 = ProfilingModelUtils.getMaxMaxMemoryUsage((ATLOperation)op2);
            } else if (e1 instanceof ProfilingOperation) {
                ProfilingOperation pop1 = (ProfilingOperation)e1;
                ProfilingOperation pop2 = (ProfilingOperation)e2;
                iop1 = pop1.getMaxMemoryUsage();
                iop2 = pop2.getMaxMemoryUsage();
            }
        } else if (this.col == ColumnType.OutMem) {
            if (e1 instanceof ATLOperation) {
                ATLOperation op1 = (ATLOperation)e1;
                ATLOperation op2 = (ATLOperation)e2;
                iop1 = ProfilingModelUtils.getMaxOutMemoryUsage((ATLOperation)op1);
                iop2 = ProfilingModelUtils.getMaxOutMemoryUsage((ATLOperation)op2);
            } else if (e1 instanceof ProfilingOperation) {
                ProfilingOperation pop1 = (ProfilingOperation)e1;
                ProfilingOperation pop2 = (ProfilingOperation)e2;
                iop1 = pop1.getEndMemoryUsage();
                iop2 = pop2.getEndMemoryUsage();
            }
        }
        if (this.asc) {
            return (int)(iop1 - iop2);
        }
        return (int)(iop2 - iop1);
    }

    public ColumnType getCol() {
        return this.col;
    }

    public void setCol(ColumnType col) {
        this.col = col;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ColumnType {
        InMem,
        MaxMem,
        OutMem;

    }
}

