/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.dsls.core;

import java.io.OutputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.m2m.atl.core.emf.EMFModel;
import org.eclipse.m2m.atl.core.emf.EMFReferenceModel;
import org.eclipse.m2m.atl.dsls.tcs.extractor.ModelAdapter;
import org.eclipse.m2m.atl.dsls.tcs.extractor.PrettyPrinter;

public class EMFTCSExtractor {
    private static Map parameterTypes = new HashMap();

    static {
        parameterTypes.put("format", "Model:TCS");
        parameterTypes.put("indentString", "String");
        parameterTypes.put("standardSeparator", "String");
        parameterTypes.put("kwCheckIgnoreCase", "String");
        parameterTypes.put("identEsc", "String");
        parameterTypes.put("identEscStart", "String");
        parameterTypes.put("identEscEnd", "String");
        parameterTypes.put("stringDelim", "String");
        parameterTypes.put("debug", "String");
        parameterTypes.put("debugws", "String");
        parameterTypes.put("serializeComments", "String");
        parameterTypes.put("usePrimitiveTemplates", "String");
        parameterTypes.put("decimalFormat", "String");
        parameterTypes.put("stream", "TCSExtractorStream");
    }

    public Map getParameterTypes() {
        return parameterTypes;
    }

    public String getPrefix() {
        return "ebnf";
    }

    public void extract(EMFModel source, OutputStream target, Map params) {
        new PrettyPrinter().prettyPrint(source, new EMFExtractorAdapter(), target, params);
    }

    public class EMFExtractorAdapter
    implements ModelAdapter {
        public Object get(Object modelElement, String name) {
            if (modelElement == null) {
                return null;
            }
            EObject eo = (EObject)modelElement;
            EStructuralFeature sf = eo.eClass().getEStructuralFeature(name);
            if (sf == null) {
                return null;
            }
            return eo.eGet(sf);
        }

        public boolean getBool(Object me, String propName) {
            boolean ret = false;
            try {
                ret = (Boolean)this.get(me, propName);
            }
            catch (Exception e) {
                throw new RuntimeException("could not read property \"" + propName + "\" of element " + me + " : " + this.getTypeName(me), e);
            }
            return ret;
        }

        public boolean getBoolUndefinedIsFalse(Object me, String propName) {
            boolean ret = false;
            Object v = this.get(me, propName);
            if (v instanceof Boolean) {
                ret = (Boolean)v;
            }
            return ret;
        }

        public Iterator getCol(Object me, String propName) {
            return ((Collection)this.get(me, propName)).iterator();
        }

        public Set getElementsByType(Object model, String typeName) {
            EMFReferenceModel metamodel = ((EMFModel)model).getReferenceModel();
            return ((EMFModel)model).getElementsByType(metamodel.getMetaElementByName(typeName));
        }

        public int getInt(Object me, String propName) {
            return (Integer)this.get(me, propName);
        }

        public Object getME(Object me, String propName) {
            return this.get(me, propName);
        }

        public Object getMetaobject(Object me) {
            return ((EObject)me).eClass();
        }

        public String getString(Object me, String propName) {
            String ret = null;
            Object v = this.get(me, propName);
            if (v != null) {
                if (v instanceof Collection && ((Collection)v).size() == 1) {
                    v = ((Collection)v).iterator().next();
                }
                if (v instanceof String) {
                    ret = (String)v;
                } else if (v instanceof EEnumLiteral) {
                    ret = ((EEnumLiteral)v).getName();
                }
            }
            return ret;
        }

        public String getTypeName(Object me) {
            return this.getName(((EObject)me).eClass());
        }

        public String getName(Object ame) {
            return this.getString(ame, "name");
        }

        public Object refImmediateComposite(Object me) {
            return ((EObject)me).eContainer();
        }

        public boolean isAModelElement(Object o) {
            return o instanceof EObject;
        }

        public Object getPropertyType(Object f, String propName) {
            Object res = this.get(f, propName);
            if (res instanceof EObject) {
                return this.get(res, "eType");
            }
            return null;
        }

        public boolean isPrimitive(Object value) {
            return value instanceof String || value instanceof Boolean || value instanceof Double || value instanceof Integer;
        }

        public boolean isEnumLiteral(Object value) {
            return value instanceof EEnumLiteral;
        }

        public String getEnumLiteralName(Object me) {
            return this.getName(me).toString();
        }

        public String nextString(Iterator i) {
            return i.next().toString();
        }
    }
}

