/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.emftvm.jit;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.m2m.atl.common.ATLLogger;
import org.eclipse.m2m.atl.emftvm.CodeBlock;
import org.eclipse.m2m.atl.emftvm.ExecEnv;
import org.eclipse.m2m.atl.emftvm.Instruction;
import org.eclipse.m2m.atl.emftvm.jit.ByteCodeSwitch;
import org.eclipse.m2m.atl.emftvm.jit.JITCodeBlock;
import org.eclipse.m2m.atl.emftvm.jit.LabelSwitch;
import org.eclipse.m2m.atl.emftvm.util.StackFrame;
import org.eclipse.m2m.atl.emftvm.util.VMException;
import org.eclipse.m2m.atl.emftvm.util.VMMonitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;

public class CodeBlockJIT
implements Opcodes {
    public static final String BASE_PACKAGE = "org.eclipse.m2m.atl.emftvm.jit.generated";
    private int counter = 0;
    private boolean dumpBytecode = false;
    protected final Map<String, CodeBlock> codeBlocks = Collections.synchronizedMap(new HashMap());
    protected final JITClassLoader classLoader = new JITClassLoader(this.getClass().getClassLoader());
    protected final ExecEnv env;
    protected final Map<String, byte[]> byteCode = Collections.synchronizedMap(new HashMap());

    public CodeBlockJIT(ExecEnv env) {
        this.env = env;
    }

    public JITCodeBlock jit(CodeBlock cb) throws ClassNotFoundException, IllegalArgumentException, SecurityException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        String className = this.getNextClassName();
        this.codeBlocks.put(className, cb);
        try {
            return (JITCodeBlock)this.classLoader.findClass(className).getConstructor(CodeBlock.class).newInstance(cb);
        }
        catch (VerifyError e) {
            byte[] b = this.byteCode.get(className);
            if (b != null) {
                this.dumpByteCode(className, b);
            }
            throw e;
        }
    }

    protected synchronized String getNextClassName() {
        return "org.eclipse.m2m.atl.emftvm.jit.generated.CB" + this.counter++;
    }

    protected byte[] internalJit(CodeBlock cb, String className) {
        String internalName = className.replace('.', '/');
        ClassWriter cw = new ClassWriter(1);
        cw.visit(49, 1, internalName, null, Type.getInternalName(JITCodeBlock.class), new String[0]);
        CodeBlockJIT.generateConstructor(cw.visitMethod(1, "<init>", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.getType(CodeBlock.class)}), null, null), internalName);
        this.generateExecute(cw.visitMethod(1, "execute", Type.getMethodDescriptor((Type)Type.getType(Object.class), (Type[])new Type[]{Type.getType(StackFrame.class)}), null, null), cb, internalName);
        cw.visitEnd();
        return cw.toByteArray();
    }

    protected static void generateConstructor(MethodVisitor init, String className) {
        init.visitCode();
        Label start = new Label();
        Label end = new Label();
        init.visitLabel(start);
        init.visitVarInsn(25, 0);
        init.visitVarInsn(25, 1);
        init.visitMethodInsn(183, Type.getInternalName(JITCodeBlock.class), "<init>", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.getType(CodeBlock.class)}));
        init.visitInsn(177);
        init.visitLabel(end);
        init.visitLocalVariable("this", "L" + className + ";", null, start, end, 0);
        init.visitLocalVariable("cb", Type.getDescriptor(CodeBlock.class), null, start, end, 1);
        init.visitMaxs(2, 2);
        init.visitEnd();
    }

    protected void generateExecute(MethodVisitor execute, CodeBlock cb, String className) {
        boolean hasMonitor;
        execute.visitCode();
        LabelSwitch ls = new LabelSwitch();
        for (Instruction instr : cb.getCode()) {
            ls.doSwitch(instr);
        }
        Label start = new Label();
        Label end = new Label();
        Label tryStart = new Label();
        Label vmExceptionHandler = new Label();
        Label exceptionHandler = new Label();
        Label catchEnd = new Label();
        execute.visitTryCatchBlock(tryStart, vmExceptionHandler, vmExceptionHandler, Type.getInternalName(VMException.class));
        execute.visitTryCatchBlock(tryStart, vmExceptionHandler, exceptionHandler, Type.getInternalName(Exception.class));
        execute.visitLabel(start);
        execute.visitVarInsn(25, 1);
        execute.visitMethodInsn(182, Type.getInternalName(StackFrame.class), "getEnv", Type.getMethodDescriptor((Type)Type.getType(ExecEnv.class), (Type[])new Type[0]));
        execute.visitVarInsn(58, 2);
        execute.visitVarInsn(25, 2);
        execute.visitMethodInsn(185, Type.getInternalName(ExecEnv.class), "getMonitor", Type.getMethodDescriptor((Type)Type.getType(VMMonitor.class), (Type[])new Type[0]));
        execute.visitVarInsn(58, 3);
        boolean bl = hasMonitor = this.getEnv().getMonitor() != null;
        if (hasMonitor) {
            execute.visitVarInsn(25, 3);
            execute.visitVarInsn(25, 1);
            execute.visitMethodInsn(185, Type.getInternalName(VMMonitor.class), "enter", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.getType(StackFrame.class)}));
        }
        execute.visitLabel(tryStart);
        ByteCodeSwitch bs = new ByteCodeSwitch(this, execute, ls);
        EList<Instruction> code = cb.getCode();
        for (Instruction instr : code) {
            if (hasMonitor) {
                CodeBlockJIT.generateCheckMonitor(execute, code.indexOf((Object)instr) + 1);
            }
            bs.doSwitch(instr);
        }
        execute.visitJumpInsn(167, catchEnd);
        execute.visitLabel(vmExceptionHandler);
        execute.visitVarInsn(58, 4);
        execute.visitVarInsn(25, 4);
        execute.visitInsn(191);
        execute.visitLabel(exceptionHandler);
        execute.visitVarInsn(58, 4);
        execute.visitTypeInsn(187, Type.getInternalName(VMException.class));
        execute.visitInsn(89);
        execute.visitVarInsn(25, 1);
        execute.visitVarInsn(25, 4);
        execute.visitMethodInsn(183, Type.getInternalName(VMException.class), "<init>", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.getType(StackFrame.class), Type.getType(Throwable.class)}));
        execute.visitInsn(191);
        execute.visitLabel(catchEnd);
        if (hasMonitor) {
            execute.visitVarInsn(25, 3);
            execute.visitVarInsn(25, 1);
            execute.visitMethodInsn(185, Type.getInternalName(VMMonitor.class), "leave", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.getType(StackFrame.class)}));
        }
        if (cb.getStackLevel() == 0) {
            execute.visitInsn(1);
        }
        execute.visitInsn(176);
        execute.visitLabel(end);
        execute.visitLocalVariable("this", "L" + className + ";", null, start, end, 0);
        execute.visitLocalVariable("frame", Type.getDescriptor(StackFrame.class), null, start, end, 1);
        execute.visitLocalVariable("env", Type.getDescriptor(ExecEnv.class), null, start, end, 2);
        execute.visitLocalVariable("monitor", Type.getDescriptor(VMMonitor.class), null, start, end, 3);
        execute.visitLocalVariable("e", Type.getDescriptor(VMException.class), null, vmExceptionHandler, exceptionHandler, 4);
        execute.visitLocalVariable("e", Type.getDescriptor(Exception.class), null, exceptionHandler, catchEnd, 4);
        execute.visitMaxs(0, 0);
        execute.visitEnd();
    }

    protected static void generateCheckMonitor(MethodVisitor mv, int pc) {
        Label notTerminated = new Label();
        mv.visitVarInsn(25, 3);
        mv.visitMethodInsn(185, Type.getInternalName(VMMonitor.class), "isTerminated", Type.getMethodDescriptor((Type)Type.BOOLEAN_TYPE, (Type[])new Type[0]));
        mv.visitJumpInsn(153, notTerminated);
        mv.visitTypeInsn(187, Type.getInternalName(VMException.class));
        mv.visitInsn(89);
        mv.visitVarInsn(25, 1);
        mv.visitLdcInsn((Object)"Execution terminated.");
        mv.visitMethodInsn(183, Type.getInternalName(VMException.class), "<init>", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.getType(StackFrame.class), Type.getType(String.class)}));
        mv.visitInsn(191);
        mv.visitLabel(notTerminated);
        mv.visitVarInsn(25, 1);
        CodeBlockJIT.generatePushInt(mv, pc);
        mv.visitMethodInsn(182, Type.getInternalName(StackFrame.class), "setPc", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.INT_TYPE}));
        mv.visitVarInsn(25, 3);
        mv.visitVarInsn(25, 1);
        mv.visitMethodInsn(185, Type.getInternalName(VMMonitor.class), "step", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.getType(StackFrame.class)}));
    }

    public ExecEnv getEnv() {
        return this.env;
    }

    static void generatePushInt(MethodVisitor mv, int value) {
        block14: {
            block13: {
                if (value < -1 || value > 5) break block13;
                switch (value) {
                    case -1: {
                        mv.visitInsn(2);
                        break block14;
                    }
                    case 0: {
                        mv.visitInsn(3);
                        break block14;
                    }
                    case 1: {
                        mv.visitInsn(4);
                        break block14;
                    }
                    case 2: {
                        mv.visitInsn(5);
                        break block14;
                    }
                    case 3: {
                        mv.visitInsn(6);
                        break block14;
                    }
                    case 4: {
                        mv.visitInsn(7);
                        break block14;
                    }
                    default: {
                        mv.visitInsn(8);
                        assert (value == 5);
                        break block14;
                    }
                }
            }
            if (value < 127 && value > -128) {
                mv.visitIntInsn(16, value);
            } else if (value < Short.MAX_VALUE && value > Short.MIN_VALUE) {
                mv.visitIntInsn(17, value);
            } else {
                mv.visitLdcInsn((Object)value);
            }
        }
    }

    public boolean isDumpBytecode() {
        return this.dumpBytecode;
    }

    public void setDumpBytecode(boolean dumpBytecode) {
        this.dumpBytecode = dumpBytecode;
    }

    public synchronized void cleanup() {
        for (CodeBlock cb : this.codeBlocks.values()) {
            cb.setJITCodeBlock(null);
        }
        this.codeBlocks.clear();
        this.byteCode.clear();
    }

    private void dumpByteCode(String name, byte[] b) {
        try {
            String path = name.substring(0, name.lastIndexOf(46)).replace('.', File.separatorChar);
            File p = new File(String.valueOf(System.getProperty("java.io.tmpdir")) + File.separatorChar + path);
            p.mkdirs();
            File f = new File(p, String.valueOf(name.substring(name.lastIndexOf(46) + 1)) + ".class");
            f.createNewFile();
            FileOutputStream fos = new FileOutputStream(f);
            try {
                fos.write(b);
            }
            finally {
                fos.close();
            }
            ATLLogger.info((String)String.format("Wrote JIT-ed code block %s to %s", this.codeBlocks.get(name), f.getAbsolutePath()));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class JITClassLoader
    extends ClassLoader {
        public JITClassLoader(ClassLoader parent) {
            super(parent);
        }

        @Override
        protected Class<?> findClass(String name) throws ClassNotFoundException {
            if (CodeBlockJIT.this.codeBlocks.containsKey(name)) {
                byte[] b = CodeBlockJIT.this.internalJit(CodeBlockJIT.this.codeBlocks.get(name), name);
                CodeBlockJIT.this.byteCode.put(name, b);
                if (CodeBlockJIT.this.isDumpBytecode()) {
                    CodeBlockJIT.this.dumpByteCode(name, b);
                }
                return this.defineClass(name, b, 0, b.length);
            }
            return super.findClass(name);
        }
    }
}

