/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.emftvm.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.m2m.atl.emftvm.CodeBlock;
import org.eclipse.m2m.atl.emftvm.util.LazyCollection;
import org.eclipse.m2m.atl.emftvm.util.LazySet;
import org.eclipse.m2m.atl.emftvm.util.StackFrame;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LazyBag<E>
extends LazyCollection<E> {
    public LazyBag() {
    }

    public LazyBag(Iterable<E> dataSource) {
        super(dataSource);
    }

    @Override
    protected void createCache() {
        super.createCache();
        if (this.cache == null) {
            this.cache = new ArrayList();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LazyCollection)) {
            return false;
        }
        try {
            Object e;
            LazyCollection other = (LazyCollection)o;
            LazySet keys = this.asSet().union(other.asSet());
            Iterator iterator = keys.iterator();
            do {
                if (iterator.hasNext()) continue;
                return true;
            } while (this.count(e = iterator.next()) == other.count(e));
            return false;
        }
        catch (ClassCastException unused) {
            return false;
        }
        catch (NullPointerException unused) {
            return false;
        }
    }

    @Override
    public int hashCode() {
        int hashCode = 0;
        for (Object obj : this) {
            if (obj == null) continue;
            hashCode += obj.hashCode();
        }
        return hashCode;
    }

    public LazyBag<E> union(LazyBag<E> bag) {
        return new UnionBag<E>(bag, this);
    }

    public LazyBag<E> union(LazySet<E> set) {
        return new UnionBag<E>(set, this);
    }

    public LazyBag<E> intersection(final LazyBag<E> bag) {
        return new LazyBag<E>(this){

            @Override
            public Iterator<E> iterator() {
                if (this.dataSource == null) {
                    return Collections.unmodifiableCollection(this.cache).iterator();
                }
                return new LazyCollection.CachingIterator(this, new BagIntersectionIterator(bag));
            }
        };
    }

    public LazySet<E> intersection(LazySet<E> set) {
        final LazyBag inner = this;
        return new LazySet<E>(set){

            @Override
            public Iterator<E> iterator() {
                if (this.dataSource == null) {
                    return Collections.unmodifiableCollection(this.cache).iterator();
                }
                return new LazyCollection.IntersectionIterator((LazyCollection)this, inner);
            }
        };
    }

    @Override
    public LazyBag<E> including(E object) {
        return new IncludingBag<E>(object, this);
    }

    public LazyBag<E> excluding(final E object) {
        return new LazyBag<E>(this){

            @Override
            public Iterator<E> iterator() {
                if (this.dataSource == null) {
                    return Collections.unmodifiableCollection(this.cache).iterator();
                }
                return new LazyCollection.ExcludingIterator((LazyCollection)this, object);
            }
        };
    }

    public LazyBag<?> flatten() {
        final LazyBag inner = this;
        return new LazyBag<Object>(new Iterable<Object>(){

            @Override
            public Iterator<Object> iterator() {
                return new LazyCollection.FlattenIterator(inner);
            }
        });
    }

    @Override
    public LazyBag<E> asBag() {
        return this;
    }

    public LazyBag<E> select(final CodeBlock condition) {
        final StackFrame parentFrame = condition.getParentFrame();
        return new LazyBag<E>(this){

            @Override
            public Iterator<E> iterator() {
                if (this.dataSource == null) {
                    return Collections.unmodifiableCollection(this.cache).iterator();
                }
                return new LazyCollection.SelectIterator(this, condition, parentFrame);
            }
        };
    }

    public LazyBag<E> reject(final CodeBlock condition) {
        final StackFrame parentFrame = condition.getParentFrame();
        return new LazyBag<E>(this){

            @Override
            public Iterator<E> iterator() {
                if (this.dataSource == null) {
                    return Collections.unmodifiableCollection(this.cache).iterator();
                }
                return new LazyCollection.RejectIterator(this, condition, parentFrame);
            }
        };
    }

    public <T> LazyBag<T> collect(final CodeBlock function) {
        final StackFrame parentFrame = function.getParentFrame();
        final LazyBag inner = this;
        return new LazyBag<E>(new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return new LazyCollection.CollectIterator(inner, function, parentFrame);
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class BagIntersectionIterator
    extends LazyCollection.ReadOnlyIterator<E> {
        final Iterator<E> inner;
        final Collection<E> s;
        final Map<E, Integer> sOcc;
        E next;
        boolean nextSet;

        public BagIntersectionIterator(LazyCollection<E> s) {
            this.inner = LazyBag.this.iterator();
            this.s = s;
            if (s.occurrences != null) {
                this.sOcc = new HashMap(s.occurrences);
            } else {
                this.sOcc = new HashMap();
                for (Object e : s) {
                    if (this.sOcc.containsKey(e)) {
                        this.sOcc.put(e, this.sOcc.get(e) + 1);
                        continue;
                    }
                    this.sOcc.put(e, 1);
                }
            }
        }

        @Override
        public boolean hasNext() {
            if (!this.nextSet && this.inner.hasNext()) {
                this.next = this.inner.next();
                this.nextSet = true;
            }
            while ((!this.sOcc.containsKey(this.next) || this.sOcc.get(this.next) == 0) && this.inner.hasNext()) {
                this.next = this.inner.next();
            }
            return this.sOcc.containsKey(this.next) && this.sOcc.get(this.next) > 0;
        }

        @Override
        public E next() {
            if (!this.nextSet) {
                this.next = this.inner.next();
            } else {
                this.nextSet = false;
            }
            while (!this.sOcc.containsKey(this.next) || this.sOcc.get(this.next) == 0) {
                this.next = this.inner.next();
            }
            assert (!this.nextSet && this.sOcc.containsKey(this.next) && this.sOcc.get(this.next) > 0);
            this.sOcc.put(this.next, this.sOcc.get(this.next) - 1);
            return this.next;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class IncludingBag<E>
    extends LazyBag<E> {
        protected final E object;

        public IncludingBag(E object, LazyCollection<E> dataSource) {
            super(dataSource);
            this.object = object;
        }

        @Override
        public boolean contains(Object o) {
            return !(this.object == null ? o != null : !this.object.equals(o)) || ((Collection)this.dataSource).contains(o);
        }

        @Override
        public int count(E o) {
            return (this.object == null ? o == null : this.object.equals(o)) ? 1 : 0 + ((LazyCollection)this.dataSource).count(o);
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public Iterator<E> iterator() {
            return new LazyCollection.AppendIterator(this, this.object);
        }

        @Override
        public int size() {
            return ((Collection)this.dataSource).size() + 1;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class UnionBag<E>
    extends LazyBag<E> {
        protected final LazyCollection<E> other;

        public UnionBag(LazyCollection<E> other, LazyCollection<E> dataSource) {
            super(dataSource);
            this.other = other;
        }

        @Override
        public boolean contains(Object o) {
            return ((Collection)this.dataSource).contains(o) || this.other.contains(o);
        }

        @Override
        public int count(E object) {
            return ((LazyCollection)this.dataSource).count(object) + this.other.count(object);
        }

        @Override
        public boolean isEmpty() {
            return ((Collection)this.dataSource).isEmpty() && this.other.isEmpty();
        }

        @Override
        public Iterator<E> iterator() {
            return new LazyCollection.UnionIterator(this, this.other);
        }

        @Override
        public int size() {
            return ((Collection)this.dataSource).size() + this.other.size();
        }
    }
}

