/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.adt.ui.text;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.resources.IMarker;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.ui.texteditor.MarkerAnnotation;

public class AtlAnnotationHover
implements IAnnotationHover {
    public String getHoverInfo(ISourceViewer sourceViewer, int lineNumber) {
        String[] messages = this.getMessagesForLine(sourceViewer, lineNumber);
        if (messages.length == 0) {
            return null;
        }
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < messages.length) {
            buffer.append(messages[i]);
            if (i < messages.length - 1) {
                buffer.append(System.getProperty("line.separator"));
            }
            ++i;
        }
        return buffer.toString();
    }

    private String[] getMessagesForLine(ISourceViewer viewer, int line) {
        IDocument document = viewer.getDocument();
        IAnnotationModel model = viewer.getAnnotationModel();
        if (model == null) {
            return new String[0];
        }
        ArrayList<String> messages = new ArrayList<String>();
        Iterator iter = model.getAnnotationIterator();
        while (iter.hasNext()) {
            IMarker marker;
            String message;
            MarkerAnnotation annotation;
            Object object = iter.next();
            if (!(object instanceof MarkerAnnotation) || !this.compareRulerLine(model.getPosition((Annotation)(annotation = (MarkerAnnotation)object)), document, line) || (message = (marker = annotation.getMarker()).getAttribute("message", null)) == null || message.trim().length() <= 0) continue;
            messages.add(message);
        }
        return messages.toArray(new String[messages.size()]);
    }

    private boolean compareRulerLine(Position position, IDocument document, int line) {
        try {
            if (position.getOffset() > -1 && position.getLength() > -1) {
                return document.getLineOfOffset(position.getOffset()) == line;
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return false;
    }
}

