/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.telemetry.tracing.tck.spi;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.context.propagation.TextMapPropagator;
import io.opentelemetry.sdk.autoconfigure.spi.AutoConfigurationCustomizer;
import io.opentelemetry.sdk.autoconfigure.spi.AutoConfigurationCustomizerProvider;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigProperties;
import io.opentelemetry.sdk.trace.SdkTracerProviderBuilder;
import io.opentelemetry.sdk.trace.export.SpanExporter;
import io.opentelemetry.sdk.trace.samplers.Sampler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class TestCustomizer
implements AutoConfigurationCustomizerProvider {
    public static final AttributeKey<String> TEST_KEY = AttributeKey.stringKey((String)"test-key");
    public static final String TEST_VALUE = "test-value";
    public static final List<String> LOGGED_EVENTS = new ArrayList<String>();

    public void customize(AutoConfigurationCustomizer autoConfiguration) {
        autoConfiguration.addResourceCustomizer((r, c) -> r.toBuilder().put(TEST_KEY, (Object)TEST_VALUE).build());
        autoConfiguration.addPropagatorCustomizer(this::customizePropagator);
        autoConfiguration.addPropertiesCustomizer(this::customizeProperties);
        autoConfiguration.addSamplerCustomizer(this::customizeSampler);
        autoConfiguration.addSpanExporterCustomizer(this::customizeExporter);
        autoConfiguration.addTracerProviderCustomizer(this::customizeTracer);
    }

    private TextMapPropagator customizePropagator(TextMapPropagator propagator, ConfigProperties config) {
        LOGGED_EVENTS.add("propagator");
        return propagator;
    }

    private Map<String, String> customizeProperties(ConfigProperties config) {
        LOGGED_EVENTS.add("properties");
        return Collections.emptyMap();
    }

    private Sampler customizeSampler(Sampler sampler, ConfigProperties config) {
        LOGGED_EVENTS.add("sampler");
        return sampler;
    }

    private SpanExporter customizeExporter(SpanExporter exporter, ConfigProperties config) {
        LOGGED_EVENTS.add("exporter");
        return exporter;
    }

    private SdkTracerProviderBuilder customizeTracer(SdkTracerProviderBuilder tracerBuilder, ConfigProperties config) {
        LOGGED_EVENTS.add("tracer");
        return tracerBuilder;
    }
}

