/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.telemetry.tracing.tck.porting;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Executor;
import org.eclipse.microprofile.telemetry.tracing.tck.porting.api.Configuration;

public class PropertiesBasedConfigurationBuilder {
    public static final String RESOURCE_BUNDLE = "META-INF/microprofile-telemetry-tck.properties";

    public Configuration build(boolean deploymentPhase) {
        Configuration configuration = new Configuration();
        configuration.setExecutor(this.getInstanceValue("telemetry.tck.executor", Executor.class, !deploymentPhase));
        return configuration;
    }

    protected <T> Class<T> getClassValue(String propertyName, Class<T> expectedType, boolean required) {
        HashSet classes = new HashSet();
        for (String className : this.getPropertyValues(propertyName)) {
            ClassLoader currentThreadClassLoader = Thread.currentThread().getContextClassLoader();
            try {
                if (currentThreadClassLoader != null) {
                    classes.add(currentThreadClassLoader.loadClass(className));
                    continue;
                }
                classes.add(Class.forName(className));
            }
            catch (ClassNotFoundException | LinkageError e) {
                throw new IllegalArgumentException("Implementation class with name " + className + " not found using classloader " + (currentThreadClassLoader != null ? currentThreadClassLoader : this.getClass().getClassLoader()), e);
            }
        }
        if (classes.size() == 0) {
            if (required) {
                throw new IllegalArgumentException("Cannot find any implementations of " + expectedType.getSimpleName() + ", check that " + propertyName + " is specified");
            }
            return null;
        }
        if (classes.size() > 1) {
            throw new IllegalArgumentException("More than one implementation of " + expectedType.getSimpleName() + " specified by " + propertyName + ", not sure which one to use!");
        }
        return (Class)classes.iterator().next();
    }

    protected <T> T getInstanceValue(String propertyName, Class<T> expectedType, boolean required) {
        T instance = null;
        Class<T> clazz = this.getClassValue(propertyName, expectedType, required);
        if (clazz != null) {
            try {
                instance = clazz.newInstance();
            }
            catch (InstantiationException e) {
                throw new IllegalStateException("Error instantiating " + clazz + " specified by " + propertyName, e);
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException("Error instantiating " + clazz + " specified by " + propertyName, e);
            }
        }
        return instance;
    }

    public Set<String> getPropertyValues(String key) {
        HashSet<String> values = new HashSet<String>();
        this.addPropertiesFromSystem(key, values);
        this.addPropertiesFromResourceBundle(key, values);
        return values;
    }

    private void addPropertiesFromSystem(String key, Set<String> values) {
        this.addProperty(key, System.getProperty(key), values);
    }

    private void addPropertiesFromResourceBundle(String key, Set<String> values) {
        this.addPropertiesFromResourceBundle(key, values, new StringBuilder());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addPropertiesFromResourceBundle(String key, Set<String> values, StringBuilder info) {
        try {
            int count = 0;
            Enumeration<URL> e = this.getResources(RESOURCE_BUNDLE);
            while (e.hasMoreElements()) {
                URL url = e.nextElement();
                Properties properties = new Properties();
                InputStream propertyStream = url.openStream();
                try {
                    properties.load(propertyStream);
                    String value = properties.getProperty(key);
                    if (value == null) continue;
                    values.add(value);
                    info.append(String.format("\t%d: %s=%s\n", count++, url.toExternalForm(), value));
                }
                finally {
                    if (propertyStream == null) continue;
                    propertyStream.close();
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void addProperty(String key, String value, Set<String> values) {
        if (value != null) {
            values.add(value);
        }
    }

    public Enumeration<URL> getResources(String name) throws IOException {
        if (Thread.currentThread().getContextClassLoader() != null) {
            return Thread.currentThread().getContextClassLoader().getResources(name);
        }
        return this.getClass().getClassLoader().getResources(name);
    }
}

